/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"trim", "btrim"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the result of deleting spaces before and after the 'str'."}, examples={"trim(' in long ') = \"in long\""})
public class TrimFunction
implements ValueParser {
    private ValueParser stringParser;

    public TrimFunction(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        return OperatorTools.parseString(stringObj).trim();
    }
}

