/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.operator;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.commons.lang.ObjectUtils;
import org.apache.inlong.sdk.transform.process.function.FunctionTools;
import org.apache.inlong.sdk.transform.process.operator.ExpressionOperator;
import org.apache.inlong.sdk.transform.process.operator.TransformOperator;
import org.apache.inlong.sdk.transform.process.parser.ColumnParser;
import org.apache.inlong.sdk.transform.process.parser.ParserTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorTools {
    private static final Logger log = LoggerFactory.getLogger(OperatorTools.class);
    private static final String OPERATOR_PATH = "org.apache.inlong.sdk.transform.process.operator";
    private static final Map<Class<?>, Class<?>> operatorMap = Maps.newConcurrentMap();
    public static final String ROOT_KEY = "$root";
    public static final String CHILD_KEY = "$child";

    private static void init() {
        Reflections reflections = new Reflections(OPERATOR_PATH, new Scanner[]{new TypeAnnotationsScanner(), new SubTypesScanner()});
        Set clazzSet = reflections.getTypesAnnotatedWith(TransformOperator.class);
        for (Class clazz : clazzSet) {
            Class<?>[] values;
            TransformOperator annotation;
            if (!ExpressionOperator.class.isAssignableFrom(clazz) || (annotation = clazz.getAnnotation(TransformOperator.class)) == null) continue;
            for (Class<?> value : values = annotation.values()) {
                operatorMap.compute(value, (key, former) -> {
                    if (former != null) {
                        log.warn("find a conflict for parser class [{}], the former one is [{}], new one is [{}]", new Object[]{key, former.getName(), clazz.getName()});
                    }
                    return clazz;
                });
            }
        }
    }

    public static ExpressionOperator getTransformOperator(Expression expr) {
        Class<?> clazz = operatorMap.get(expr.getClass());
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(expr.getClass());
            return (ExpressionOperator)constructor.newInstance(expr);
        }
        catch (NoSuchMethodException e) {
            log.error("transform operator {} needs one constructor that accept one params whose type is {}", new Object[]{clazz.getName(), expr.getClass().getName(), e});
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ExpressionOperator buildOperator(Expression expr) {
        if (expr != null) {
            return OperatorTools.getTransformOperator(expr);
        }
        return null;
    }

    public static ValueParser buildParser(Expression expr) {
        if (expr instanceof Function) {
            String exprString = expr.toString();
            if (exprString.startsWith(ROOT_KEY) || exprString.startsWith(CHILD_KEY)) {
                return new ColumnParser((Function)expr);
            }
            return FunctionTools.getTransformFunction((Function)expr);
        }
        return ParserTools.getTransformParser(expr);
    }

    public static BigDecimal parseBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(String.valueOf(value));
    }

    public static String parseString(Object value) {
        return value.toString();
    }

    public static Date parseDate(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        return Date.valueOf(String.valueOf(value));
    }

    public static Timestamp parseTimestamp(Object value) {
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        return Timestamp.valueOf(String.valueOf(value));
    }

    public static byte[] parseBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        return String.valueOf(value).getBytes(StandardCharsets.UTF_8);
    }

    public static boolean parseBoolean(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(String.valueOf(value));
    }

    public static int compareValue(Comparable left, Comparable right) {
        if (left == null) {
            return right == null ? 0 : -1;
        }
        if (right == null) {
            return 1;
        }
        if (left.getClass() == right.getClass()) {
            return ObjectUtils.compare((Comparable)left, (Comparable)right);
        }
        try {
            BigDecimal leftValue = OperatorTools.parseBigDecimal(left);
            BigDecimal rightValue = OperatorTools.parseBigDecimal(right);
            return ObjectUtils.compare((Comparable)leftValue, (Comparable)rightValue);
        }
        catch (Exception e) {
            String leftValue = OperatorTools.parseString(left);
            String rightValue = OperatorTools.parseString(right);
            return ObjectUtils.compare((Comparable)((Object)leftValue), (Comparable)((Object)rightValue));
        }
    }

    static {
        OperatorTools.init();
    }
}

