/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.channel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.Transaction;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.interceptor.Interceptor;
import org.apache.flume.interceptor.InterceptorBuilderFactory;
import org.apache.flume.interceptor.InterceptorChain;
import org.apache.inlong.common.monitor.LogCounter;
import org.apache.inlong.dataproxy.exception.MainChannelFullException;
import org.apache.inlong.dataproxy.utils.MessageUtils;
import org.apache.inlong.sdk.commons.protocol.ProxyPackEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverChannelProcessor
extends ChannelProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FailoverChannelProcessor.class);
    private static final LogCounter logPrinter = new LogCounter(10, 10000, 60000);
    private final ChannelSelector selector;
    private final InterceptorChain interceptorChain;

    public FailoverChannelProcessor(ChannelSelector selector) {
        super(selector);
        this.selector = selector;
        this.interceptorChain = new InterceptorChain();
    }

    public void initialize() {
        this.interceptorChain.initialize();
    }

    public void close() {
        this.interceptorChain.close();
    }

    public void configure(Context context) {
        this.configureInterceptors(context);
    }

    private void configureInterceptors(Context context) {
        LinkedList interceptors = Lists.newLinkedList();
        String interceptorListStr = context.getString("interceptors", "");
        if (interceptorListStr.isEmpty()) {
            return;
        }
        String[] interceptorNames = interceptorListStr.split("\\s+");
        Context interceptorContexts = new Context(context.getSubProperties("interceptors."));
        InterceptorBuilderFactory factory = new InterceptorBuilderFactory();
        for (String interceptorName : interceptorNames) {
            Context interceptorContext = new Context(interceptorContexts.getSubProperties(interceptorName + "."));
            String type = interceptorContext.getString("type");
            if (type == null) {
                LOG.error("Type not specified for interceptor " + interceptorName);
                throw new FlumeException("Interceptor.Type not specified for " + interceptorName);
            }
            try {
                Interceptor.Builder builder = InterceptorBuilderFactory.newInstance((String)type);
                builder.configure(interceptorContext);
                interceptors.add(builder.build());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Builder class not found. Exception follows.", (Throwable)e);
                throw new FlumeException("Interceptor.Builder not found.", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOG.error("Could not instantiate Builder. Exception follows.", (Throwable)e);
                throw new FlumeException("Interceptor.Builder not constructable.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.error("Unable to access Builder. Exception follows.", (Throwable)e);
                throw new FlumeException("Unable to access Interceptor.Builder.", (Throwable)e);
            }
        }
        this.interceptorChain.setInterceptors((List)interceptors);
    }

    public ChannelSelector getSelector() {
        return this.selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEventBatch(List<Event> events) {
        List batch;
        Transaction tx;
        Preconditions.checkNotNull(events, (Object)"Event list must not be null");
        events = this.interceptorChain.intercept(events);
        LinkedHashMap<Channel, List> reqChannelQueue = new LinkedHashMap<Channel, List>();
        LinkedHashMap<Channel, List> optChannelQueue = new LinkedHashMap<Channel, List>();
        long tMsgCounterL = 1L;
        for (Event event : events) {
            Object ch2;
            tMsgCounterL = event.getHeaders().containsKey("msgcnt") ? (tMsgCounterL += Long.parseLong((String)event.getHeaders().get("msgcnt"))) : ++tMsgCounterL;
            List reqChannels = this.selector.getRequiredChannels(event);
            for (Object ch2 : reqChannels) {
                List eventQueue = reqChannelQueue.computeIfAbsent((Channel)ch2, k -> new ArrayList());
                eventQueue.add(event);
            }
            List optChannels = this.selector.getOptionalChannels(event);
            ch2 = optChannels.iterator();
            while (ch2.hasNext()) {
                Channel ch3 = (Channel)ch2.next();
                List eventQueue = optChannelQueue.computeIfAbsent(ch3, k -> new ArrayList());
                eventQueue.add(event);
            }
        }
        boolean success = true;
        for (Map.Entry entry : reqChannelQueue.entrySet()) {
            Channel reqChannel = (Channel)entry.getKey();
            tx = reqChannel.getTransaction();
            Preconditions.checkNotNull((Object)tx, (Object)"Transaction object must not be null");
            try {
                tx.begin();
                batch = (List)entry.getValue();
                for (Event event : batch) {
                    reqChannel.put(event);
                }
                tx.commit();
            }
            catch (Throwable t) {
                success = false;
                tx.rollback();
                if (t instanceof ChannelException) break;
                LOG.error("Unable to put batch on required channel: " + reqChannel, t);
                if (!(t instanceof Error)) break;
                throw (Error)t;
            }
            finally {
                tx.close();
            }
        }
        if (!success) {
            for (Map.Entry entry : optChannelQueue.entrySet()) {
                Channel optChannel = (Channel)entry.getKey();
                tx = optChannel.getTransaction();
                Preconditions.checkNotNull((Object)tx, (Object)"Transaction object must not be null");
                try {
                    tx.begin();
                    batch = (List)entry.getValue();
                    for (Event event : batch) {
                        optChannel.put(event);
                    }
                    tx.commit();
                }
                catch (Throwable t) {
                    tx.rollback();
                    if (t instanceof Error) {
                        LOG.error("Error while writing to optChannel channel: " + optChannel, t);
                        throw (Error)t;
                    }
                    throw new ChannelException("Unable to put batch on optChannel channel: " + optChannel, t);
                }
                finally {
                    tx.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processEvent(Event event) {
        if ((event = this.interceptorChain.intercept(event)) == null) {
            return;
        }
        String errMsg = "";
        boolean success = true;
        List requiredChannels = this.selector.getRequiredChannels(event);
        for (Channel reqChannel : requiredChannels) {
            Transaction tx = reqChannel.getTransaction();
            Preconditions.checkNotNull((Object)tx, (Object)"Transaction object must not be null");
            try {
                tx.begin();
                reqChannel.put(event);
                tx.commit();
            }
            catch (Throwable t) {
                errMsg = "Unable to put event on channel " + reqChannel.getName() + ", error message is " + t.getMessage();
                if (logPrinter.shouldPrint()) {
                    LOG.error("FailoverChannelProcessor Unable to put event on required channel: " + reqChannel.getName(), t);
                }
                success = false;
                try {
                    tx.rollback();
                }
                catch (Throwable e) {
                    if (!logPrinter.shouldPrint()) break;
                    LOG.error("FailoverChannelProcessor Transaction rollback exception", e);
                }
                break;
            }
            finally {
                tx.close();
            }
        }
        if (!success) {
            if (MessageUtils.isSyncSendForOrder(event) || event instanceof ProxyPackEvent) {
                throw new MainChannelFullException(errMsg);
            }
            List optionalChannels = this.selector.getOptionalChannels(event);
            for (Channel optChannel : optionalChannels) {
                Transaction tx = null;
                try {
                    tx = optChannel.getTransaction();
                    tx.begin();
                    optChannel.put(event);
                    tx.commit();
                }
                catch (Throwable t) {
                    block24: {
                        if (logPrinter.shouldPrint()) {
                            LOG.error("FailoverChannelProcessor Unable to put event on optionalChannel:", t);
                        }
                        if (tx != null) {
                            try {
                                tx.rollback();
                            }
                            catch (Throwable e) {
                                if (!logPrinter.shouldPrint()) break block24;
                                LOG.error("FailoverChannelProcessor Transaction rollback exception", e);
                            }
                        }
                    }
                    if (t instanceof Error) {
                        if (logPrinter.shouldPrint()) {
                            LOG.error("FailoverChannelProcessor Error while writing event to optionalChannels: " + optChannel, t);
                        }
                        throw (Error)t;
                    }
                    throw new ChannelException("FailoverChannelProcessor Unable to put event on optionalChannels: " + optChannel, t);
                }
                finally {
                    if (tx == null) continue;
                    tx.close();
                }
            }
        }
    }
}

