/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.dataproxy.config.holder;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.dataproxy.config.holder.PropertiesHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupIdNumConfigHolder
extends PropertiesHolder {
    private static final String groupIdNumConfigFileName = "groupid_mapping.properties";
    private static final String GROUPID_VALUE_SPLITTER = "#";
    private static final Logger LOG = LoggerFactory.getLogger(GroupIdNumConfigHolder.class);
    private final ConcurrentHashMap<String, String> groupIdNumMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, String>> streamIdNumMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Boolean> groupIdNumEnableMap = new ConcurrentHashMap();

    public GroupIdNumConfigHolder() {
        super(groupIdNumConfigFileName);
    }

    public boolean isEnableNum2NameTrans(String groupIdNum) {
        return this.groupIdNumEnableMap.getOrDefault(groupIdNum, Boolean.FALSE);
    }

    public String getGroupIdNameByNum(String groupIdNum) {
        return this.groupIdNumMap.get(groupIdNum);
    }

    public String getStreamIdNameByIdNum(String groupIdNum, String streamIdNum) {
        ConcurrentHashMap<String, String> tmpMap = this.streamIdNumMap.get(groupIdNum);
        if (tmpMap == null) {
            return null;
        }
        return tmpMap.get(streamIdNum);
    }

    public boolean isGroupIdNumConfigEmpty() {
        return this.groupIdNumMap.isEmpty();
    }

    public boolean isStreamIdNumConfigEmpty() {
        return this.streamIdNumMap.isEmpty();
    }

    public ConcurrentHashMap<String, String> getGroupIdNumMap() {
        return this.groupIdNumMap;
    }

    public ConcurrentHashMap<String, ConcurrentHashMap<String, String>> getStreamIdNumMap() {
        return this.streamIdNumMap;
    }

    public ConcurrentHashMap<String, Boolean> getGroupIdNumEnableMap() {
        return this.groupIdNumEnableMap;
    }

    @Override
    protected Map<String, String> filterInValidRecords(Map<String, String> configMap) {
        HashMap<String, String> result = new HashMap<String, String>(configMap.size());
        for (Map.Entry<String, String> entry : configMap.entrySet()) {
            String[] keyArray;
            if (entry == null || StringUtils.isBlank((CharSequence)entry.getKey()) || !entry.getKey().contains(GROUPID_VALUE_SPLITTER) || (keyArray = StringUtils.split((String)entry.getKey(), (String)GROUPID_VALUE_SPLITTER)).length != 3 || StringUtils.isBlank((CharSequence)keyArray[0]) || StringUtils.isBlank((CharSequence)keyArray[1]) || StringUtils.isBlank((CharSequence)keyArray[2])) continue;
            if (StringUtils.isNotBlank((CharSequence)entry.getValue())) {
                try {
                    MAP_SPLITTER.split((CharSequence)entry.getValue());
                }
                catch (Throwable e) {
                    continue;
                }
            }
            result.put(entry.getKey().trim(), entry.getValue().trim());
        }
        return result;
    }

    @Override
    protected boolean updateCacheData() {
        Map tmpValueMap = new HashMap();
        HashMap<String, String> valueMap = new HashMap<String, String>();
        HashMap<String, String> tmpGroupIdNumMap = new HashMap<String, String>();
        HashMap<String, Map<String, String>> tmpStreamIdNumMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Boolean> tmpGroupIdNumEnableMap = new HashMap<String, Boolean>();
        for (Map.Entry entry : this.confHolder.entrySet()) {
            String[] keyArray;
            if (entry == null || StringUtils.isBlank((CharSequence)((CharSequence)entry.getKey())) || !((String)entry.getKey()).contains(GROUPID_VALUE_SPLITTER) || (keyArray = StringUtils.split((String)((String)entry.getKey()), (String)GROUPID_VALUE_SPLITTER)).length != 3 || StringUtils.isBlank((CharSequence)keyArray[0]) || StringUtils.isBlank((CharSequence)keyArray[1]) || StringUtils.isBlank((CharSequence)keyArray[2])) continue;
            boolean tmpEnable = Boolean.parseBoolean(keyArray[2].trim());
            tmpGroupIdNumMap.put(keyArray[0].trim(), keyArray[1].trim());
            tmpGroupIdNumEnableMap.put(keyArray[0].trim(), tmpEnable);
            if (!StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
            tmpValueMap.clear();
            valueMap.clear();
            try {
                tmpValueMap = MAP_SPLITTER.split((CharSequence)entry.getValue());
            }
            catch (Throwable e) {
                continue;
            }
            if (tmpValueMap.isEmpty()) continue;
            for (Map.Entry entry1 : tmpValueMap.entrySet()) {
                if (entry1 == null || StringUtils.isBlank((CharSequence)((CharSequence)entry1.getKey())) || StringUtils.isBlank((CharSequence)((CharSequence)entry1.getValue()))) continue;
                valueMap.put(((String)entry1.getKey()).trim(), ((String)entry.getValue()).trim());
            }
            if (valueMap.isEmpty()) continue;
            tmpStreamIdNumMap.put(keyArray[0].trim(), valueMap);
        }
        this.updateCachedGroupIdNumMap(tmpGroupIdNumMap);
        this.updateCachedGroupIdNumEnableMap(tmpGroupIdNumEnableMap);
        this.updateCachedStreamIdNumMap(tmpStreamIdNumMap);
        return true;
    }

    private void updateCachedGroupIdNumMap(Map<String, String> newGroupIdNumMap) {
        if (newGroupIdNumMap.isEmpty()) {
            this.groupIdNumMap.clear();
            return;
        }
        for (Map.Entry<String, String> entry : newGroupIdNumMap.entrySet()) {
            if (entry.getValue().equals(this.groupIdNumMap.get(entry.getKey()))) continue;
            this.groupIdNumMap.put(entry.getKey(), entry.getValue());
        }
        HashSet<String> rmvKeys = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.groupIdNumMap.entrySet()) {
            if (newGroupIdNumMap.containsKey(entry.getKey())) continue;
            rmvKeys.add(entry.getKey());
        }
        for (String tmpKey : rmvKeys) {
            this.groupIdNumMap.remove(tmpKey);
        }
    }

    private void updateCachedGroupIdNumEnableMap(Map<String, Boolean> newGroupNumEnableMap) {
        if (newGroupNumEnableMap.isEmpty()) {
            this.groupIdNumEnableMap.clear();
            return;
        }
        for (Map.Entry<String, Boolean> entry : newGroupNumEnableMap.entrySet()) {
            if (entry.getValue().equals(this.groupIdNumEnableMap.get(entry.getKey()))) continue;
            this.groupIdNumEnableMap.put(entry.getKey(), entry.getValue());
        }
        HashSet<String> rmvKeys = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : this.groupIdNumEnableMap.entrySet()) {
            if (newGroupNumEnableMap.containsKey(entry.getKey())) continue;
            rmvKeys.add(entry.getKey());
        }
        for (String tmpKey : rmvKeys) {
            this.groupIdNumEnableMap.remove(tmpKey);
        }
    }

    private void updateCachedStreamIdNumMap(Map<String, Map<String, String>> newStreamIdNumMap) {
        if (newStreamIdNumMap.isEmpty()) {
            this.streamIdNumMap.clear();
            return;
        }
        HashSet<String> rmvKeys = new HashSet<String>();
        for (Map.Entry<String, Map<String, String>> entry : newStreamIdNumMap.entrySet()) {
            ConcurrentHashMap<String, String> storedMap = this.streamIdNumMap.get(entry.getKey());
            if (storedMap == null) {
                storedMap = new ConcurrentHashMap(entry.getValue().size());
                storedMap.putAll(entry.getValue());
                this.streamIdNumMap.put(entry.getKey(), storedMap);
                continue;
            }
            rmvKeys.clear();
            Map<String, String> newDataMap = entry.getValue();
            for (Map.Entry<String, String> entry1 : newDataMap.entrySet()) {
                if (entry1.getValue().equals(storedMap.get(entry.getKey()))) continue;
                storedMap.put(entry1.getKey(), entry1.getValue());
            }
            for (Map.Entry<String, String> entry1 : storedMap.entrySet()) {
                if (newDataMap.containsKey(entry1.getKey())) continue;
                rmvKeys.add(entry.getKey());
            }
            for (String tmpKey : rmvKeys) {
                storedMap.remove(tmpKey);
            }
            if (!storedMap.isEmpty()) continue;
            this.streamIdNumMap.remove(entry.getKey());
        }
        rmvKeys.clear();
        for (Map.Entry<String, Map<String, String>> entry : this.streamIdNumMap.entrySet()) {
            if (newStreamIdNumMap.containsKey(entry.getKey())) continue;
            rmvKeys.add(entry.getKey());
        }
        for (String string : rmvKeys) {
            this.streamIdNumMap.remove(string);
        }
    }
}

