/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.cluster.kafka;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterRequest;

@JsonTypeDefine(value="KAFKA")
@ApiModel(value="Inlong cluster info for Kafka")
public class KafkaClusterInfo
extends ClusterInfo {
    @JsonProperty(value="bootstrap.servers")
    @ApiModelProperty(value="Kafka bootstrap servers' URL")
    private String bootstrapServers;

    public KafkaClusterInfo() {
        this.setType("KAFKA");
    }

    @Override
    public KafkaClusterRequest genRequest() {
        return (KafkaClusterRequest)CommonBeanUtils.copyProperties((Object)this, KafkaClusterRequest::new);
    }

    protected KafkaClusterInfo(KafkaClusterInfoBuilder<?, ?> b) {
        super(b);
        this.bootstrapServers = ((KafkaClusterInfoBuilder)b).bootstrapServers;
    }

    public static KafkaClusterInfoBuilder<?, ?> builder() {
        return new KafkaClusterInfoBuilderImpl();
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty(value="bootstrap.servers")
    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    @Override
    public String toString() {
        return "KafkaClusterInfo(super=" + super.toString() + ", bootstrapServers=" + this.getBootstrapServers() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaClusterInfo)) {
            return false;
        }
        KafkaClusterInfo other = (KafkaClusterInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        return !(this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaClusterInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        return result;
    }

    private static final class KafkaClusterInfoBuilderImpl
    extends KafkaClusterInfoBuilder<KafkaClusterInfo, KafkaClusterInfoBuilderImpl> {
        private KafkaClusterInfoBuilderImpl() {
        }

        @Override
        protected KafkaClusterInfoBuilderImpl self() {
            return this;
        }

        @Override
        public KafkaClusterInfo build() {
            return new KafkaClusterInfo(this);
        }
    }

    public static abstract class KafkaClusterInfoBuilder<C extends KafkaClusterInfo, B extends KafkaClusterInfoBuilder<C, B>>
    extends ClusterInfo.ClusterInfoBuilder<C, B> {
        private String bootstrapServers;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="bootstrap.servers")
        public B bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "KafkaClusterInfo.KafkaClusterInfoBuilder(super=" + super.toString() + ", bootstrapServers=" + this.bootstrapServers + ")";
        }
    }
}

