/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.node.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.node.pulsar.PulsarDataNodeRequest;

@ApiModel(value="Pulsar data node info")
public class PulsarDataNodeDTO {
    @ApiModelProperty(value="Pulsar service url")
    private String serviceUrl;
    @ApiModelProperty(value="Pulsar admin url")
    private String adminUrl;
    @ApiModelProperty(value="Pulsar token")
    private String token;
    @ApiModelProperty(value="The compression format used for pulsar producer")
    private String compressionType;

    public static PulsarDataNodeDTO getFromRequest(PulsarDataNodeRequest request, String extParams) {
        PulsarDataNodeDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? PulsarDataNodeDTO.getFromJson(extParams) : new PulsarDataNodeDTO();
        return (PulsarDataNodeDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static PulsarDataNodeDTO getFromJson(@NotNull String extParams) {
        try {
            return (PulsarDataNodeDTO)JsonUtils.parseObject((String)extParams, PulsarDataNodeDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.GROUP_INFO_INCORRECT, String.format("Failed to parse extParams for pulsar node: %s", e.getMessage()));
        }
    }

    public static PulsarDataNodeDTOBuilder builder() {
        return new PulsarDataNodeDTOBuilder();
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public String getAdminUrl() {
        return this.adminUrl;
    }

    public String getToken() {
        return this.token;
    }

    public String getCompressionType() {
        return this.compressionType;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setAdminUrl(String adminUrl) {
        this.adminUrl = adminUrl;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setCompressionType(String compressionType) {
        this.compressionType = compressionType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PulsarDataNodeDTO)) {
            return false;
        }
        PulsarDataNodeDTO other = (PulsarDataNodeDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$adminUrl = this.getAdminUrl();
        String other$adminUrl = other.getAdminUrl();
        if (this$adminUrl == null ? other$adminUrl != null : !this$adminUrl.equals(other$adminUrl)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$compressionType = this.getCompressionType();
        String other$compressionType = other.getCompressionType();
        return !(this$compressionType == null ? other$compressionType != null : !this$compressionType.equals(other$compressionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PulsarDataNodeDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $adminUrl = this.getAdminUrl();
        result = result * 59 + ($adminUrl == null ? 43 : $adminUrl.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : $compressionType.hashCode());
        return result;
    }

    public String toString() {
        return "PulsarDataNodeDTO(serviceUrl=" + this.getServiceUrl() + ", adminUrl=" + this.getAdminUrl() + ", token=" + this.getToken() + ", compressionType=" + this.getCompressionType() + ")";
    }

    public PulsarDataNodeDTO() {
    }

    public PulsarDataNodeDTO(String serviceUrl, String adminUrl, String token, String compressionType) {
        this.serviceUrl = serviceUrl;
        this.adminUrl = adminUrl;
        this.token = token;
        this.compressionType = compressionType;
    }

    public static class PulsarDataNodeDTOBuilder {
        private String serviceUrl;
        private String adminUrl;
        private String token;
        private String compressionType;

        PulsarDataNodeDTOBuilder() {
        }

        public PulsarDataNodeDTOBuilder serviceUrl(String serviceUrl) {
            this.serviceUrl = serviceUrl;
            return this;
        }

        public PulsarDataNodeDTOBuilder adminUrl(String adminUrl) {
            this.adminUrl = adminUrl;
            return this;
        }

        public PulsarDataNodeDTOBuilder token(String token) {
            this.token = token;
            return this;
        }

        public PulsarDataNodeDTOBuilder compressionType(String compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        public PulsarDataNodeDTO build() {
            return new PulsarDataNodeDTO(this.serviceUrl, this.adminUrl, this.token, this.compressionType);
        }

        public String toString() {
            return "PulsarDataNodeDTO.PulsarDataNodeDTOBuilder(serviceUrl=" + this.serviceUrl + ", adminUrl=" + this.adminUrl + ", token=" + this.token + ", compressionType=" + this.compressionType + ")";
        }
    }
}

