/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.hbase;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;
import org.apache.inlong.manager.pojo.sink.StreamSink;
import org.apache.inlong.manager.pojo.sink.hbase.HBaseSinkRequest;

@ApiModel(value="HBase sink info")
@JsonTypeDefine(value="HBASE")
public class HBaseSink
extends StreamSink {
    @ApiModelProperty(value="Target namespace")
    private String namespace;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Row key")
    private String rowKey;
    @ApiModelProperty(value="ZooKeeper quorum")
    private String zkQuorum;
    @ApiModelProperty(value="ZooKeeper node parent")
    private String zkNodeParent;
    @ApiModelProperty(value="Sink buffer flush maxsize")
    private String bufferFlushMaxSize;
    @ApiModelProperty(value="Sink buffer flush max rows")
    private String bufferFlushMaxRows;
    @ApiModelProperty(value="Sink buffer flush interval")
    private String bufferFlushInterval;

    public HBaseSink() {
        this.setSinkType("HBASE");
    }

    @Override
    public SinkRequest genSinkRequest() {
        return (SinkRequest)CommonBeanUtils.copyProperties((Object)this, HBaseSinkRequest::new);
    }

    protected HBaseSink(HBaseSinkBuilder<?, ?> b) {
        super((StreamSink.StreamSinkBuilder<?, ?>)b);
        this.namespace = ((HBaseSinkBuilder)b).namespace;
        this.tableName = ((HBaseSinkBuilder)b).tableName;
        this.rowKey = ((HBaseSinkBuilder)b).rowKey;
        this.zkQuorum = ((HBaseSinkBuilder)b).zkQuorum;
        this.zkNodeParent = ((HBaseSinkBuilder)b).zkNodeParent;
        this.bufferFlushMaxSize = ((HBaseSinkBuilder)b).bufferFlushMaxSize;
        this.bufferFlushMaxRows = ((HBaseSinkBuilder)b).bufferFlushMaxRows;
        this.bufferFlushInterval = ((HBaseSinkBuilder)b).bufferFlushInterval;
    }

    public static HBaseSinkBuilder<?, ?> builder() {
        return new HBaseSinkBuilderImpl();
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public String getZkQuorum() {
        return this.zkQuorum;
    }

    public String getZkNodeParent() {
        return this.zkNodeParent;
    }

    public String getBufferFlushMaxSize() {
        return this.bufferFlushMaxSize;
    }

    public String getBufferFlushMaxRows() {
        return this.bufferFlushMaxRows;
    }

    public String getBufferFlushInterval() {
        return this.bufferFlushInterval;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public void setZkQuorum(String zkQuorum) {
        this.zkQuorum = zkQuorum;
    }

    public void setZkNodeParent(String zkNodeParent) {
        this.zkNodeParent = zkNodeParent;
    }

    public void setBufferFlushMaxSize(String bufferFlushMaxSize) {
        this.bufferFlushMaxSize = bufferFlushMaxSize;
    }

    public void setBufferFlushMaxRows(String bufferFlushMaxRows) {
        this.bufferFlushMaxRows = bufferFlushMaxRows;
    }

    public void setBufferFlushInterval(String bufferFlushInterval) {
        this.bufferFlushInterval = bufferFlushInterval;
    }

    public HBaseSink(String namespace, String tableName, String rowKey, String zkQuorum, String zkNodeParent, String bufferFlushMaxSize, String bufferFlushMaxRows, String bufferFlushInterval) {
        this.namespace = namespace;
        this.tableName = tableName;
        this.rowKey = rowKey;
        this.zkQuorum = zkQuorum;
        this.zkNodeParent = zkNodeParent;
        this.bufferFlushMaxSize = bufferFlushMaxSize;
        this.bufferFlushMaxRows = bufferFlushMaxRows;
        this.bufferFlushInterval = bufferFlushInterval;
    }

    @Override
    public String toString() {
        return "HBaseSink(super=" + super.toString() + ", namespace=" + this.getNamespace() + ", tableName=" + this.getTableName() + ", rowKey=" + this.getRowKey() + ", zkQuorum=" + this.getZkQuorum() + ", zkNodeParent=" + this.getZkNodeParent() + ", bufferFlushMaxSize=" + this.getBufferFlushMaxSize() + ", bufferFlushMaxRows=" + this.getBufferFlushMaxRows() + ", bufferFlushInterval=" + this.getBufferFlushInterval() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HBaseSink)) {
            return false;
        }
        HBaseSink other = (HBaseSink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$rowKey = this.getRowKey();
        String other$rowKey = other.getRowKey();
        if (this$rowKey == null ? other$rowKey != null : !this$rowKey.equals(other$rowKey)) {
            return false;
        }
        String this$zkQuorum = this.getZkQuorum();
        String other$zkQuorum = other.getZkQuorum();
        if (this$zkQuorum == null ? other$zkQuorum != null : !this$zkQuorum.equals(other$zkQuorum)) {
            return false;
        }
        String this$zkNodeParent = this.getZkNodeParent();
        String other$zkNodeParent = other.getZkNodeParent();
        if (this$zkNodeParent == null ? other$zkNodeParent != null : !this$zkNodeParent.equals(other$zkNodeParent)) {
            return false;
        }
        String this$bufferFlushMaxSize = this.getBufferFlushMaxSize();
        String other$bufferFlushMaxSize = other.getBufferFlushMaxSize();
        if (this$bufferFlushMaxSize == null ? other$bufferFlushMaxSize != null : !this$bufferFlushMaxSize.equals(other$bufferFlushMaxSize)) {
            return false;
        }
        String this$bufferFlushMaxRows = this.getBufferFlushMaxRows();
        String other$bufferFlushMaxRows = other.getBufferFlushMaxRows();
        if (this$bufferFlushMaxRows == null ? other$bufferFlushMaxRows != null : !this$bufferFlushMaxRows.equals(other$bufferFlushMaxRows)) {
            return false;
        }
        String this$bufferFlushInterval = this.getBufferFlushInterval();
        String other$bufferFlushInterval = other.getBufferFlushInterval();
        return !(this$bufferFlushInterval == null ? other$bufferFlushInterval != null : !this$bufferFlushInterval.equals(other$bufferFlushInterval));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HBaseSink;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $rowKey = this.getRowKey();
        result = result * 59 + ($rowKey == null ? 43 : $rowKey.hashCode());
        String $zkQuorum = this.getZkQuorum();
        result = result * 59 + ($zkQuorum == null ? 43 : $zkQuorum.hashCode());
        String $zkNodeParent = this.getZkNodeParent();
        result = result * 59 + ($zkNodeParent == null ? 43 : $zkNodeParent.hashCode());
        String $bufferFlushMaxSize = this.getBufferFlushMaxSize();
        result = result * 59 + ($bufferFlushMaxSize == null ? 43 : $bufferFlushMaxSize.hashCode());
        String $bufferFlushMaxRows = this.getBufferFlushMaxRows();
        result = result * 59 + ($bufferFlushMaxRows == null ? 43 : $bufferFlushMaxRows.hashCode());
        String $bufferFlushInterval = this.getBufferFlushInterval();
        result = result * 59 + ($bufferFlushInterval == null ? 43 : $bufferFlushInterval.hashCode());
        return result;
    }

    private static final class HBaseSinkBuilderImpl
    extends HBaseSinkBuilder<HBaseSink, HBaseSinkBuilderImpl> {
        private HBaseSinkBuilderImpl() {
        }

        @Override
        protected HBaseSinkBuilderImpl self() {
            return this;
        }

        @Override
        public HBaseSink build() {
            return new HBaseSink(this);
        }
    }

    public static abstract class HBaseSinkBuilder<C extends HBaseSink, B extends HBaseSinkBuilder<C, B>>
    extends StreamSink.StreamSinkBuilder<C, B> {
        private String namespace;
        private String tableName;
        private String rowKey;
        private String zkQuorum;
        private String zkNodeParent;
        private String bufferFlushMaxSize;
        private String bufferFlushMaxRows;
        private String bufferFlushInterval;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B namespace(String namespace) {
            this.namespace = namespace;
            return (B)this.self();
        }

        public B tableName(String tableName) {
            this.tableName = tableName;
            return (B)this.self();
        }

        public B rowKey(String rowKey) {
            this.rowKey = rowKey;
            return (B)this.self();
        }

        public B zkQuorum(String zkQuorum) {
            this.zkQuorum = zkQuorum;
            return (B)this.self();
        }

        public B zkNodeParent(String zkNodeParent) {
            this.zkNodeParent = zkNodeParent;
            return (B)this.self();
        }

        public B bufferFlushMaxSize(String bufferFlushMaxSize) {
            this.bufferFlushMaxSize = bufferFlushMaxSize;
            return (B)this.self();
        }

        public B bufferFlushMaxRows(String bufferFlushMaxRows) {
            this.bufferFlushMaxRows = bufferFlushMaxRows;
            return (B)this.self();
        }

        public B bufferFlushInterval(String bufferFlushInterval) {
            this.bufferFlushInterval = bufferFlushInterval;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HBaseSink.HBaseSinkBuilder(super=" + super.toString() + ", namespace=" + this.namespace + ", tableName=" + this.tableName + ", rowKey=" + this.rowKey + ", zkQuorum=" + this.zkQuorum + ", zkNodeParent=" + this.zkNodeParent + ", bufferFlushMaxSize=" + this.bufferFlushMaxSize + ", bufferFlushMaxRows=" + this.bufferFlushMaxRows + ", bufferFlushInterval=" + this.bufferFlushInterval + ")";
        }
    }
}

