/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.base;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.common.enums.DataTypeEnum;
import org.apache.inlong.common.enums.MessageWrapType;
import org.apache.inlong.common.util.StringUtil;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.pojo.sort.node.base.NodeProvider;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.format.AvroFormat;
import org.apache.inlong.sort.protocol.node.format.CanalJsonFormat;
import org.apache.inlong.sort.protocol.node.format.CsvFormat;
import org.apache.inlong.sort.protocol.node.format.DebeziumJsonFormat;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.format.InLongMsgFormat;
import org.apache.inlong.sort.protocol.node.format.JsonFormat;
import org.apache.inlong.sort.protocol.node.format.KvFormat;
import org.apache.inlong.sort.protocol.node.format.RawFormat;

public interface ExtractNodeProvider
extends NodeProvider {
    public ExtractNode createExtractNode(StreamNode var1);

    default public List<FieldInfo> parseStreamFieldInfos(List<StreamField> streamFields, String nodeId) {
        return this.parseStreamFieldInfos(streamFields, nodeId, null);
    }

    default public List<FieldInfo> parseStreamFieldInfos(List<StreamField> streamFields, String nodeId, FieldTypeMappingStrategy fieldTypeMappingStrategy) {
        if (CollectionUtils.isEmpty(streamFields)) {
            return null;
        }
        return streamFields.stream().filter(s -> Objects.isNull(s.getFieldValue())).map(streamFieldInfo -> FieldInfoUtils.parseStreamFieldInfo(streamFieldInfo, nodeId, fieldTypeMappingStrategy)).collect(Collectors.toList());
    }

    default public Format parsingFormat(String serializationType, String wrapType, String separatorStr, String kvSeparatorStr, String escapeCharStr, Boolean ignoreParseErrors) {
        AvroFormat format;
        DataTypeEnum dataType = DataTypeEnum.forType((String)serializationType);
        switch (dataType) {
            case CSV: {
                separatorStr = StringUtil.parseChar((String)separatorStr);
                CsvFormat csvFormat = new CsvFormat(separatorStr);
                csvFormat.setIgnoreParseErrors(ignoreParseErrors);
                format = csvFormat;
                break;
            }
            case AVRO: {
                format = new AvroFormat();
                break;
            }
            case JSON: {
                JsonFormat jsonFormat = new JsonFormat();
                jsonFormat.setIgnoreParseErrors(ignoreParseErrors);
                format = jsonFormat;
                break;
            }
            case CANAL: {
                format = new CanalJsonFormat();
                break;
            }
            case DEBEZIUM_JSON: {
                DebeziumJsonFormat debeziumJsonFormat = new DebeziumJsonFormat();
                debeziumJsonFormat.setIgnoreParseErrors(ignoreParseErrors);
                format = debeziumJsonFormat;
                break;
            }
            case RAW: {
                format = new RawFormat();
                break;
            }
            case KV: {
                separatorStr = StringUtil.parseChar((String)separatorStr);
                kvSeparatorStr = StringUtil.parseChar((String)kvSeparatorStr);
                escapeCharStr = StringUtil.parseChar((String)escapeCharStr);
                format = new KvFormat(separatorStr, kvSeparatorStr, escapeCharStr, ignoreParseErrors, null, null, null);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported dataType=%s", dataType));
            }
        }
        if (Objects.equals(wrapType, MessageWrapType.INLONG_MSG_V0.getName())) {
            AvroFormat innerFormat = format;
            format = new InLongMsgFormat((Format)innerFormat, Boolean.valueOf(false));
        }
        return format;
    }

    default public List<StreamField> addStreamMetaFields(List<StreamField> streamFields) {
        return streamFields;
    }
}

