/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import java.io.Serializable;
import java.util.function.Supplier;
import org.jmolecules.ddd.types.Entity;
import org.jmolecules.ddd.types.Identifier;
import org.jmolecules.spring.IdentifierToPrimitivesConverter;
import org.jmolecules.spring.PrimitivesToIdentifierConverter;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.data.rest.webmvc.spi.BackendIdConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(proxyBeanMethods=false)
class JMoleculesConfigurer
implements WebMvcConfigurer,
RepositoryRestConfigurer {
    JMoleculesConfigurer() {
    }

    public void addFormatters(FormatterRegistry registry) {
        ConversionService conversionService = (ConversionService)registry;
        Supplier<ConversionService> supplier = () -> conversionService;
        if (!conversionService.canConvert(Identifier.class, String.class)) {
            registry.addConverter((GenericConverter)new IdentifierToPrimitivesConverter(supplier));
        }
        if (!conversionService.canConvert(String.class, Identifier.class)) {
            registry.addConverter((GenericConverter)new PrimitivesToIdentifierConverter(supplier));
        }
    }

    @Override
    public void configureConversionService(ConfigurableConversionService conversionService) {
        Supplier<ConversionService> supplier = () -> conversionService;
        conversionService.addConverter((GenericConverter)new PrimitivesToIdentifierConverter(supplier));
        conversionService.addConverter((GenericConverter)new IdentifierToPrimitivesConverter(supplier));
    }

    @Lazy
    @Bean
    BackendIdConverter jMoleculesEntitiesBackendIdConverter(PersistentEntities entities, @Qualifier(value="mvcConversionService") ObjectFactory<ConversionService> conversionService) {
        return new JMoleculesBackendIdentifierConverter(entities, () -> (ConversionService)conversionService.getObject());
    }

    private static final class JMoleculesBackendIdentifierConverter
    implements BackendIdConverter {
        private static final TypeDescriptor STRING_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
        private static final ResolvableType IDENTIFIER_TYPE = ResolvableType.forClass(Identifier.class);
        private final PrimitivesToIdentifierConverter identifierConverter;
        private final IdentifierToPrimitivesConverter primitivesConverter;
        private final PersistentEntities entities;

        public JMoleculesBackendIdentifierConverter(PersistentEntities entities, Supplier<? extends ConversionService> conversionService) {
            this.identifierConverter = new PrimitivesToIdentifierConverter(conversionService);
            this.primitivesConverter = new IdentifierToPrimitivesConverter(conversionService);
            this.entities = entities;
        }

        @Override
        public Serializable fromRequestId(String id, Class<?> entityType) {
            PersistentEntity entity = this.entities.getRequiredPersistentEntity(entityType);
            Class idType = entity.getRequiredIdProperty().getType();
            return (Serializable)this.identifierConverter.convert((Object)id, TypeDescriptor.forObject((Object)id), TypeDescriptor.valueOf((Class)idType));
        }

        @Override
        public String toRequestId(Serializable id, Class<?> entityType) {
            return (String)this.primitivesConverter.convert((Object)id, TypeDescriptor.forObject((Object)id), STRING_DESCRIPTOR);
        }

        public boolean supports(Class<?> delimiter) {
            if (!Entity.class.isAssignableFrom(delimiter)) {
                return false;
            }
            return IDENTIFIER_TYPE.isAssignableFrom(ResolvableType.forClass(delimiter).as(Entity.class).getGeneric(new int[]{1}));
        }
    }
}

