/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.protocolrecords;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class RegisterApplicationMasterResponse {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static RegisterApplicationMasterResponse newInstance(Resource minCapability, Resource maxCapability, Map<ApplicationAccessType, String> acls, ByteBuffer key, List<Container> containersFromPreviousAttempt, String queue, List<NMToken> nmTokensFromPreviousAttempts) {
        RegisterApplicationMasterResponse response = Records.newRecord(RegisterApplicationMasterResponse.class);
        response.setMaximumResourceCapability(maxCapability);
        response.setApplicationACLs(acls);
        response.setClientToAMTokenMasterKey(key);
        response.setContainersFromPreviousAttempts(containersFromPreviousAttempt);
        response.setNMTokensFromPreviousAttempts(nmTokensFromPreviousAttempts);
        response.setQueue(queue);
        return response;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getMaximumResourceCapability();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setMaximumResourceCapability(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Map<ApplicationAccessType, String> getApplicationACLs();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationACLs(Map<ApplicationAccessType, String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ByteBuffer getClientToAMTokenMasterKey();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setClientToAMTokenMasterKey(ByteBuffer var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueue();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<Container> getContainersFromPreviousAttempts();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setContainersFromPreviousAttempts(List<Container> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract List<NMToken> getNMTokensFromPreviousAttempts();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNMTokensFromPreviousAttempts(List<NMToken> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulerResourceTypes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setSchedulerResourceTypes(EnumSet<YarnServiceProtos.SchedulerResourceTypes> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract List<ResourceTypeInfo> getResourceTypes();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setResourceTypes(List<ResourceTypeInfo> var1);
}

