/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.auditor;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.Exception.InvalidRequestException;
import org.apache.inlong.audit.service.auditor.Audit;
import org.apache.inlong.audit.service.auditor.ReconciliationData;
import org.apache.inlong.audit.service.auditor.RequestInfo;
import org.apache.inlong.audit.service.cache.AbstractCache;
import org.apache.inlong.audit.service.cache.HalfHourCache;
import org.apache.inlong.audit.service.cache.HourCache;
import org.apache.inlong.audit.service.cache.RealTimeQuery;
import org.apache.inlong.audit.service.cache.TenMinutesCache;
import org.apache.inlong.audit.service.entities.AuditCycle;
import org.apache.inlong.audit.service.entities.StatData;
import org.apache.inlong.audit.service.metric.MetricsManager;
import org.apache.inlong.audit.service.utils.AuditUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Audit {
    private static final Logger LOGGER = LoggerFactory.getLogger(Audit.class);
    private static final Gson GSON = new Gson();
    private static volatile Audit instance = null;

    private Audit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Audit getInstance() {
        if (instance != null) return instance;
        Class<Audit> clazz = Audit.class;
        synchronized (Audit.class) {
            if (instance != null) return instance;
            instance = new Audit();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public JsonObject getData(String requestInfo) {
        try {
            RequestInfo request = (RequestInfo)GSON.fromJson(requestInfo, RequestInfo.class);
            AuditCycle auditCycle = AuditUtils.getAuditCycleTime((String)request.getStartTime(), (String)request.getEndTime());
            this.validateRequest(request, auditCycle);
            ReconciliationData data = this.getAuditData(request, auditCycle);
            this.checkReconciliationData(request, data);
            return this.createResponseJson(true, data, null);
        }
        catch (InvalidRequestException e) {
            LOGGER.error("Invalid request parameters: {}", (Object)e.getMessage());
            return this.createResponseJson(false, null, e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Failed to process reconciliation request", (Throwable)e);
            return this.createResponseJson(false, null, "Internal server error: " + e.getMessage());
        }
    }

    private ReconciliationData getAuditData(RequestInfo request, AuditCycle auditCycle) {
        ReconciliationData data = this.getDataFromCache(request, auditCycle);
        if (data != null && data.isNotEmpty() && data.getDiffRatio() <= request.getDiffRatio()) {
            return data;
        }
        long statTimeMillis = System.currentTimeMillis();
        data = this.getDataFromStorage(request, false);
        if (data.getDiffRatio() <= request.getDiffRatio()) {
            return data;
        }
        data = this.getDataFromStorage(request, true);
        MetricsManager.getInstance().addApiMetricNoCache(auditCycle, System.currentTimeMillis() - statTimeMillis);
        LOGGER.info("Get audit data from data storage by distinct. Request info: {}", (Object)request);
        return data;
    }

    private void validateRequest(RequestInfo request, AuditCycle auditCycle) throws InvalidRequestException {
        if (!this.areIdsValid(request) || !this.isAuditCycleValid(auditCycle)) {
            throw new InvalidRequestException("Invalid parameters: " + request);
        }
        this.setDefaultAuditTagIfBlank(request);
    }

    private void setDefaultAuditTagIfBlank(RequestInfo request) {
        if (StringUtils.isBlank((CharSequence)request.getSrcAuditTag())) {
            request.setSrcAuditTag("-1");
        }
        if (StringUtils.isBlank((CharSequence)request.getDestAuditTag())) {
            request.setDestAuditTag("-1");
        }
    }

    private boolean areIdsValid(RequestInfo request) {
        return Objects.nonNull(request.getInlongGroupId()) && Objects.nonNull(request.getInlongStreamId()) && Objects.nonNull(request.getSrcAuditId()) && Objects.nonNull(request.getDestAuditId());
    }

    private boolean isAuditCycleValid(AuditCycle auditCycle) {
        return Arrays.asList(AuditCycle.MINUTE_10, AuditCycle.MINUTE_30, AuditCycle.HOUR, AuditCycle.DAY).contains(auditCycle);
    }

    private JsonObject createResponseJson(boolean isSuccess, ReconciliationData auditData, String errorMessage) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("success", Boolean.valueOf(isSuccess));
        jsonObject.addProperty("errMsg", errorMessage);
        jsonObject.add("data", GSON.toJsonTree((Object)(auditData != null ? auditData.getCombinedData() : new LinkedList())));
        return jsonObject;
    }

    private ReconciliationData getDataFromCache(RequestInfo request, AuditCycle auditCycle) {
        AbstractCache auditCache = this.getAuditCache(auditCycle);
        if (auditCache == null) {
            return null;
        }
        List srcData = auditCache.getData(request.getStartTime(), request.getEndTime(), request.getInlongGroupId(), request.getInlongStreamId(), request.getSrcAuditId(), request.getSrcAuditTag(), false);
        List destData = auditCache.getData(request.getStartTime(), request.getEndTime(), request.getInlongGroupId(), request.getInlongStreamId(), request.getDestAuditId(), request.getDestAuditTag(), false);
        return new ReconciliationData(AuditUtils.mergeStatDataList((List)srcData), AuditUtils.mergeStatDataList((List)destData));
    }

    private ReconciliationData getDataFromStorage(RequestInfo request, boolean needDistinct) {
        List srcData = RealTimeQuery.getInstance().queryAuditData(request.getStartTime(), request.getEndTime(), request.getInlongGroupId(), request.getInlongStreamId(), request.getSrcAuditId(), request.getSrcAuditTag(), needDistinct);
        List destData = RealTimeQuery.getInstance().queryAuditData(request.getStartTime(), request.getEndTime(), request.getInlongGroupId(), request.getInlongStreamId(), request.getDestAuditId(), request.getDestAuditTag(), needDistinct);
        return new ReconciliationData(AuditUtils.mergeStatDataList((List)srcData), AuditUtils.mergeStatDataList((List)destData));
    }

    private AbstractCache getAuditCache(AuditCycle auditCycle) {
        switch (1.$SwitchMap$org$apache$inlong$audit$service$entities$AuditCycle[auditCycle.ordinal()]) {
            case 1: {
                return TenMinutesCache.getInstance();
            }
            case 2: {
                return HalfHourCache.getInstance();
            }
            case 3: 
            case 4: {
                return HourCache.getInstance();
            }
        }
        return null;
    }

    private void checkReconciliationData(RequestInfo request, ReconciliationData data) {
        String startTime = request.getStartTime();
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        if (data.srcData == null) {
            data.srcData = new StatData(startTime, groupId, streamId, request.getSrcAuditId(), request.getSrcAuditTag());
        }
        if (data.destData == null) {
            data.destData = new StatData(startTime, groupId, streamId, request.getDestAuditId(), request.getDestAuditTag());
        }
    }
}

