/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.service.selector.api;

import java.net.InetAddress;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.audit.service.selector.api.SelectorChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectorConfig.class);
    public static final String MONITOR_COMMON_NAME = "audit";
    private final String serviceId;
    private final String leaderId;
    private String defaultLeaderId;
    private boolean useDefaultLeader = false;
    private String dbDriver;
    private String dbUrl;
    private String dbUser;
    private String dbPasswd;
    private String selectorDbName = "leader_selector";
    private int leaderTimeout = 20;
    private int tryToBeLeaderInterval = 5;
    private int dbMonitorRunInterval = 20;
    private int connectionTimeout = 10000;
    private int idleTimeout = 60000;
    private int maxLifetime = 1800000;
    private int maximumPoolSize = 2;
    private String cachePrepStmts = "true";
    private int prepStmtCacheSize = 250;
    private int prepStmtCacheSqlLimit = 2048;
    private String monitorName = "selector_leader_state";
    private String ip;
    private SelectorChangeListener selectorChangeListener;

    public SelectorConfig(String serviceId, String leaderId, String dbUrl, String dbUser, String dbPasswd, String dbDriver) {
        assert (Objects.nonNull(serviceId) && Objects.nonNull(leaderId) && Objects.nonNull(dbUrl) && Objects.nonNull(dbUser) && Objects.nonNull(dbPasswd) && Objects.nonNull(dbDriver));
        this.serviceId = serviceId;
        this.leaderId = leaderId;
        this.dbUrl = dbUrl;
        this.dbUser = dbUser;
        this.dbPasswd = dbPasswd;
        this.dbDriver = dbDriver;
    }

    public String getIp() {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            try {
                this.ip = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                LOGGER.error("Get local ip has exception:{}", (Object)e.getMessage());
                this.ip = "N/A";
            }
        }
        return this.ip;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getLeaderId() {
        return this.leaderId;
    }

    public String getDefaultLeaderId() {
        return this.defaultLeaderId;
    }

    public boolean isUseDefaultLeader() {
        return this.useDefaultLeader;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbPasswd() {
        return this.dbPasswd;
    }

    public String getSelectorDbName() {
        return this.selectorDbName;
    }

    public int getLeaderTimeout() {
        return this.leaderTimeout;
    }

    public int getTryToBeLeaderInterval() {
        return this.tryToBeLeaderInterval;
    }

    public int getDbMonitorRunInterval() {
        return this.dbMonitorRunInterval;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public String getCachePrepStmts() {
        return this.cachePrepStmts;
    }

    public int getPrepStmtCacheSize() {
        return this.prepStmtCacheSize;
    }

    public int getPrepStmtCacheSqlLimit() {
        return this.prepStmtCacheSqlLimit;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public SelectorChangeListener getSelectorChangeListener() {
        return this.selectorChangeListener;
    }

    public void setDefaultLeaderId(String defaultLeaderId) {
        this.defaultLeaderId = defaultLeaderId;
    }

    public void setUseDefaultLeader(boolean useDefaultLeader) {
        this.useDefaultLeader = useDefaultLeader;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPasswd(String dbPasswd) {
        this.dbPasswd = dbPasswd;
    }

    public void setSelectorDbName(String selectorDbName) {
        this.selectorDbName = selectorDbName;
    }

    public void setLeaderTimeout(int leaderTimeout) {
        this.leaderTimeout = leaderTimeout;
    }

    public void setTryToBeLeaderInterval(int tryToBeLeaderInterval) {
        this.tryToBeLeaderInterval = tryToBeLeaderInterval;
    }

    public void setDbMonitorRunInterval(int dbMonitorRunInterval) {
        this.dbMonitorRunInterval = dbMonitorRunInterval;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setCachePrepStmts(String cachePrepStmts) {
        this.cachePrepStmts = cachePrepStmts;
    }

    public void setPrepStmtCacheSize(int prepStmtCacheSize) {
        this.prepStmtCacheSize = prepStmtCacheSize;
    }

    public void setPrepStmtCacheSqlLimit(int prepStmtCacheSqlLimit) {
        this.prepStmtCacheSqlLimit = prepStmtCacheSqlLimit;
    }

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setSelectorChangeListener(SelectorChangeListener selectorChangeListener) {
        this.selectorChangeListener = selectorChangeListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectorConfig)) {
            return false;
        }
        SelectorConfig other = (SelectorConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isUseDefaultLeader() != other.isUseDefaultLeader()) {
            return false;
        }
        if (this.getLeaderTimeout() != other.getLeaderTimeout()) {
            return false;
        }
        if (this.getTryToBeLeaderInterval() != other.getTryToBeLeaderInterval()) {
            return false;
        }
        if (this.getDbMonitorRunInterval() != other.getDbMonitorRunInterval()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getIdleTimeout() != other.getIdleTimeout()) {
            return false;
        }
        if (this.getMaxLifetime() != other.getMaxLifetime()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getPrepStmtCacheSize() != other.getPrepStmtCacheSize()) {
            return false;
        }
        if (this.getPrepStmtCacheSqlLimit() != other.getPrepStmtCacheSqlLimit()) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$leaderId = this.getLeaderId();
        String other$leaderId = other.getLeaderId();
        if (this$leaderId == null ? other$leaderId != null : !this$leaderId.equals(other$leaderId)) {
            return false;
        }
        String this$defaultLeaderId = this.getDefaultLeaderId();
        String other$defaultLeaderId = other.getDefaultLeaderId();
        if (this$defaultLeaderId == null ? other$defaultLeaderId != null : !this$defaultLeaderId.equals(other$defaultLeaderId)) {
            return false;
        }
        String this$dbDriver = this.getDbDriver();
        String other$dbDriver = other.getDbDriver();
        if (this$dbDriver == null ? other$dbDriver != null : !this$dbDriver.equals(other$dbDriver)) {
            return false;
        }
        String this$dbUrl = this.getDbUrl();
        String other$dbUrl = other.getDbUrl();
        if (this$dbUrl == null ? other$dbUrl != null : !this$dbUrl.equals(other$dbUrl)) {
            return false;
        }
        String this$dbUser = this.getDbUser();
        String other$dbUser = other.getDbUser();
        if (this$dbUser == null ? other$dbUser != null : !this$dbUser.equals(other$dbUser)) {
            return false;
        }
        String this$dbPasswd = this.getDbPasswd();
        String other$dbPasswd = other.getDbPasswd();
        if (this$dbPasswd == null ? other$dbPasswd != null : !this$dbPasswd.equals(other$dbPasswd)) {
            return false;
        }
        String this$selectorDbName = this.getSelectorDbName();
        String other$selectorDbName = other.getSelectorDbName();
        if (this$selectorDbName == null ? other$selectorDbName != null : !this$selectorDbName.equals(other$selectorDbName)) {
            return false;
        }
        String this$cachePrepStmts = this.getCachePrepStmts();
        String other$cachePrepStmts = other.getCachePrepStmts();
        if (this$cachePrepStmts == null ? other$cachePrepStmts != null : !this$cachePrepStmts.equals(other$cachePrepStmts)) {
            return false;
        }
        String this$monitorName = this.getMonitorName();
        String other$monitorName = other.getMonitorName();
        if (this$monitorName == null ? other$monitorName != null : !this$monitorName.equals(other$monitorName)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        SelectorChangeListener this$selectorChangeListener = this.getSelectorChangeListener();
        SelectorChangeListener other$selectorChangeListener = other.getSelectorChangeListener();
        return !(this$selectorChangeListener == null ? other$selectorChangeListener != null : !this$selectorChangeListener.equals(other$selectorChangeListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseDefaultLeader() ? 79 : 97);
        result = result * 59 + this.getLeaderTimeout();
        result = result * 59 + this.getTryToBeLeaderInterval();
        result = result * 59 + this.getDbMonitorRunInterval();
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getIdleTimeout();
        result = result * 59 + this.getMaxLifetime();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getPrepStmtCacheSize();
        result = result * 59 + this.getPrepStmtCacheSqlLimit();
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $leaderId = this.getLeaderId();
        result = result * 59 + ($leaderId == null ? 43 : $leaderId.hashCode());
        String $defaultLeaderId = this.getDefaultLeaderId();
        result = result * 59 + ($defaultLeaderId == null ? 43 : $defaultLeaderId.hashCode());
        String $dbDriver = this.getDbDriver();
        result = result * 59 + ($dbDriver == null ? 43 : $dbDriver.hashCode());
        String $dbUrl = this.getDbUrl();
        result = result * 59 + ($dbUrl == null ? 43 : $dbUrl.hashCode());
        String $dbUser = this.getDbUser();
        result = result * 59 + ($dbUser == null ? 43 : $dbUser.hashCode());
        String $dbPasswd = this.getDbPasswd();
        result = result * 59 + ($dbPasswd == null ? 43 : $dbPasswd.hashCode());
        String $selectorDbName = this.getSelectorDbName();
        result = result * 59 + ($selectorDbName == null ? 43 : $selectorDbName.hashCode());
        String $cachePrepStmts = this.getCachePrepStmts();
        result = result * 59 + ($cachePrepStmts == null ? 43 : $cachePrepStmts.hashCode());
        String $monitorName = this.getMonitorName();
        result = result * 59 + ($monitorName == null ? 43 : $monitorName.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        SelectorChangeListener $selectorChangeListener = this.getSelectorChangeListener();
        result = result * 59 + ($selectorChangeListener == null ? 43 : $selectorChangeListener.hashCode());
        return result;
    }

    public String toString() {
        return "SelectorConfig(serviceId=" + this.getServiceId() + ", leaderId=" + this.getLeaderId() + ", defaultLeaderId=" + this.getDefaultLeaderId() + ", useDefaultLeader=" + this.isUseDefaultLeader() + ", dbDriver=" + this.getDbDriver() + ", dbUrl=" + this.getDbUrl() + ", dbUser=" + this.getDbUser() + ", dbPasswd=" + this.getDbPasswd() + ", selectorDbName=" + this.getSelectorDbName() + ", leaderTimeout=" + this.getLeaderTimeout() + ", tryToBeLeaderInterval=" + this.getTryToBeLeaderInterval() + ", dbMonitorRunInterval=" + this.getDbMonitorRunInterval() + ", connectionTimeout=" + this.getConnectionTimeout() + ", idleTimeout=" + this.getIdleTimeout() + ", maxLifetime=" + this.getMaxLifetime() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", cachePrepStmts=" + this.getCachePrepStmts() + ", prepStmtCacheSize=" + this.getPrepStmtCacheSize() + ", prepStmtCacheSqlLimit=" + this.getPrepStmtCacheSqlLimit() + ", monitorName=" + this.getMonitorName() + ", ip=" + this.getIp() + ", selectorChangeListener=" + this.getSelectorChangeListener() + ")";
    }
}

