/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.annotations;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.core.annotation.AnnotationUtils;

public class Annotations {
    private Annotations() {
        throw new UnsupportedOperationException();
    }

    public static Optional<ApiParam> findApiParamAnnotation(AnnotatedElement annotated) {
        return Optional.ofNullable((ApiParam)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiParam.class));
    }

    public static List<io.swagger.annotations.ApiResponses> findApiResponsesAnnotations(AnnotatedElement annotated) {
        io.swagger.annotations.ApiResponses parentLevel;
        ArrayList<io.swagger.annotations.ApiResponses> results = new ArrayList<io.swagger.annotations.ApiResponses>();
        io.swagger.annotations.ApiResponses currentLevel = (io.swagger.annotations.ApiResponses)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, io.swagger.annotations.ApiResponses.class);
        if (currentLevel != null) {
            results.add(currentLevel);
        }
        if (annotated instanceof Method && (parentLevel = (io.swagger.annotations.ApiResponses)AnnotationUtils.findAnnotation(((Method)annotated).getDeclaringClass(), io.swagger.annotations.ApiResponses.class)) != null) {
            results.add(parentLevel);
        }
        return results;
    }

    public static Function<ApiOperation, ResolvedType> resolvedTypeFromApiOperation(TypeResolver typeResolver, ResolvedType defaultType) {
        return annotation -> Annotations.getResolvedType(annotation, typeResolver, defaultType);
    }

    public static Function<ApiResponse, ResolvedType> resolvedTypeFromResponse(TypeResolver typeResolver, ResolvedType defaultType) {
        return annotation -> Annotations.getResolvedType(annotation, typeResolver, defaultType);
    }

    public static Function<Operation, Collection<io.swagger.v3.oas.annotations.responses.ApiResponse>> fromOperationAnnotation() {
        return annotation -> {
            if (null != annotation) {
                return Arrays.asList(annotation.responses());
            }
            return new ArrayList();
        };
    }

    public static Function<ApiResponses, Collection<io.swagger.v3.oas.annotations.responses.ApiResponse>> fromApiResponsesAnnotation() {
        return annotation -> {
            if (null != annotation) {
                return Arrays.asList(annotation.value());
            }
            return new ArrayList();
        };
    }

    public static Function<Schema, ResolvedType> resolvedTypeFromSchema(TypeResolver typeResolver, ResolvedType defaultType) {
        return annotation -> Annotations.getResolvedType(annotation, typeResolver, defaultType);
    }

    private static ResolvedType getResolvedType(Schema annotation, TypeResolver resolver, ResolvedType defaultType) {
        if (null != annotation) {
            String responseContainer;
            Class response = annotation.implementation();
            String string = responseContainer = annotation.multipleOf() > 0.0 ? "LIST" : "";
            if (Annotations.resolvedType(resolver, response, responseContainer).isPresent()) {
                return Annotations.resolvedType(resolver, response, responseContainer).get();
            }
        }
        return defaultType;
    }

    static ResolvedType getResolvedType(ApiOperation annotation, TypeResolver resolver, ResolvedType defaultType) {
        String responseContainer;
        Class response;
        if (null != annotation && Annotations.resolvedType(resolver, response = annotation.response(), responseContainer = annotation.responseContainer()).isPresent()) {
            return Annotations.resolvedType(resolver, response, responseContainer).get();
        }
        return defaultType;
    }

    static ResolvedType getResolvedType(ApiResponse annotation, TypeResolver resolver, ResolvedType defaultType) {
        String responseContainer;
        Class response;
        if (null != annotation && Annotations.resolvedType(resolver, response = annotation.response(), responseContainer = annotation.responseContainer()).isPresent()) {
            return Annotations.resolvedType(resolver, response, responseContainer).get();
        }
        return defaultType;
    }

    private static Optional<ResolvedType> resolvedType(TypeResolver resolver, Class<?> response, String responseContainer) {
        if (Annotations.isNotVoid(response)) {
            if ("List".compareToIgnoreCase(responseContainer) == 0) {
                return Optional.of(resolver.resolve(List.class, new Type[]{response}));
            }
            if ("Set".compareToIgnoreCase(responseContainer) == 0) {
                return Optional.of(resolver.resolve(Set.class, new Type[]{response}));
            }
            return Optional.of(resolver.resolve(response, new Type[0]));
        }
        return Optional.empty();
    }

    private static boolean isNotVoid(Class<?> response) {
        return Void.class != response && Void.TYPE != response;
    }
}

