/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.Heartbeat;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.HeartbeatClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.heartbeat.ComponentHeartbeatResponse;
import org.apache.inlong.manager.pojo.heartbeat.GroupHeartbeatResponse;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatPageRequest;
import org.apache.inlong.manager.pojo.heartbeat.HeartbeatQueryRequest;
import org.apache.inlong.manager.pojo.heartbeat.StreamHeartbeatResponse;

public class HeartbeatImpl
implements Heartbeat {
    private final HeartbeatClient heartbeatClient;

    public HeartbeatImpl(ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.heartbeatClient = clientFactory.getHeartbeatClient();
    }

    @Override
    public ComponentHeartbeatResponse getComponentHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat component cannot be blank");
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat instance cannot be blank");
        return this.heartbeatClient.getComponentHeartbeat(request);
    }

    @Override
    public GroupHeartbeatResponse getGroupHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat component cannot be blank");
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat instance cannot be blank");
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat groupId cannot be blank");
        return this.heartbeatClient.getGroupHeartbeat(request);
    }

    @Override
    public StreamHeartbeatResponse getStreamHeartbeat(HeartbeatQueryRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat component cannot be blank");
        Preconditions.expectNotBlank((String)request.getInstance(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat instance cannot be blank");
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat groupId cannot be blank");
        Preconditions.expectNotBlank((String)request.getInlongStreamId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat streamId cannot be blank");
        return this.heartbeatClient.getStreamHeartbeat(request);
    }

    @Override
    public PageResult<ComponentHeartbeatResponse> listComponentHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat component cannot be blank");
        return this.heartbeatClient.listComponentHeartbeat(request);
    }

    @Override
    public PageResult<GroupHeartbeatResponse> listGroupHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat component cannot be blank");
        return this.heartbeatClient.listGroupHeartbeat(request);
    }

    @Override
    public PageResult<StreamHeartbeatResponse> listStreamHeartbeat(HeartbeatPageRequest request) {
        Preconditions.expectNotNull((Object)request, (String)ErrorCodeEnum.REQUEST_IS_EMPTY.getMessage());
        Preconditions.expectNotBlank((String)request.getComponent(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat component cannot be blank");
        Preconditions.expectNotBlank((String)request.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"heartbeat groupId cannot be blank");
        return this.heartbeatClient.listStreamHeartbeat(request);
    }
}

