/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.NoAuth;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.NoAuthClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.user.UserRequest;

public class NoAuthImpl
implements NoAuth {
    private final NoAuthClient noAuthClient;

    public NoAuthImpl(ClientConfiguration configuration) {
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.noAuthClient = clientFactory.getNoAuthClient();
    }

    @Override
    public Integer register(UserRequest request) {
        Preconditions.expectNotBlank((String)request.getName(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"username cannot be empty");
        Preconditions.expectNotBlank((String)request.getPassword(), (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"password cannot be empty");
        Preconditions.expectNotNull((Object)request.getAccountType(), (String)"accountType cannot be null");
        Preconditions.expectNotNull((Object)request.getValidDays(), (String)"validDays cannot be null");
        return this.noAuthClient.register(request);
    }
}

