/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.AggregatedTable;
import org.apache.flink.table.api.ApiExpression;
import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Expressions;
import org.apache.flink.table.api.FlatAggregateTable;
import org.apache.flink.table.api.GroupWindow;
import org.apache.flink.table.api.GroupWindowedTable;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.OverWindowedTable;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableDescriptor;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TablePipeline;
import org.apache.flink.table.api.TableResult;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WindowGroupedTable;
import org.apache.flink.table.api.internal.TableEnvironmentInternal;
import org.apache.flink.table.api.internal.TablePipelineImpl;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.FunctionLookup;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.SchemaTranslator;
import org.apache.flink.table.catalog.UnresolvedIdentifier;
import org.apache.flink.table.delegation.ExpressionParser;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.UnresolvedReferenceExpression;
import org.apache.flink.table.expressions.resolver.LookupCallResolver;
import org.apache.flink.table.functions.TemporalTableFunction;
import org.apache.flink.table.functions.TemporalTableFunctionImpl;
import org.apache.flink.table.operations.JoinQueryOperation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.SinkModifyOperation;
import org.apache.flink.table.operations.utils.OperationExpressionsUtils;
import org.apache.flink.table.operations.utils.OperationTreeBuilder;

@Internal
public class TableImpl
implements Table {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private final TableEnvironmentInternal tableEnvironment;
    private final QueryOperation operationTree;
    private final OperationTreeBuilder operationTreeBuilder;
    private final LookupCallResolver lookupResolver;
    private String tableName = null;

    public TableEnvironment getTableEnvironment() {
        return this.tableEnvironment;
    }

    private TableImpl(TableEnvironmentInternal tableEnvironment, QueryOperation operationTree, OperationTreeBuilder operationTreeBuilder, LookupCallResolver lookupResolver) {
        this.tableEnvironment = tableEnvironment;
        this.operationTree = operationTree;
        this.operationTreeBuilder = operationTreeBuilder;
        this.lookupResolver = lookupResolver;
    }

    public static TableImpl createTable(TableEnvironmentInternal tableEnvironment, QueryOperation operationTree, OperationTreeBuilder operationTreeBuilder, FunctionLookup functionLookup) {
        return new TableImpl(tableEnvironment, operationTree, operationTreeBuilder, new LookupCallResolver(functionLookup));
    }

    @Override
    public ResolvedSchema getResolvedSchema() {
        return this.operationTree.getResolvedSchema();
    }

    @Override
    public void printSchema() {
        System.out.println(this.getResolvedSchema());
    }

    @Override
    public QueryOperation getQueryOperation() {
        return this.operationTree;
    }

    @Override
    public Table select(String fields) {
        return this.select(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
    }

    @Override
    public Table select(Expression ... fields) {
        List<Expression> expressionsWithResolvedCalls = this.preprocessExpressions(fields);
        OperationExpressionsUtils.CategorizedExpressions extracted = OperationExpressionsUtils.extractAggregationsAndProperties(expressionsWithResolvedCalls);
        if (!extracted.getWindowProperties().isEmpty()) {
            throw new ValidationException("Window properties can only be used on windowed tables.");
        }
        if (!extracted.getAggregations().isEmpty()) {
            QueryOperation aggregate = this.operationTreeBuilder.aggregate(Collections.emptyList(), extracted.getAggregations(), this.operationTree);
            return this.createTable(this.operationTreeBuilder.project(extracted.getProjections(), aggregate, false));
        }
        return this.createTable(this.operationTreeBuilder.project(expressionsWithResolvedCalls, this.operationTree, false));
    }

    @Override
    public TemporalTableFunction createTemporalTableFunction(String timeAttribute, String primaryKey) {
        return this.createTemporalTableFunction(ExpressionParser.INSTANCE.parseExpression(timeAttribute), ExpressionParser.INSTANCE.parseExpression(primaryKey));
    }

    @Override
    public TemporalTableFunction createTemporalTableFunction(Expression timeAttribute, Expression primaryKey) {
        Expression resolvedTimeAttribute = this.operationTreeBuilder.resolveExpression(timeAttribute, this.operationTree);
        Expression resolvedPrimaryKey = this.operationTreeBuilder.resolveExpression(primaryKey, this.operationTree);
        return TemporalTableFunctionImpl.create(this.operationTree, resolvedTimeAttribute, resolvedPrimaryKey);
    }

    @Override
    public Table as(String field, String ... fields) {
        ArrayList<Expression> fieldsExprs;
        if (fields.length == 0 && this.operationTree.getResolvedSchema().getColumnCount() > 1) {
            fieldsExprs = ExpressionParser.INSTANCE.parseExpressionList(field);
        } else {
            fieldsExprs = new ArrayList<ApiExpression>();
            fieldsExprs.add(Expressions.lit(field));
            for (String extraField : fields) {
                fieldsExprs.add(Expressions.lit(extraField));
            }
        }
        return this.createTable(this.operationTreeBuilder.alias(fieldsExprs, this.operationTree));
    }

    @Override
    public Table as(Expression ... fields) {
        return this.createTable(this.operationTreeBuilder.alias(Arrays.asList(fields), this.operationTree));
    }

    @Override
    public Table filter(String predicate) {
        return this.filter(ExpressionParser.INSTANCE.parseExpression(predicate));
    }

    @Override
    public Table filter(Expression predicate) {
        Expression resolvedCallPredicate = (Expression)predicate.accept((ExpressionVisitor)this.lookupResolver);
        return this.createTable(this.operationTreeBuilder.filter(resolvedCallPredicate, this.operationTree));
    }

    @Override
    public Table where(String predicate) {
        return this.filter(predicate);
    }

    @Override
    public Table where(Expression predicate) {
        return this.filter(predicate);
    }

    @Override
    public GroupedTable groupBy(String fields) {
        return new GroupedTableImpl(this, ExpressionParser.INSTANCE.parseExpressionList(fields));
    }

    @Override
    public GroupedTable groupBy(Expression ... fields) {
        return new GroupedTableImpl(this, Arrays.asList(fields));
    }

    @Override
    public Table distinct() {
        return this.createTable(this.operationTreeBuilder.distinct(this.operationTree));
    }

    @Override
    public Table join(Table right) {
        return this.joinInternal(right, Optional.empty(), JoinQueryOperation.JoinType.INNER);
    }

    @Override
    public Table join(Table right, String joinPredicate) {
        return this.join(right, ExpressionParser.INSTANCE.parseExpression(joinPredicate));
    }

    @Override
    public Table join(Table right, Expression joinPredicate) {
        return this.joinInternal(right, Optional.of(joinPredicate), JoinQueryOperation.JoinType.INNER);
    }

    @Override
    public Table leftOuterJoin(Table right) {
        return this.joinInternal(right, Optional.empty(), JoinQueryOperation.JoinType.LEFT_OUTER);
    }

    @Override
    public Table leftOuterJoin(Table right, String joinPredicate) {
        return this.leftOuterJoin(right, ExpressionParser.INSTANCE.parseExpression(joinPredicate));
    }

    @Override
    public Table leftOuterJoin(Table right, Expression joinPredicate) {
        return this.joinInternal(right, Optional.of(joinPredicate), JoinQueryOperation.JoinType.LEFT_OUTER);
    }

    @Override
    public Table rightOuterJoin(Table right, String joinPredicate) {
        return this.rightOuterJoin(right, ExpressionParser.INSTANCE.parseExpression(joinPredicate));
    }

    @Override
    public Table rightOuterJoin(Table right, Expression joinPredicate) {
        return this.joinInternal(right, Optional.of(joinPredicate), JoinQueryOperation.JoinType.RIGHT_OUTER);
    }

    @Override
    public Table fullOuterJoin(Table right, String joinPredicate) {
        return this.fullOuterJoin(right, ExpressionParser.INSTANCE.parseExpression(joinPredicate));
    }

    @Override
    public Table fullOuterJoin(Table right, Expression joinPredicate) {
        return this.joinInternal(right, Optional.of(joinPredicate), JoinQueryOperation.JoinType.FULL_OUTER);
    }

    private TableImpl joinInternal(Table right, Optional<Expression> joinPredicate, JoinQueryOperation.JoinType joinType) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.join(this.operationTree, right.getQueryOperation(), joinType, joinPredicate, false));
    }

    private void verifyTableCompatible(Table right) {
        if (((TableImpl)right).getTableEnvironment() != this.tableEnvironment) {
            throw new ValidationException("Only tables from the same TableEnvironment can be joined.");
        }
    }

    @Override
    public Table joinLateral(String tableFunctionCall) {
        return this.joinLateral(ExpressionParser.INSTANCE.parseExpression(tableFunctionCall));
    }

    @Override
    public Table joinLateral(Expression tableFunctionCall) {
        return this.joinLateralInternal(tableFunctionCall, Optional.empty(), JoinQueryOperation.JoinType.INNER);
    }

    @Override
    public Table joinLateral(String tableFunctionCall, String joinPredicate) {
        return this.joinLateral(ExpressionParser.INSTANCE.parseExpression(tableFunctionCall), ExpressionParser.INSTANCE.parseExpression(joinPredicate));
    }

    @Override
    public Table joinLateral(Expression tableFunctionCall, Expression joinPredicate) {
        return this.joinLateralInternal(tableFunctionCall, Optional.of(joinPredicate), JoinQueryOperation.JoinType.INNER);
    }

    @Override
    public Table leftOuterJoinLateral(String tableFunctionCall) {
        return this.leftOuterJoinLateral(ExpressionParser.INSTANCE.parseExpression(tableFunctionCall));
    }

    @Override
    public Table leftOuterJoinLateral(Expression tableFunctionCall) {
        return this.joinLateralInternal(tableFunctionCall, Optional.empty(), JoinQueryOperation.JoinType.LEFT_OUTER);
    }

    @Override
    public Table leftOuterJoinLateral(String tableFunctionCall, String joinPredicate) {
        return this.leftOuterJoinLateral(ExpressionParser.INSTANCE.parseExpression(tableFunctionCall), ExpressionParser.INSTANCE.parseExpression(joinPredicate));
    }

    @Override
    public Table leftOuterJoinLateral(Expression tableFunctionCall, Expression joinPredicate) {
        return this.joinLateralInternal(tableFunctionCall, Optional.of(joinPredicate), JoinQueryOperation.JoinType.LEFT_OUTER);
    }

    private TableImpl joinLateralInternal(Expression callExpr, Optional<Expression> joinPredicate, JoinQueryOperation.JoinType joinType) {
        if (joinType != JoinQueryOperation.JoinType.INNER && joinType != JoinQueryOperation.JoinType.LEFT_OUTER) {
            throw new ValidationException("Table functions are currently only supported for inner and left outer lateral joins.");
        }
        return this.createTable(this.operationTreeBuilder.joinLateral(this.operationTree, callExpr, joinType, joinPredicate));
    }

    @Override
    public Table minus(Table right) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.minus(this.operationTree, right.getQueryOperation(), false));
    }

    @Override
    public Table minusAll(Table right) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.minus(this.operationTree, right.getQueryOperation(), true));
    }

    @Override
    public Table union(Table right) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.union(this.operationTree, right.getQueryOperation(), false));
    }

    @Override
    public Table unionAll(Table right) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.union(this.operationTree, right.getQueryOperation(), true));
    }

    @Override
    public Table intersect(Table right) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.intersect(this.operationTree, right.getQueryOperation(), false));
    }

    @Override
    public Table intersectAll(Table right) {
        this.verifyTableCompatible(right);
        return this.createTable(this.operationTreeBuilder.intersect(this.operationTree, right.getQueryOperation(), true));
    }

    @Override
    public Table orderBy(String fields) {
        return this.createTable(this.operationTreeBuilder.sort(ExpressionParser.INSTANCE.parseExpressionList(fields), this.operationTree));
    }

    @Override
    public Table orderBy(Expression ... fields) {
        return this.createTable(this.operationTreeBuilder.sort(Arrays.asList(fields), this.operationTree));
    }

    @Override
    public Table offset(int offset) {
        return this.createTable(this.operationTreeBuilder.limitWithOffset(offset, this.operationTree));
    }

    @Override
    public Table fetch(int fetch) {
        if (fetch < 0) {
            throw new ValidationException("FETCH count must be equal or larger than 0.");
        }
        return this.createTable(this.operationTreeBuilder.limitWithFetch(fetch, this.operationTree));
    }

    @Override
    public GroupWindowedTable window(GroupWindow groupWindow) {
        return new GroupWindowedTableImpl(this, groupWindow);
    }

    @Override
    public OverWindowedTable window(OverWindow ... overWindows) {
        if (overWindows.length != 1) {
            throw new TableException("Currently, only a single over window is supported.");
        }
        return new OverWindowedTableImpl(this, Arrays.asList(overWindows));
    }

    @Override
    public Table addColumns(String fields) {
        return this.addColumnsOperation(false, ExpressionParser.INSTANCE.parseExpressionList(fields));
    }

    @Override
    public Table addColumns(Expression ... fields) {
        return this.addColumnsOperation(false, Arrays.asList(fields));
    }

    @Override
    public Table addOrReplaceColumns(String fields) {
        return this.addColumnsOperation(true, ExpressionParser.INSTANCE.parseExpressionList(fields));
    }

    @Override
    public Table addOrReplaceColumns(Expression ... fields) {
        return this.addColumnsOperation(true, Arrays.asList(fields));
    }

    private Table addColumnsOperation(boolean replaceIfExist, List<Expression> fields) {
        List<Expression> expressionsWithResolvedCalls = this.preprocessExpressions(fields);
        OperationExpressionsUtils.CategorizedExpressions extracted = OperationExpressionsUtils.extractAggregationsAndProperties(expressionsWithResolvedCalls);
        List<Expression> aggNames = extracted.getAggregations();
        if (!aggNames.isEmpty()) {
            throw new ValidationException("The added field expression cannot be an aggregation, found: " + aggNames.get(0));
        }
        return this.createTable(this.operationTreeBuilder.addColumns(replaceIfExist, expressionsWithResolvedCalls, this.operationTree));
    }

    @Override
    public Table renameColumns(String fields) {
        return this.createTable(this.operationTreeBuilder.renameColumns(ExpressionParser.INSTANCE.parseExpressionList(fields), this.operationTree));
    }

    @Override
    public Table renameColumns(Expression ... fields) {
        return this.createTable(this.operationTreeBuilder.renameColumns(Arrays.asList(fields), this.operationTree));
    }

    @Override
    public Table dropColumns(String fields) {
        return this.createTable(this.operationTreeBuilder.dropColumns(ExpressionParser.INSTANCE.parseExpressionList(fields), this.operationTree));
    }

    @Override
    public Table dropColumns(Expression ... fields) {
        return this.createTable(this.operationTreeBuilder.dropColumns(Arrays.asList(fields), this.operationTree));
    }

    @Override
    public Table map(String mapFunction) {
        return this.map(ExpressionParser.INSTANCE.parseExpression(mapFunction));
    }

    @Override
    public Table map(Expression mapFunction) {
        return this.createTable(this.operationTreeBuilder.map(mapFunction, this.operationTree));
    }

    @Override
    public Table flatMap(String tableFunction) {
        return this.flatMap(ExpressionParser.INSTANCE.parseExpression(tableFunction));
    }

    @Override
    public Table flatMap(Expression tableFunction) {
        return this.createTable(this.operationTreeBuilder.flatMap(tableFunction, this.operationTree));
    }

    @Override
    public AggregatedTable aggregate(String aggregateFunction) {
        return this.aggregate(ExpressionParser.INSTANCE.parseExpression(aggregateFunction));
    }

    @Override
    public AggregatedTable aggregate(Expression aggregateFunction) {
        return this.groupBy(new Expression[0]).aggregate(aggregateFunction);
    }

    @Override
    public FlatAggregateTable flatAggregate(String tableAggregateFunction) {
        return this.groupBy(new Expression[0]).flatAggregate(tableAggregateFunction);
    }

    @Override
    public FlatAggregateTable flatAggregate(Expression tableAggregateFunction) {
        return this.groupBy(new Expression[0]).flatAggregate(tableAggregateFunction);
    }

    @Override
    public TablePipeline insertInto(String tablePath) {
        return this.insertInto(tablePath, false);
    }

    @Override
    public TablePipeline insertInto(String tablePath, boolean overwrite) {
        UnresolvedIdentifier unresolvedIdentifier = this.tableEnvironment.getParser().parseIdentifier(tablePath);
        ObjectIdentifier objectIdentifier = this.tableEnvironment.getCatalogManager().qualifyIdentifier(unresolvedIdentifier);
        ContextResolvedTable contextResolvedTable = this.tableEnvironment.getCatalogManager().getTableOrError(objectIdentifier);
        return this.insertInto(contextResolvedTable, overwrite);
    }

    @Override
    public TablePipeline insertInto(TableDescriptor descriptor) {
        return this.insertInto(descriptor, false);
    }

    @Override
    public TablePipeline insertInto(TableDescriptor descriptor, boolean overwrite) {
        SchemaTranslator.ConsumingResult schemaTranslationResult = SchemaTranslator.createConsumingResult(this.tableEnvironment.getCatalogManager().getDataTypeFactory(), this.getResolvedSchema().toSourceRowDataType(), descriptor.getSchema().orElse(null), false);
        TableDescriptor updatedDescriptor = descriptor.toBuilder().schema(schemaTranslationResult.getSchema()).build();
        ResolvedCatalogTable resolvedCatalogBaseTable = this.tableEnvironment.getCatalogManager().resolveCatalogTable(updatedDescriptor.toCatalogTable());
        return this.insertInto(ContextResolvedTable.anonymous(resolvedCatalogBaseTable), overwrite);
    }

    private TablePipeline insertInto(ContextResolvedTable contextResolvedTable, boolean overwrite) {
        return new TablePipelineImpl(this.tableEnvironment, new SinkModifyOperation(contextResolvedTable, this.getQueryOperation(), Collections.emptyMap(), overwrite, Collections.emptyMap()));
    }

    @Override
    public TableResult execute() {
        return this.tableEnvironment.executeInternal(this.getQueryOperation());
    }

    @Override
    public String explain(ExplainDetail ... extraDetails) {
        return this.tableEnvironment.explainInternal(Collections.singletonList(this.getQueryOperation()), extraDetails);
    }

    public String toString() {
        if (this.tableName == null) {
            this.tableName = "UnnamedTable$" + uniqueId.getAndIncrement();
            this.tableEnvironment.registerTable(this.tableName, this);
        }
        return this.tableName;
    }

    private TableImpl createTable(QueryOperation operation) {
        return new TableImpl(this.tableEnvironment, operation, this.operationTreeBuilder, this.lookupResolver);
    }

    private List<Expression> preprocessExpressions(List<Expression> expressions) {
        return this.preprocessExpressions(expressions.toArray(new Expression[0]));
    }

    private List<Expression> preprocessExpressions(Expression[] expressions) {
        return Arrays.stream(expressions).map((? super T f) -> (Expression)f.accept((ExpressionVisitor)this.lookupResolver)).collect(Collectors.toList());
    }

    private static final class OverWindowedTableImpl
    implements OverWindowedTable {
        private final TableImpl table;
        private final List<OverWindow> overWindows;

        private OverWindowedTableImpl(TableImpl table, List<OverWindow> overWindows) {
            this.table = table;
            this.overWindows = overWindows;
        }

        @Override
        public Table select(String fields) {
            return this.table.createTable(this.table.operationTreeBuilder.project(ExpressionParser.INSTANCE.parseExpressionList(fields), this.table.operationTree, this.overWindows));
        }

        @Override
        public Table select(Expression ... fields) {
            return this.table.createTable(this.table.operationTreeBuilder.project(Arrays.asList(fields), this.table.operationTree, this.overWindows));
        }
    }

    private static final class WindowFlatAggregateTableImpl
    implements FlatAggregateTable {
        private final TableImpl table;
        private final List<Expression> groupKeys;
        private final Expression tableAggFunction;
        private final GroupWindow window;

        private WindowFlatAggregateTableImpl(TableImpl table, List<Expression> groupKeys, Expression tableAggFunction, GroupWindow window) {
            this.table = table;
            this.groupKeys = groupKeys;
            this.tableAggFunction = tableAggFunction;
            this.window = window;
        }

        @Override
        public Table select(String fields) {
            return this.select(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
        }

        @Override
        public Table select(Expression ... fields) {
            List expressionsWithResolvedCalls = this.table.preprocessExpressions(fields);
            OperationExpressionsUtils.CategorizedExpressions extracted = OperationExpressionsUtils.extractAggregationsAndProperties(expressionsWithResolvedCalls);
            if (!extracted.getAggregations().isEmpty()) {
                throw new ValidationException("Aggregate functions cannot be used in the select right after the flatAggregate.");
            }
            if (extracted.getProjections().stream().anyMatch(p -> p instanceof UnresolvedReferenceExpression && "*".equals(((UnresolvedReferenceExpression)p).getName()))) {
                throw new ValidationException("Can not use * for window aggregate!");
            }
            return this.table.createTable(this.table.operationTreeBuilder.project(extracted.getProjections(), this.table.operationTreeBuilder.windowTableAggregate(this.groupKeys, this.window, extracted.getWindowProperties(), this.tableAggFunction, this.table.operationTree), true));
        }
    }

    private static final class WindowAggregatedTableImpl
    implements AggregatedTable {
        private final TableImpl table;
        private final List<Expression> groupKeys;
        private final Expression aggregateFunction;
        private final GroupWindow window;

        private WindowAggregatedTableImpl(TableImpl table, List<Expression> groupKeys, Expression aggregateFunction, GroupWindow window) {
            this.table = table;
            this.groupKeys = groupKeys;
            this.aggregateFunction = aggregateFunction;
            this.window = window;
        }

        @Override
        public Table select(String fields) {
            return this.select(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
        }

        @Override
        public Table select(Expression ... fields) {
            List expressionsWithResolvedCalls = this.table.preprocessExpressions(fields);
            OperationExpressionsUtils.CategorizedExpressions extracted = OperationExpressionsUtils.extractAggregationsAndProperties(expressionsWithResolvedCalls);
            if (!extracted.getAggregations().isEmpty()) {
                throw new ValidationException("Aggregate functions cannot be used in the select right after the aggregate.");
            }
            if (extracted.getProjections().stream().anyMatch(p -> p instanceof UnresolvedReferenceExpression && "*".equals(((UnresolvedReferenceExpression)p).getName()))) {
                throw new ValidationException("Can not use * for window aggregate!");
            }
            return this.table.createTable(this.table.operationTreeBuilder.project(extracted.getProjections(), this.table.operationTreeBuilder.windowAggregate(this.groupKeys, this.window, extracted.getWindowProperties(), this.aggregateFunction, this.table.operationTree)));
        }
    }

    private static final class WindowGroupedTableImpl
    implements WindowGroupedTable {
        private final TableImpl table;
        private final List<Expression> groupKeys;
        private final GroupWindow window;

        private WindowGroupedTableImpl(TableImpl table, List<Expression> groupKeys, GroupWindow window) {
            this.table = table;
            this.groupKeys = groupKeys;
            this.window = window;
        }

        @Override
        public Table select(String fields) {
            return this.select(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
        }

        @Override
        public Table select(Expression ... fields) {
            List expressionsWithResolvedCalls = this.table.preprocessExpressions(fields);
            OperationExpressionsUtils.CategorizedExpressions extracted = OperationExpressionsUtils.extractAggregationsAndProperties(expressionsWithResolvedCalls);
            return this.table.createTable(this.table.operationTreeBuilder.project(extracted.getProjections(), this.table.operationTreeBuilder.windowAggregate(this.groupKeys, this.window, extracted.getWindowProperties(), extracted.getAggregations(), this.table.operationTree), true));
        }

        @Override
        public AggregatedTable aggregate(String aggregateFunction) {
            return this.aggregate(ExpressionParser.INSTANCE.parseExpression(aggregateFunction));
        }

        @Override
        public AggregatedTable aggregate(Expression aggregateFunction) {
            return new WindowAggregatedTableImpl(this.table, this.groupKeys, aggregateFunction, this.window);
        }

        @Override
        public FlatAggregateTable flatAggregate(String tableAggregateFunction) {
            return this.flatAggregate(ExpressionParser.INSTANCE.parseExpression(tableAggregateFunction));
        }

        @Override
        public FlatAggregateTable flatAggregate(Expression tableAggregateFunction) {
            return new WindowFlatAggregateTableImpl(this.table, this.groupKeys, tableAggregateFunction, this.window);
        }
    }

    private static final class GroupWindowedTableImpl
    implements GroupWindowedTable {
        private final TableImpl table;
        private final GroupWindow window;

        private GroupWindowedTableImpl(TableImpl table, GroupWindow window) {
            this.table = table;
            this.window = window;
        }

        @Override
        public WindowGroupedTable groupBy(String fields) {
            return this.groupBy(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
        }

        @Override
        public WindowGroupedTable groupBy(Expression ... fields) {
            List fieldsWithoutWindow = this.table.preprocessExpressions(fields).stream().filter(f -> !this.window.getAlias().equals(f)).collect(Collectors.toList());
            if (fields.length != fieldsWithoutWindow.size() + 1) {
                throw new ValidationException("GroupBy must contain exactly one window alias.");
            }
            return new WindowGroupedTableImpl(this.table, fieldsWithoutWindow, this.window);
        }
    }

    private static final class FlatAggregateTableImpl
    implements FlatAggregateTable {
        private final TableImpl table;
        private final List<Expression> groupKey;
        private final Expression tableAggregateFunction;

        private FlatAggregateTableImpl(TableImpl table, List<Expression> groupKey, Expression tableAggregateFunction) {
            this.table = table;
            this.groupKey = groupKey;
            this.tableAggregateFunction = tableAggregateFunction;
        }

        @Override
        public Table select(String fields) {
            return this.table.createTable(this.table.operationTreeBuilder.project(ExpressionParser.INSTANCE.parseExpressionList(fields), this.table.operationTreeBuilder.tableAggregate(this.groupKey, (Expression)this.tableAggregateFunction.accept((ExpressionVisitor)this.table.lookupResolver), this.table.operationTree)));
        }

        @Override
        public Table select(Expression ... fields) {
            return this.table.createTable(this.table.operationTreeBuilder.project(Arrays.asList(fields), this.table.operationTreeBuilder.tableAggregate(this.groupKey, (Expression)this.tableAggregateFunction.accept((ExpressionVisitor)this.table.lookupResolver), this.table.operationTree)));
        }
    }

    private static final class AggregatedTableImpl
    implements AggregatedTable {
        private final TableImpl table;
        private final List<Expression> groupKeys;
        private final Expression aggregateFunction;

        private AggregatedTableImpl(TableImpl table, List<Expression> groupKeys, Expression aggregateFunction) {
            this.table = table;
            this.groupKeys = groupKeys;
            this.aggregateFunction = aggregateFunction;
        }

        @Override
        public Table select(String fields) {
            return this.select(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
        }

        @Override
        public Table select(Expression ... fields) {
            return this.table.createTable(this.table.operationTreeBuilder.project(Arrays.asList(fields), this.table.operationTreeBuilder.aggregate(this.groupKeys, this.aggregateFunction, this.table.operationTree)));
        }
    }

    private static final class GroupedTableImpl
    implements GroupedTable {
        private final TableImpl table;
        private final List<Expression> groupKeys;

        private GroupedTableImpl(TableImpl table, List<Expression> groupKeys) {
            this.table = table;
            this.groupKeys = groupKeys;
        }

        @Override
        public Table select(String fields) {
            return this.select(ExpressionParser.INSTANCE.parseExpressionList(fields).toArray(new Expression[0]));
        }

        @Override
        public Table select(Expression ... fields) {
            List expressionsWithResolvedCalls = this.table.preprocessExpressions(fields);
            OperationExpressionsUtils.CategorizedExpressions extracted = OperationExpressionsUtils.extractAggregationsAndProperties(expressionsWithResolvedCalls);
            if (!extracted.getWindowProperties().isEmpty()) {
                throw new ValidationException("Window properties can only be used on windowed tables.");
            }
            return this.table.createTable(this.table.operationTreeBuilder.project(extracted.getProjections(), this.table.operationTreeBuilder.aggregate(this.groupKeys, extracted.getAggregations(), this.table.operationTree)));
        }

        @Override
        public AggregatedTable aggregate(String aggregateFunction) {
            return this.aggregate(ExpressionParser.INSTANCE.parseExpression(aggregateFunction));
        }

        @Override
        public AggregatedTable aggregate(Expression aggregateFunction) {
            return new AggregatedTableImpl(this.table, this.groupKeys, aggregateFunction);
        }

        @Override
        public FlatAggregateTable flatAggregate(String tableAggFunction) {
            return this.flatAggregate(ExpressionParser.INSTANCE.parseExpression(tableAggFunction));
        }

        @Override
        public FlatAggregateTable flatAggregate(Expression tableAggFunction) {
            return new FlatAggregateTableImpl(this.table, this.groupKeys, tableAggFunction);
        }
    }
}

