/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;
import org.eclipse.milo.opcua.stack.core.types.structured.ViewDescription;

public class BrowseRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=525");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=527");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=526");
    public static final ExpandedNodeId JSON_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=15184");
    private final RequestHeader requestHeader;
    private final ViewDescription view;
    private final UInteger requestedMaxReferencesPerNode;
    private final BrowseDescription[] nodesToBrowse;

    public BrowseRequest(RequestHeader requestHeader, ViewDescription view, UInteger requestedMaxReferencesPerNode, BrowseDescription[] nodesToBrowse) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
        this.nodesToBrowse = nodesToBrowse;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public UInteger getRequestedMaxReferencesPerNode() {
        return this.requestedMaxReferencesPerNode;
    }

    public BrowseDescription[] getNodesToBrowse() {
        return this.nodesToBrowse;
    }

    protected BrowseRequest(BrowseRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((BrowseRequestBuilder)b).requestHeader;
        this.view = ((BrowseRequestBuilder)b).view;
        this.requestedMaxReferencesPerNode = ((BrowseRequestBuilder)b).requestedMaxReferencesPerNode;
        this.nodesToBrowse = ((BrowseRequestBuilder)b).nodesToBrowse;
    }

    public static BrowseRequestBuilder<?, ?> builder() {
        return new BrowseRequestBuilderImpl();
    }

    public BrowseRequestBuilder<?, ?> toBuilder() {
        return new BrowseRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrowseRequest)) {
            return false;
        }
        BrowseRequest other = (BrowseRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        ViewDescription this$view = this.getView();
        ViewDescription other$view = other.getView();
        if (this$view == null ? other$view != null : !((Object)this$view).equals(other$view)) {
            return false;
        }
        UInteger this$requestedMaxReferencesPerNode = this.getRequestedMaxReferencesPerNode();
        UInteger other$requestedMaxReferencesPerNode = other.getRequestedMaxReferencesPerNode();
        if (this$requestedMaxReferencesPerNode == null ? other$requestedMaxReferencesPerNode != null : !((Object)this$requestedMaxReferencesPerNode).equals(other$requestedMaxReferencesPerNode)) {
            return false;
        }
        return Arrays.deepEquals(this.getNodesToBrowse(), other.getNodesToBrowse());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrowseRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        ViewDescription $view = this.getView();
        result = result * 59 + ($view == null ? 43 : ((Object)$view).hashCode());
        UInteger $requestedMaxReferencesPerNode = this.getRequestedMaxReferencesPerNode();
        result = result * 59 + ($requestedMaxReferencesPerNode == null ? 43 : ((Object)$requestedMaxReferencesPerNode).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNodesToBrowse());
        return result;
    }

    @Override
    public String toString() {
        return "BrowseRequest(requestHeader=" + this.getRequestHeader() + ", view=" + this.getView() + ", requestedMaxReferencesPerNode=" + this.getRequestedMaxReferencesPerNode() + ", nodesToBrowse=" + Arrays.deepToString(this.getNodesToBrowse()) + ")";
    }

    private static final class BrowseRequestBuilderImpl
    extends BrowseRequestBuilder<BrowseRequest, BrowseRequestBuilderImpl> {
        private BrowseRequestBuilderImpl() {
        }

        @Override
        protected BrowseRequestBuilderImpl self() {
            return this;
        }

        @Override
        public BrowseRequest build() {
            return new BrowseRequest(this);
        }
    }

    public static abstract class BrowseRequestBuilder<C extends BrowseRequest, B extends BrowseRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private ViewDescription view;
        private UInteger requestedMaxReferencesPerNode;
        private BrowseDescription[] nodesToBrowse;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BrowseRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(BrowseRequest instance, BrowseRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.view(instance.view);
            b.requestedMaxReferencesPerNode(instance.requestedMaxReferencesPerNode);
            b.nodesToBrowse(instance.nodesToBrowse);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B view(ViewDescription view) {
            this.view = view;
            return (B)this.self();
        }

        public B requestedMaxReferencesPerNode(UInteger requestedMaxReferencesPerNode) {
            this.requestedMaxReferencesPerNode = requestedMaxReferencesPerNode;
            return (B)this.self();
        }

        public B nodesToBrowse(BrowseDescription[] nodesToBrowse) {
            this.nodesToBrowse = nodesToBrowse;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "BrowseRequest.BrowseRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", view=" + this.view + ", requestedMaxReferencesPerNode=" + this.requestedMaxReferencesPerNode + ", nodesToBrowse=" + Arrays.deepToString(this.nodesToBrowse) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<BrowseRequest> {
        @Override
        public Class<BrowseRequest> getType() {
            return BrowseRequest.class;
        }

        @Override
        public BrowseRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            ViewDescription view = (ViewDescription)decoder.readStruct("View", ViewDescription.TYPE_ID);
            UInteger requestedMaxReferencesPerNode = decoder.readUInt32("RequestedMaxReferencesPerNode");
            BrowseDescription[] nodesToBrowse = (BrowseDescription[])decoder.readStructArray("NodesToBrowse", BrowseDescription.TYPE_ID);
            return new BrowseRequest(requestHeader, view, requestedMaxReferencesPerNode, nodesToBrowse);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, BrowseRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeStruct("View", (Object)value.getView(), ViewDescription.TYPE_ID);
            encoder.writeUInt32("RequestedMaxReferencesPerNode", value.getRequestedMaxReferencesPerNode());
            encoder.writeStructArray("NodesToBrowse", (Object[])value.getNodesToBrowse(), BrowseDescription.TYPE_ID);
        }
    }
}

