/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.jdbc;

import java.util.List;
import org.apache.iotdb.service.rpc.thrift.TSTracingInfo;

public class IoTDBTracingInfo {
    private TSTracingInfo tsTracingInfo;

    public void setTsTracingInfo(TSTracingInfo tsTracingInfo) {
        this.tsTracingInfo = tsTracingInfo;
    }

    public boolean isSetTracingInfo() {
        return this.tsTracingInfo != null;
    }

    public List<String> getActivityList() {
        return this.tsTracingInfo.getActivityList();
    }

    public List<Long> getElapsedTimeList() {
        return this.tsTracingInfo.getElapsedTimeList();
    }

    public long getStatisticsByName(String name) throws Exception {
        switch (name) {
            case "seriesPathNum": {
                return this.tsTracingInfo.getSeriesPathNum();
            }
            case "seqFileNum": {
                return this.tsTracingInfo.getSeqFileNum();
            }
            case "unSeqFileNum": {
                return this.tsTracingInfo.getUnSeqFileNum();
            }
            case "seqChunkNum": {
                return this.tsTracingInfo.getSequenceChunkNum();
            }
            case "seqChunkPointNum": {
                return this.tsTracingInfo.getSequenceChunkPointNum();
            }
            case "unSeqChunkNum": {
                return this.tsTracingInfo.getUnsequenceChunkNum();
            }
            case "unSeqChunkPointNum": {
                return this.tsTracingInfo.getUnsequenceChunkPointNum();
            }
            case "totalPageNum": {
                return this.tsTracingInfo.getTotalPageNum();
            }
            case "overlappedPageNum": {
                return this.tsTracingInfo.getOverlappedPageNum();
            }
        }
        throw new Exception("Invalid statistics name!");
    }

    public String getStatisticsInfoByName(String name) throws Exception {
        switch (name) {
            case "seriesPathNum": {
                return String.format("* Num of series paths: %d", this.tsTracingInfo.getSeriesPathNum());
            }
            case "seqFileNum": {
                return String.format("* Num of sequence files read: %d", this.tsTracingInfo.getSeqFileNum());
            }
            case "unSeqFileNum": {
                return String.format("* Num of unsequence files read: %d", this.tsTracingInfo.getUnSeqFileNum());
            }
            case "seqChunkInfo": {
                return String.format("* Num of sequence chunks: %d, avg points: %.1f", this.tsTracingInfo.getSequenceChunkNum(), (double)this.tsTracingInfo.getSequenceChunkPointNum() / (double)this.tsTracingInfo.getSequenceChunkNum());
            }
            case "unSeqChunkInfo": {
                return String.format("* Num of unsequence chunks: %d, avg points: %.1f", this.tsTracingInfo.getUnsequenceChunkNum(), (double)this.tsTracingInfo.getUnsequenceChunkPointNum() / (double)this.tsTracingInfo.getUnsequenceChunkNum());
            }
            case "pageNumInfo": {
                return String.format("* Num of Pages: %d, overlapped pages: %d (%.1f%%)", this.tsTracingInfo.getTotalPageNum(), this.tsTracingInfo.getOverlappedPageNum(), (double)this.tsTracingInfo.getOverlappedPageNum() / (double)this.tsTracingInfo.getTotalPageNum() * 100.0);
            }
        }
        throw new Exception("Invalid statistics name!");
    }
}

