/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.frequency;

import java.util.ArrayList;
import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.Row;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFConv
implements UDTF {
    private final ArrayList<Double> list1 = new ArrayList();
    private final ArrayList<Double> list2 = new ArrayList();

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesNumber(2).validateInputSeriesDataType(0, Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64).validateInputSeriesDataType(1, Type.DOUBLE, Type.FLOAT, Type.INT32, Type.INT64);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(Type.DOUBLE);
        this.list1.clear();
        this.list2.clear();
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        if (!row.isNull(0) && Double.isFinite(Util.getValueAsDouble(row, 0))) {
            this.list1.add(Util.getValueAsDouble(row, 0));
        }
        if (!row.isNull(1) && Double.isFinite(Util.getValueAsDouble(row, 1))) {
            this.list2.add(Util.getValueAsDouble(row, 1));
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
        int i;
        double[] ans = new double[this.list1.size() + this.list2.size() - 1];
        for (i = 0; i < this.list1.size(); ++i) {
            for (int j = 0; j < this.list2.size(); ++j) {
                int n = i + j;
                ans[n] = ans[n] + this.list1.get(i) * this.list2.get(j);
            }
        }
        for (i = 0; i < ans.length; ++i) {
            collector.putDouble(i, ans[i]);
        }
    }
}

