/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.client.dn;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.client.request.AsyncRequestContext;
import org.apache.iotdb.commons.client.request.AsyncRequestRPCHandler;
import org.apache.iotdb.db.protocol.client.dn.AsyncTSStatusRPCHandler;
import org.apache.iotdb.db.protocol.client.dn.DnToDnRequestType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataNodeAsyncRequestRPCHandler<Response>
extends AsyncRequestRPCHandler<Response, DnToDnRequestType, TDataNodeLocation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataNodeAsyncRequestRPCHandler.class);

    protected DataNodeAsyncRequestRPCHandler(DnToDnRequestType dataNodeToDataNodeRequestType, int requestId, TDataNodeLocation targetNode, Map<Integer, TDataNodeLocation> dataNodeLocationMap, Map<Integer, Response> integerResponseMap, CountDownLatch countDownLatch) {
        super((Object)dataNodeToDataNodeRequestType, requestId, (Object)targetNode, dataNodeLocationMap, integerResponseMap, countDownLatch);
    }

    protected String generateFormattedTargetLocation(TDataNodeLocation dataNodeLocation) {
        return "{id=" + ((TDataNodeLocation)this.targetNode).getDataNodeId() + ", internalEndPoint=" + ((TDataNodeLocation)this.targetNode).getInternalEndPoint() + "}";
    }

    public static DataNodeAsyncRequestRPCHandler<?> createAsyncRPCHandler(AsyncRequestContext<?, ?, DnToDnRequestType, TDataNodeLocation> context, int requestId, TDataNodeLocation targetDataNode) {
        boolean keepSilent;
        DnToDnRequestType requestType = (DnToDnRequestType)((Object)context.getRequestType());
        Map nodeLocationMap = context.getNodeLocationMap();
        Map responseMap = context.getResponseMap();
        CountDownLatch countDownLatch = context.getCountDownLatch();
        switch (requestType) {
            case TEST_CONNECTION: {
                keepSilent = true;
                break;
            }
            case UPDATE_ATTRIBUTE: {
                keepSilent = false;
                break;
            }
            default: {
                throw new UnsupportedOperationException("request type is not supported: " + (Object)((Object)requestType));
            }
        }
        return new AsyncTSStatusRPCHandler(requestType, requestId, targetDataNode, nodeLocationMap, responseMap, countDownLatch, keepSilent);
    }
}

