/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.handler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.async.AsyncPipeConsensusServiceClient;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.sink.payload.pipeconsensus.response.PipeConsensusTransferFilePieceResp;
import org.apache.iotdb.commons.utils.RetryUtils;
import org.apache.iotdb.consensus.pipe.thrift.TCommitId;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferReq;
import org.apache.iotdb.consensus.pipe.thrift.TPipeConsensusTransferResp;
import org.apache.iotdb.db.pipe.consensus.metric.PipeConsensusSinkMetrics;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.PipeConsensusAsyncSink;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFilePieceReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFilePieceWithModReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFileSealReq;
import org.apache.iotdb.db.pipe.sink.protocol.pipeconsensus.payload.request.PipeConsensusTsFileSealWithModReq;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeConsensusTsFileInsertionEventHandler
implements AsyncMethodCallback<TPipeConsensusTransferResp> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeConsensusTsFileInsertionEventHandler.class);
    private final PipeTsFileInsertionEvent event;
    private final PipeConsensusAsyncSink connector;
    private final TCommitId commitId;
    private final TConsensusGroupId consensusGroupId;
    private final String consensusPipeName;
    private final int thisDataNodeId;
    private final File tsFile;
    private final File modFile;
    private File currentFile;
    private final boolean transferMod;
    private final int readFileBufferSize;
    private final byte[] readBuffer;
    private long position;
    private RandomAccessFile reader;
    private final AtomicBoolean isSealSignalSent;
    private AsyncPipeConsensusServiceClient client;
    private final PipeConsensusSinkMetrics metric;
    private final long createTime;
    private long startTransferPieceTime;

    public PipeConsensusTsFileInsertionEventHandler(PipeTsFileInsertionEvent event, PipeConsensusAsyncSink connector, TCommitId commitId, TConsensusGroupId consensusGroupId, String consensusPipeName, int thisDataNodeId, PipeConsensusSinkMetrics metric) throws FileNotFoundException {
        this.event = event;
        this.connector = connector;
        this.commitId = commitId;
        this.consensusGroupId = consensusGroupId;
        this.consensusPipeName = consensusPipeName;
        this.thisDataNodeId = thisDataNodeId;
        this.tsFile = event.getTsFile();
        this.modFile = event.getModFile();
        this.transferMod = event.isWithMod();
        this.currentFile = this.transferMod ? this.modFile : this.tsFile;
        this.readFileBufferSize = PipeConfig.getInstance().getPipeConnectorReadFileBufferSize();
        this.readBuffer = new byte[this.readFileBufferSize];
        this.position = 0L;
        this.reader = Objects.nonNull(this.modFile) ? new RandomAccessFile(this.modFile, "r") : new RandomAccessFile(this.tsFile, "r");
        this.isSealSignalSent = new AtomicBoolean(false);
        this.metric = metric;
        this.createTime = System.nanoTime();
    }

    public void transfer(AsyncPipeConsensusServiceClient client) throws TException, IOException {
        this.startTransferPieceTime = System.nanoTime();
        this.client = client;
        client.setShouldReturnSelf(false);
        int readLength = this.reader.read(this.readBuffer);
        if (readLength == -1) {
            if (this.currentFile == this.modFile) {
                this.currentFile = this.tsFile;
                this.position = 0L;
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    LOGGER.warn("PipeConsensus-{}: Failed to close file reader when successfully transferred mod file.", (Object)this.consensusPipeName, (Object)e);
                }
                this.reader = new RandomAccessFile(this.tsFile, "r");
                this.transfer(client);
            } else if (this.currentFile == this.tsFile) {
                this.isSealSignalSent.set(true);
                client.pipeConsensusTransfer((TPipeConsensusTransferReq)(this.transferMod ? PipeConsensusTsFileSealWithModReq.toTPipeConsensusTransferReq(this.modFile.getName(), this.modFile.length(), this.tsFile.getName(), this.tsFile.length(), this.event.getFlushPointCount(), this.commitId, this.consensusGroupId, this.event.getProgressIndex(), this.thisDataNodeId) : PipeConsensusTsFileSealReq.toTPipeConsensusTransferReq(this.tsFile.getName(), this.tsFile.length(), this.event.getFlushPointCount(), this.commitId, this.consensusGroupId, this.event.getProgressIndex(), this.thisDataNodeId)), (AsyncMethodCallback)this);
            }
            return;
        }
        byte[] payload = readLength == this.readFileBufferSize ? this.readBuffer : Arrays.copyOfRange(this.readBuffer, 0, readLength);
        client.pipeConsensusTransfer((TPipeConsensusTransferReq)(this.transferMod ? PipeConsensusTsFilePieceWithModReq.toTPipeConsensusTransferReq(this.currentFile.getName(), this.position, payload, this.commitId, this.consensusGroupId, this.thisDataNodeId) : PipeConsensusTsFilePieceReq.toTPipeConsensusTransferReq(this.currentFile.getName(), this.position, payload, this.commitId, this.consensusGroupId, this.thisDataNodeId)), (AsyncMethodCallback)this);
        this.position += (long)readLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(TPipeConsensusTransferResp response) {
        block16: {
            block15: {
                if (!this.isSealSignalSent.get()) break block16;
                try {
                    TSStatus status = response.getStatus();
                    if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                        this.connector.statusHandler().handle(status, String.format("Seal file %s error, result status %s.", this.tsFile, response.getStatus()), this.tsFile.getName());
                    }
                    this.connector.removeEventFromBuffer(this.event);
                }
                catch (Exception e) {
                    this.onError(e);
                    return;
                }
                try {
                    if (this.reader == null) break block15;
                    this.reader.close();
                }
                catch (IOException e) {
                    try {
                        LOGGER.warn("PipeConsensus-{}: Failed to close file reader when successfully transferred file.", (Object)this.consensusPipeName, (Object)e);
                    }
                    catch (Throwable throwable) {
                        this.event.decreaseReferenceCount(PipeConsensusTsFileInsertionEventHandler.class.getName(), true);
                        LOGGER.info("PipeConsensus-{}: Successfully transferred file {} (committer key={}, replicate index={}).", new Object[]{this.consensusPipeName, this.tsFile, this.event.getCommitterKey(), this.event.getReplicateIndexForIoTV2()});
                        if (this.client != null) {
                            this.client.setShouldReturnSelf(true);
                            this.client.returnSelf();
                        }
                        long duration = System.nanoTime() - this.createTime;
                        this.metric.recordConnectorTsFileTransferTimer(duration);
                        throw throwable;
                    }
                    this.event.decreaseReferenceCount(PipeConsensusTsFileInsertionEventHandler.class.getName(), true);
                    LOGGER.info("PipeConsensus-{}: Successfully transferred file {} (committer key={}, replicate index={}).", new Object[]{this.consensusPipeName, this.tsFile, this.event.getCommitterKey(), this.event.getReplicateIndexForIoTV2()});
                    if (this.client != null) {
                        this.client.setShouldReturnSelf(true);
                        this.client.returnSelf();
                    }
                    long duration = System.nanoTime() - this.createTime;
                    this.metric.recordConnectorTsFileTransferTimer(duration);
                }
            }
            this.event.decreaseReferenceCount(PipeConsensusTsFileInsertionEventHandler.class.getName(), true);
            LOGGER.info("PipeConsensus-{}: Successfully transferred file {} (committer key={}, replicate index={}).", new Object[]{this.consensusPipeName, this.tsFile, this.event.getCommitterKey(), this.event.getReplicateIndexForIoTV2()});
            if (this.client != null) {
                this.client.setShouldReturnSelf(true);
                this.client.returnSelf();
            }
            long duration = System.nanoTime() - this.createTime;
            this.metric.recordConnectorTsFileTransferTimer(duration);
            return;
        }
        try {
            PipeConsensusTransferFilePieceResp resp = PipeConsensusTransferFilePieceResp.fromTPipeConsensusTransferResp((TPipeConsensusTransferResp)response);
            long code = resp.getStatus().getCode();
            if (code == (long)TSStatusCode.PIPE_CONSENSUS_TRANSFER_FILE_OFFSET_RESET.getStatusCode()) {
                this.position = resp.getEndWritingOffset();
                this.reader.seek(this.position);
                LOGGER.info("PipeConsensus-{}: Redirect file position to {}.", (Object)this.consensusPipeName, (Object)this.position);
            } else {
                TSStatus status = response.getStatus();
                if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode() && status.getCode() != TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) {
                    this.connector.statusHandler().handle(status, response.getStatus().getMessage(), this.tsFile.getName());
                }
            }
            long duration = System.nanoTime() - this.startTransferPieceTime;
            this.metric.recordConnectorTsFilePieceTransferTimer(duration);
            this.transfer(this.client);
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    public void onError(Exception exception) {
        LOGGER.warn("PipeConsensus-{}: Failed to transfer TsFileInsertionEvent {} (committer key {}, replicate index {}).", new Object[]{this.consensusPipeName, this.tsFile, this.event.getCommitterKey(), this.event.getReplicateIndexForIoTV2(), exception});
        if (RetryUtils.needRetryWithIncreasingInterval((Exception)exception)) {
            if (this.event.getRetryInterval() << 1 <= 0L) {
                this.event.setRetryInterval(20000L);
            } else {
                this.event.setRetryInterval(Math.min(20000L, this.event.getRetryInterval() << 1));
            }
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            LOGGER.warn("PipeConsensus-{}: Failed to close file reader when failed to transfer file.", (Object)this.consensusPipeName, (Object)e);
        }
        finally {
            this.connector.addFailureEventToRetryQueue(this.event);
            this.metric.recordRetryCounter();
            if (this.client != null) {
                this.client.setShouldReturnSelf(true);
                this.client.returnSelf();
            }
        }
    }
}

