/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.tsfile.utils.ReadWriteIOUtils;

@Immutable
public class Extract
extends Expression {
    private final Expression expression;
    private final Field field;

    public Extract(Expression expression, Field field) {
        this(null, expression, field);
    }

    public Extract(NodeLocation location, Expression expression, Field field) {
        super(location);
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(field, "field is null");
        this.expression = expression;
        this.field = field;
    }

    public Extract(ByteBuffer byteBuffer) {
        super(null);
        this.expression = Extract.deserialize(byteBuffer);
        this.field = Field.values()[ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer)];
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        Extract.serialize(this.expression, byteBuffer);
        ReadWriteIOUtils.write((int)this.field.ordinal(), (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        Extract.serialize(this.expression, stream);
        ReadWriteIOUtils.write((int)this.field.ordinal(), (OutputStream)stream);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.EXTRACT;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExtract(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.expression);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extract that = (Extract)o;
        return Objects.equals(this.expression, that.expression) && this.field == that.field;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.expression, this.field});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Extract.sameClass(this, other)) {
            return false;
        }
        Extract otherExtract = (Extract)other;
        return this.field.equals((Object)otherExtract.field);
    }

    public static enum Field {
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        DOW,
        DAY_OF_YEAR,
        DOY,
        HOUR,
        MINUTE,
        SECOND,
        MS,
        US,
        NS;

    }
}

