/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.memory;

import java.util.Arrays;
import org.apache.iotdb.commons.memory.MemoryManager;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.db.conf.DataNodeMemoryConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.memory.ConsensusMemoryMetrics;
import org.apache.iotdb.db.service.metrics.memory.OffHeapMemoryMetrics;
import org.apache.iotdb.db.service.metrics.memory.QueryEngineMemoryMetrics;
import org.apache.iotdb.db.service.metrics.memory.SchemaEngineMemoryMetrics;
import org.apache.iotdb.db.service.metrics.memory.StorageEngineMemoryMetrics;
import org.apache.iotdb.db.service.metrics.memory.StreamEngineMemoryMetrics;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class GlobalMemoryMetrics
implements IMetricSet {
    private static final DataNodeMemoryConfig memoryConfig = IoTDBDescriptor.getInstance().getMemoryConfig();
    private static final String TOTAL = "Total";
    public static final String ON_HEAP = "OnHeap";
    public static final String OFF_HEAP = "OffHeap";
    public static final String[] LEVELS = new String[]{"0", "1", "2", "3", "4"};

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getOnHeapMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), TOTAL, Tag.TYPE.toString(), ON_HEAP, Tag.LEVEL.toString(), LEVELS[0]});
        metricService.createAutoGauge(Metric.MEMORY_THRESHOLD_SIZE.toString(), MetricLevel.IMPORTANT, (Object)memoryConfig.getOffHeapMemoryManager(), MemoryManager::getTotalMemorySizeInBytes, new String[]{Tag.NAME.toString(), TOTAL, Tag.TYPE.toString(), OFF_HEAP, Tag.LEVEL.toString(), LEVELS[0]});
        StorageEngineMemoryMetrics.getInstance().bindTo(metricService);
        QueryEngineMemoryMetrics.getInstance().bindTo(metricService);
        SchemaEngineMemoryMetrics.getInstance().bindTo(metricService);
        ConsensusMemoryMetrics.getInstance().bindTo(metricService);
        StreamEngineMemoryMetrics.getInstance().bindTo(metricService);
        OffHeapMemoryMetrics.getInstance().bindTo(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        Arrays.asList(ON_HEAP, OFF_HEAP).forEach(type -> metricService.remove(MetricType.AUTO_GAUGE, Metric.MEMORY_THRESHOLD_SIZE.toString(), new String[]{Tag.NAME.toString(), TOTAL, Tag.TYPE.toString(), type, Tag.LEVEL.toString(), LEVELS[0]}));
        StorageEngineMemoryMetrics.getInstance().unbindFrom(metricService);
        QueryEngineMemoryMetrics.getInstance().unbindFrom(metricService);
        SchemaEngineMemoryMetrics.getInstance().unbindFrom(metricService);
        ConsensusMemoryMetrics.getInstance().unbindFrom(metricService);
        StreamEngineMemoryMetrics.getInstance().unbindFrom(metricService);
        OffHeapMemoryMetrics.getInstance().unbindFrom(metricService);
    }

    public static GlobalMemoryMetrics getInstance() {
        return GlobalMemoryMetricsHolder.INSTANCE;
    }

    private static class GlobalMemoryMetricsHolder {
        private static final GlobalMemoryMetrics INSTANCE = new GlobalMemoryMetrics();

        private GlobalMemoryMetricsHolder() {
        }
    }
}

