/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.james.mailbox.MessageUid;

public class MessageRange
implements Iterable<MessageUid> {
    private final Type type;
    private final MessageUid uidFrom;
    private final MessageUid uidTo;

    public static MessageRange one(MessageUid uid) {
        return new MessageRange(Type.ONE, uid, uid);
    }

    public static MessageRange all() {
        return new MessageRange(Type.ALL, MessageUid.MIN_VALUE, MessageUid.MAX_VALUE);
    }

    public static MessageRange range(MessageUid from, MessageUid to) {
        if (to.equals(MessageUid.MAX_VALUE) || to.compareTo(from) < 0) {
            return MessageRange.from(from);
        }
        if (from.equals(to)) {
            return MessageRange.one(from);
        }
        return new MessageRange(Type.RANGE, from, to);
    }

    public static MessageRange from(MessageUid from) {
        return new MessageRange(Type.FROM, from, MessageUid.MAX_VALUE);
    }

    protected MessageRange(Type type, MessageUid minValue, MessageUid maxValue) {
        this.type = type;
        this.uidFrom = minValue;
        this.uidTo = maxValue;
    }

    public Type getType() {
        return this.type;
    }

    public MessageUid getUidFrom() {
        return this.uidFrom;
    }

    public MessageUid getUidTo() {
        return this.uidTo;
    }

    public boolean includes(MessageUid uid) {
        switch (this.type) {
            case ALL: {
                return true;
            }
            case FROM: {
                return this.getUidFrom().compareTo(uid) <= 0;
            }
            case RANGE: {
                return this.getUidFrom().compareTo(uid) <= 0 && this.getUidTo().compareTo(uid) >= 0;
            }
            case ONE: {
                return this.getUidFrom().equals(uid);
            }
        }
        return false;
    }

    public String toString() {
        return "TYPE: " + this.type + " UID: " + this.uidFrom + ":" + this.uidTo;
    }

    public static List<MessageRange> toRanges(Collection<MessageUid> uidsCol) {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        ArrayList<MessageUid> uids = new ArrayList<MessageUid>(uidsCol);
        Collections.sort(uids);
        long firstUid = 0L;
        int a = 0;
        for (int i = 0; i < uids.size(); ++i) {
            long u = ((MessageUid)uids.get(i)).asLong();
            if (i == 0) {
                firstUid = u;
                if (uids.size() != 1) continue;
                ranges.add(MessageUid.of(firstUid).toRange());
                continue;
            }
            if (firstUid + (long)a + 1L != u) {
                ranges.add(MessageRange.range(MessageUid.of(firstUid), MessageUid.of(firstUid + (long)a)));
                firstUid = u;
                a = 0;
                if (uids.size() > i + 1) continue;
                ranges.add(MessageUid.of(firstUid).toRange());
                continue;
            }
            ++a;
            if (uids.size() > i + 1) continue;
            ranges.add(MessageRange.range(MessageUid.of(firstUid), MessageUid.of(firstUid + (long)a)));
            break;
        }
        return ranges;
    }

    @Override
    public Iterator<MessageUid> iterator() {
        return new RangeIterator(this.getUidFrom(), this.getUidTo());
    }

    public List<MessageRange> split(int maxItems) {
        ArrayList<MessageRange> ranges = new ArrayList<MessageRange>();
        if (this.getType() == Type.RANGE) {
            long to;
            long from = this.getUidFrom().asLong();
            long realTo = to = this.getUidTo().asLong();
            while (from <= realTo) {
                to = Math.min(from + (long)maxItems - 1L, realTo);
                if (from == to) {
                    ranges.add(MessageUid.of(from).toRange());
                } else {
                    ranges.add(MessageRange.range(MessageUid.of(from), MessageUid.of(to)));
                }
                from = to + 1L;
            }
        } else {
            ranges.add(this);
        }
        return ranges;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.uidFrom, this.uidTo});
    }

    public boolean equals(Object obj) {
        if (obj instanceof MessageRange) {
            MessageRange other = (MessageRange)obj;
            return Objects.equal((Object)((Object)this.type), (Object)((Object)other.type)) && Objects.equal((Object)this.uidFrom, (Object)other.uidFrom) && Objects.equal((Object)this.uidTo, (Object)other.uidTo);
        }
        return false;
    }

    private static final class RangeIterator
    implements Iterator<MessageUid> {
        private final long to;
        private long current;

        public RangeIterator(MessageUid from, MessageUid to) {
            this.to = to.asLong();
            this.current = from.asLong();
        }

        @Override
        public boolean hasNext() {
            return this.current <= this.to;
        }

        @Override
        public MessageUid next() {
            if (this.hasNext()) {
                return MessageUid.of(this.current++);
            }
            throw new NoSuchElementException("Max uid of " + this.to + " was reached before");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Read-Only");
        }
    }

    public static enum Type {
        ALL,
        ONE,
        FROM,
        RANGE;

    }
}

