/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundDirectory;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.BinaryDocValuesFieldUpdates;
import org.apache.lucene.index.BufferedUpdatesStream;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesFieldUpdates;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.DocValuesUpdate;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.DocumentsWriterDeleteQueue;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FrozenBufferedUpdates;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFileDeleter;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafMetaData;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.NumericDocValuesFieldUpdates;
import org.apache.lucene.index.OneMergeWrappingMergePolicy;
import org.apache.lucene.index.PendingSoftDeletes;
import org.apache.lucene.index.ReaderPool;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentMerger;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Sorter;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TwoPhaseCommit;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockValidatingDirectoryWrapper;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MergeInfo;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.ThreadInterruptedException;
import org.apache.lucene.util.Version;

public class IndexWriter
implements Closeable,
TwoPhaseCommit,
Accountable,
MergePolicy.MergeContext {
    public static final int MAX_DOCS = 0x7FFFFF7F;
    public static final int MAX_POSITION = 0x7FFFFF7F;
    private static int actualMaxDocs = 0x7FFFFF7F;
    private final boolean enableTestPoints;
    private static final int UNBOUNDED_MAX_MERGE_SEGMENTS = -1;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String SOURCE = "source";
    public static final String SOURCE_MERGE = "merge";
    public static final String SOURCE_FLUSH = "flush";
    public static final String SOURCE_ADDINDEXES_READERS = "addIndexes(CodecReader...)";
    public static final int MAX_TERM_LENGTH = 32766;
    public static final int MAX_STORED_STRING_LENGTH = ArrayUtil.MAX_ARRAY_LENGTH / 3;
    private final AtomicReference<Throwable> tragedy;
    private final Directory directoryOrig;
    private final Directory directory;
    private final AtomicLong changeCount;
    private volatile long lastCommitChangeCount;
    private List<SegmentCommitInfo> rollbackSegments;
    private volatile SegmentInfos pendingCommit;
    private volatile long pendingSeqNo;
    private volatile long pendingCommitChangeCount;
    private Collection<String> filesToCommit;
    private final SegmentInfos segmentInfos;
    final FieldInfos.FieldNumbers globalFieldNumberMap;
    final DocumentsWriter docWriter;
    private final EventQueue eventQueue;
    private final MergeScheduler.MergeSource mergeSource;
    private final ReentrantLock writeDocValuesLock;
    private final IndexFileDeleter deleter;
    private final Map<SegmentCommitInfo, Boolean> segmentsToMerge;
    private int mergeMaxNumSegments;
    private Lock writeLock;
    private volatile boolean closed;
    private volatile boolean closing;
    private final AtomicBoolean maybeMerge;
    private Iterable<Map.Entry<String, String>> commitUserData;
    private final HashSet<SegmentCommitInfo> mergingSegments;
    private final MergeScheduler mergeScheduler;
    private final Set<SegmentMerger> runningAddIndexesMerges;
    private final LinkedList<MergePolicy.OneMerge> pendingMerges;
    private final Set<MergePolicy.OneMerge> runningMerges;
    private final List<MergePolicy.OneMerge> mergeExceptions;
    private long mergeGen;
    private Merges merges;
    private boolean didMessageState;
    private final AtomicInteger flushCount;
    private final AtomicInteger flushDeletesCount;
    private final ReaderPool readerPool;
    private final BufferedUpdatesStream bufferedUpdatesStream;
    private final AtomicLong mergeFinishedGen;
    private final LiveIndexWriterConfig config;
    private long startCommitTime;
    private final AtomicLong pendingNumDocs;
    private final boolean softDeletesEnabled;
    private final DocumentsWriter.FlushNotifications flushNotifications;
    private final InfoStream infoStream;
    private final Object commitLock;
    private final Object fullFlushLock;

    static void setMaxDocs(int maxDocs) {
        if (maxDocs > 0x7FFFFF7F) {
            throw new IllegalArgumentException("maxDocs must be <= IndexWriter.MAX_DOCS=2147483519; got: " + maxDocs);
        }
        actualMaxDocs = maxDocs;
    }

    static int getActualMaxDocs() {
        return actualMaxDocs;
    }

    DirectoryReader getReader() throws IOException {
        return this.getReader(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    DirectoryReader getReader(boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        StandardDirectoryReader r;
        block40: {
            boolean success2;
            Closeable onGetReaderMergeResources;
            block39: {
                StandardDirectoryReader mergedReader;
                this.ensureOpen();
                if (writeAllDeletes && !applyAllDeletes) {
                    throw new IllegalArgumentException("applyAllDeletes must be true when writeAllDeletes=true");
                }
                long tStart = System.currentTimeMillis();
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "flush at getReader");
                }
                this.readerPool.enableReaderPooling();
                r = null;
                this.doBeforeFlush();
                long maxFullFlushMergeWaitMillis = this.config.getMaxFullFlushMergeWaitMillis();
                MergePolicy.MergeSpecification onGetReaderMerges = null;
                AtomicBoolean stopCollectingMergedReaders = new AtomicBoolean(false);
                HashMap<String, SegmentReader> mergedReaders = new HashMap<String, SegmentReader>();
                HashMap<String, SegmentReader> openedReadOnlyClones = new HashMap<String, SegmentReader>();
                IOUtils.IOFunction<SegmentCommitInfo, SegmentReader> readerFactory = sci -> {
                    ReadersAndUpdates rld = this.getPooledInstance((SegmentCommitInfo)sci, true);
                    try {
                        assert (Thread.holdsLock(this));
                        SegmentReader segmentReader = rld.getReadOnlyClone(IOContext.READ);
                        if (maxFullFlushMergeWaitMillis > 0L) {
                            openedReadOnlyClones.put(sci.info.name, segmentReader);
                        }
                        SegmentReader segmentReader2 = segmentReader;
                        return segmentReader2;
                    }
                    finally {
                        this.release(rld);
                    }
                };
                onGetReaderMergeResources = null;
                SegmentInfos openingSegmentInfos = null;
                success2 = false;
                boolean success = false;
                Object object = this.fullFlushLock;
                synchronized (object) {
                    try {
                        boolean anyChanges;
                        boolean bl = anyChanges = this.docWriter.flushAllThreads() < 0L;
                        if (!anyChanges) {
                            this.flushCount.incrementAndGet();
                        }
                        this.publishFlushedSegments(true);
                        this.processEvents(false);
                        if (applyAllDeletes) {
                            this.applyAllDeletesAndUpdates();
                        }
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            this.writeReaderPool(writeAllDeletes);
                            r = StandardDirectoryReader.open(this, readerFactory, this.segmentInfos, applyAllDeletes, writeAllDeletes);
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "return reader version=" + r.getVersion() + " reader=" + r);
                            }
                            if (maxFullFlushMergeWaitMillis > 0L) {
                                openingSegmentInfos = r.getSegmentInfos().clone();
                                onGetReaderMerges = this.preparePointInTimeMerge(openingSegmentInfos, stopCollectingMergedReaders::get, MergeTrigger.GET_READER, sci -> {
                                    assert (!stopCollectingMergedReaders.get()) : "illegal state  merge reader must be not pulled since we already stopped waiting for merges";
                                    SegmentReader apply = (SegmentReader)readerFactory.apply((SegmentCommitInfo)sci);
                                    mergedReaders.put(sci.info.name, apply);
                                    this.deleter.incRef(sci.files());
                                });
                                onGetReaderMergeResources = () -> {
                                    IndexWriter indexWriter = this;
                                    synchronized (indexWriter) {
                                        stopCollectingMergedReaders.set(true);
                                        IOUtils.close(mergedReaders.values().stream().map(sr -> () -> {
                                            try {
                                                this.deleter.decRef(sr.getSegmentInfo().files());
                                            }
                                            finally {
                                                sr.close();
                                            }
                                        }).collect(Collectors.toList()));
                                    }
                                };
                            }
                        }
                        success = true;
                    }
                    finally {
                        assert (Thread.holdsLock(this.fullFlushLock));
                        this.docWriter.finishFullFlush(success);
                        if (success) {
                            this.processEvents(false);
                            this.doAfterFlush();
                        } else if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during NRT reader");
                        }
                    }
                }
                if (onGetReaderMerges != null && (mergedReader = this.finishGetReaderMerge(stopCollectingMergedReaders, mergedReaders, openedReadOnlyClones, openingSegmentInfos, applyAllDeletes, writeAllDeletes, onGetReaderMerges, maxFullFlushMergeWaitMillis)) != null) {
                    try {
                        r.close();
                    }
                    finally {
                        r = mergedReader;
                    }
                }
                if (anyChanges |= this.maybeMerge.getAndSet(false)) {
                    this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "getReader took " + (System.currentTimeMillis() - tStart) + " msec");
                }
                if (success2 = true) break block39;
                try {
                    IOUtils.closeWhileHandlingException(r, onGetReaderMergeResources);
                }
                finally {
                    this.maybeCloseOnTragicEvent();
                }
            }
            IOUtils.close(onGetReaderMergeResources);
            break block40;
            catch (VirtualMachineError tragedy) {
                try {
                    this.tragicEvent(tragedy, "getReader");
                    throw tragedy;
                }
                catch (Throwable throwable) {
                    if (!success2) {
                        try {
                            IOUtils.closeWhileHandlingException(r, onGetReaderMergeResources);
                        }
                        finally {
                            this.maybeCloseOnTragicEvent();
                        }
                    } else {
                        IOUtils.close(onGetReaderMergeResources);
                    }
                    throw throwable;
                }
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardDirectoryReader finishGetReaderMerge(AtomicBoolean stopCollectingMergedReaders, Map<String, SegmentReader> mergedReaders, Map<String, SegmentReader> openedReadOnlyClones, SegmentInfos openingSegmentInfos, boolean applyAllDeletes, boolean writeAllDeletes, MergePolicy.MergeSpecification pointInTimeMerges, long maxCommitMergeWaitMillis) throws IOException {
        assert (openingSegmentInfos != null);
        this.mergeScheduler.merge(this.mergeSource, MergeTrigger.GET_READER);
        pointInTimeMerges.await(maxCommitMergeWaitMillis, TimeUnit.MILLISECONDS);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            stopCollectingMergedReaders.set(true);
            StandardDirectoryReader reader = this.maybeReopenMergedNRTReader(mergedReaders, openedReadOnlyClones, openingSegmentInfos, applyAllDeletes, writeAllDeletes);
            IOUtils.close(mergedReaders.values());
            mergedReaders.clear();
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StandardDirectoryReader maybeReopenMergedNRTReader(Map<String, SegmentReader> mergedReaders, Map<String, SegmentReader> openedReadOnlyClones, SegmentInfos openingSegmentInfos, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        assert (Thread.holdsLock(this));
        if (!mergedReaders.isEmpty()) {
            ArrayList<String> files = new ArrayList<String>();
            try {
                StandardDirectoryReader standardDirectoryReader = StandardDirectoryReader.open(this, sci -> {
                    SegmentReader remove = (SegmentReader)mergedReaders.remove(sci.info.name);
                    if (remove == null) {
                        remove = (SegmentReader)openedReadOnlyClones.remove(sci.info.name);
                        assert (remove != null);
                        remove.incRef();
                    } else {
                        files.addAll(remove.getSegmentInfo().files());
                    }
                    return remove;
                }, openingSegmentInfos, applyAllDeletes, writeAllDeletes);
                return standardDirectoryReader;
            }
            finally {
                this.deleter.decRef(files);
            }
        }
        return null;
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.docWriter.ramBytesUsed();
    }

    public final long getFlushingBytes() {
        this.ensureOpen();
        return this.docWriter.getFlushingBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeSomeDocValuesUpdates() throws IOException {
        block12: {
            if (this.writeDocValuesLock.tryLock()) {
                try {
                    double ramBufferSizeMB = this.config.getRAMBufferSizeMB();
                    if (ramBufferSizeMB == -1.0) break block12;
                    long startNS = System.nanoTime();
                    long ramBytesUsed = this.readerPool.ramBytesUsed();
                    if (!((double)ramBytesUsed > 0.5 * ramBufferSizeMB * 1024.0 * 1024.0)) break block12;
                    if (this.infoStream.isEnabled("BD")) {
                        this.infoStream.message("BD", String.format(Locale.ROOT, "now write some pending DV updates: %.2f MB used vs IWC Buffer %.2f MB", (double)ramBytesUsed / 1024.0 / 1024.0, ramBufferSizeMB));
                    }
                    List<ReadersAndUpdates> list = this.readerPool.getReadersByRam();
                    int count = 0;
                    for (ReadersAndUpdates rld : list) {
                        if ((double)ramBytesUsed <= 0.5 * ramBufferSizeMB * 1024.0 * 1024.0) break;
                        long bytesUsedBefore = rld.ramBytesUsed.get();
                        if (bytesUsedBefore == 0L) continue;
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            if (this.readerPool.get(rld.info, false) == null) {
                                continue;
                            }
                            if (rld.writeFieldUpdates(this.directory, this.globalFieldNumberMap, this.bufferedUpdatesStream.getCompletedDelGen(), this.infoStream)) {
                                this.checkpointNoSIS();
                            }
                        }
                        long bytesUsedAfter = rld.ramBytesUsed.get();
                        ramBytesUsed -= bytesUsedBefore - bytesUsedAfter;
                        ++count;
                    }
                    if (this.infoStream.isEnabled("BD")) {
                        this.infoStream.message("BD", String.format(Locale.ROOT, "done write some DV updates for %d segments: now %.2f MB used vs IWC Buffer %.2f MB; took %.2f sec", count, (double)this.readerPool.ramBytesUsed() / 1024.0 / 1024.0, ramBufferSizeMB, (double)(System.nanoTime() - startNS) / 1.0E9));
                    }
                }
                finally {
                    this.writeDocValuesLock.unlock();
                }
            }
        }
    }

    @Override
    public int numDeletedDocs(SegmentCommitInfo info) {
        this.ensureOpen(false);
        this.validate(info);
        ReadersAndUpdates rld = this.getPooledInstance(info, false);
        if (rld != null) {
            return rld.getDelCount();
        }
        int delCount = info.getDelCount(this.softDeletesEnabled);
        assert (delCount <= info.info.maxDoc()) : "delCount: " + delCount + " maxDoc: " + info.info.maxDoc();
        return delCount;
    }

    protected final void ensureOpen(boolean failIfClosing) throws AlreadyClosedException {
        if (this.closed || failIfClosing && this.closing) {
            throw new AlreadyClosedException("this IndexWriter is closed", this.tragedy.get());
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        this.ensureOpen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexWriter(Directory d, IndexWriterConfig conf) throws IOException {
        block34: {
            block35: {
                this.tragedy = new AtomicReference<Object>(null);
                this.changeCount = new AtomicLong();
                this.eventQueue = new EventQueue(this);
                this.mergeSource = new IndexWriterMergeSource(this);
                this.writeDocValuesLock = new ReentrantLock();
                this.segmentsToMerge = new HashMap<SegmentCommitInfo, Boolean>();
                this.maybeMerge = new AtomicBoolean();
                this.mergingSegments = new HashSet();
                this.runningAddIndexesMerges = new HashSet<SegmentMerger>();
                this.pendingMerges = new LinkedList();
                this.runningMerges = new HashSet<MergePolicy.OneMerge>();
                this.mergeExceptions = new ArrayList<MergePolicy.OneMerge>();
                this.merges = new Merges();
                this.flushCount = new AtomicInteger();
                this.flushDeletesCount = new AtomicInteger();
                this.mergeFinishedGen = new AtomicLong();
                this.pendingNumDocs = new AtomicLong();
                this.flushNotifications = new DocumentsWriter.FlushNotifications(){

                    @Override
                    public void deleteUnusedFiles(Collection<String> files) {
                        IndexWriter.this.eventQueue.add(w -> w.deleteNewFiles(files));
                    }

                    @Override
                    public void flushFailed(SegmentInfo info) {
                        IndexWriter.this.eventQueue.add(w -> w.flushFailed(info));
                    }

                    @Override
                    public void afterSegmentsFlushed() throws IOException {
                        IndexWriter.this.publishFlushedSegments(false);
                    }

                    @Override
                    public void onTragicEvent(Throwable event, String message) {
                        IndexWriter.this.onTragicEvent(event, message);
                    }

                    @Override
                    public void onDeletesApplied() {
                        IndexWriter.this.eventQueue.add(w -> {
                            try {
                                w.publishFlushedSegments(true);
                            }
                            finally {
                                IndexWriter.this.flushCount.incrementAndGet();
                            }
                        });
                    }

                    @Override
                    public void onTicketBacklog() {
                        IndexWriter.this.eventQueue.add(w -> w.publishFlushedSegments(true));
                    }
                };
                this.commitLock = new Object();
                this.fullFlushLock = new Object();
                this.enableTestPoints = this.isEnableTestPoints();
                conf.setIndexWriter(this);
                this.config = conf;
                this.infoStream = this.config.getInfoStream();
                this.softDeletesEnabled = this.config.getSoftDeletesField() != null;
                this.writeLock = d.obtainLock(WRITE_LOCK_NAME);
                boolean success = false;
                try {
                    boolean create;
                    boolean indexExists;
                    this.directoryOrig = d;
                    this.directory = new LockValidatingDirectoryWrapper(d, this.writeLock);
                    this.mergeScheduler = this.config.getMergeScheduler();
                    this.mergeScheduler.initialize(this.infoStream, this.directoryOrig);
                    IndexWriterConfig.OpenMode mode = this.config.getOpenMode();
                    if (mode == IndexWriterConfig.OpenMode.CREATE) {
                        indexExists = DirectoryReader.indexExists(this.directory);
                        create = true;
                    } else if (mode == IndexWriterConfig.OpenMode.APPEND) {
                        indexExists = true;
                        create = false;
                    } else {
                        indexExists = DirectoryReader.indexExists(this.directory);
                        create = !indexExists;
                    }
                    Object[] files = this.directory.listAll();
                    IndexCommit commit = this.config.getIndexCommit();
                    StandardDirectoryReader reader = commit == null ? null : commit.getReader();
                    if (create) {
                        if (this.config.getIndexCommit() != null) {
                            if (mode == IndexWriterConfig.OpenMode.CREATE) {
                                throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() with OpenMode.CREATE");
                            }
                            throw new IllegalArgumentException("cannot use IndexWriterConfig.setIndexCommit() when index has no commit");
                        }
                        SegmentInfos sis = new SegmentInfos(this.config.getIndexCreatedVersionMajor());
                        if (indexExists) {
                            SegmentInfos previous = SegmentInfos.readLatestCommit(this.directory);
                            sis.updateGenerationVersionAndCounter(previous);
                        }
                        this.segmentInfos = sis;
                        this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                        this.changed();
                    } else if (reader != null) {
                        SegmentInfos lastCommit;
                        if (reader.directory() != commit.getDirectory()) {
                            throw new IllegalArgumentException("IndexCommit's reader must have the same directory as the IndexCommit");
                        }
                        if (reader.directory() != this.directoryOrig) {
                            throw new IllegalArgumentException("IndexCommit's reader must have the same directory passed to IndexWriter");
                        }
                        if (reader.segmentInfos.getLastGeneration() == 0L) {
                            throw new IllegalArgumentException("index must already have an initial commit to open from reader");
                        }
                        this.segmentInfos = reader.segmentInfos.clone();
                        try {
                            lastCommit = SegmentInfos.readCommit(this.directoryOrig, this.segmentInfos.getSegmentsFileName());
                        }
                        catch (IOException ioe) {
                            throw new IllegalArgumentException("the provided reader is stale: its prior commit file \"" + this.segmentInfos.getSegmentsFileName() + "\" is missing from index");
                        }
                        if (reader.writer != null) {
                            assert (reader.writer.closed);
                            this.segmentInfos.updateGenerationVersionAndCounter(reader.writer.segmentInfos);
                            lastCommit.updateGenerationVersionAndCounter(reader.writer.segmentInfos);
                        }
                        this.rollbackSegments = lastCommit.createBackupSegmentInfos();
                    } else {
                        String lastSegmentsFile = SegmentInfos.getLastCommitSegmentsFileName((String[])files);
                        if (lastSegmentsFile == null) {
                            throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                        }
                        this.segmentInfos = SegmentInfos.readCommit(this.directoryOrig, lastSegmentsFile);
                        if (commit != null) {
                            if (commit.getDirectory() != this.directoryOrig) {
                                throw new IllegalArgumentException("IndexCommit's directory doesn't match my directory, expected=" + this.directoryOrig + ", got=" + commit.getDirectory());
                            }
                            SegmentInfos oldInfos = SegmentInfos.readCommit(this.directoryOrig, commit.getSegmentsFileName());
                            this.segmentInfos.replace(oldInfos);
                            this.changed();
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "init: loaded commit \"" + commit.getSegmentsFileName() + "\"");
                            }
                        }
                        this.rollbackSegments = this.segmentInfos.createBackupSegmentInfos();
                    }
                    this.commitUserData = new HashMap<String, String>(this.segmentInfos.getUserData()).entrySet();
                    this.pendingNumDocs.set(this.segmentInfos.totalMaxDoc());
                    this.globalFieldNumberMap = this.getFieldNumberMap();
                    this.validateIndexSort();
                    this.config.getFlushPolicy().init(this.config);
                    this.bufferedUpdatesStream = new BufferedUpdatesStream(this.infoStream);
                    this.docWriter = new DocumentsWriter(this.flushNotifications, this.segmentInfos.getIndexCreatedVersionMajor(), this.pendingNumDocs, this.enableTestPoints, this::newSegmentName, this.config, this.directoryOrig, this.directory, this.globalFieldNumberMap);
                    this.readerPool = new ReaderPool(this.directory, this.directoryOrig, this.segmentInfos, this.globalFieldNumberMap, this.bufferedUpdatesStream::getCompletedDelGen, this.infoStream, conf.getSoftDeletesField(), reader);
                    if (this.config.getReaderPooling()) {
                        this.readerPool.enableReaderPooling();
                    }
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        this.deleter = new IndexFileDeleter((String[])files, this.directoryOrig, this.directory, this.config.getIndexDeletionPolicy(), this.segmentInfos, this.infoStream, this, indexExists, reader != null);
                        assert (create || this.filesExist(this.segmentInfos));
                    }
                    if (this.deleter.startingCommitDeleted) {
                        this.changed();
                    }
                    if (reader != null) {
                        this.segmentInfos.changed();
                        this.changed();
                    }
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "init: create=" + create + " reader=" + reader);
                        this.messageState();
                    }
                    if (success = true) break block34;
                    if (!this.infoStream.isEnabled("IW")) break block35;
                    this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                }
                catch (Throwable throwable) {
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "init: hit exception on init; releasing write lock");
                        }
                        IOUtils.closeWhileHandlingException(this.writeLock);
                        this.writeLock = null;
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(this.writeLock);
            this.writeLock = null;
        }
    }

    private void validateIndexSort() {
        Sort indexSort = this.config.getIndexSort();
        if (indexSort != null) {
            for (SegmentCommitInfo info : this.segmentInfos) {
                Sort segmentIndexSort = info.info.getIndexSort();
                if (segmentIndexSort != null && IndexWriter.isCongruentSort(indexSort, segmentIndexSort)) continue;
                throw new IllegalArgumentException("cannot change previous indexSort=" + segmentIndexSort + " (from segment=" + info + ") to new indexSort=" + indexSort);
            }
        }
    }

    static boolean isCongruentSort(Sort indexSort, Sort otherSort) {
        SortField[] fields2;
        SortField[] fields1 = indexSort.getSort();
        if (fields1.length > (fields2 = otherSort.getSort()).length) {
            return false;
        }
        return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
    }

    static FieldInfos readFieldInfos(SegmentCommitInfo si) throws IOException {
        Codec codec = si.info.getCodec();
        FieldInfosFormat reader = codec.fieldInfosFormat();
        if (si.hasFieldUpdates()) {
            String segmentSuffix = Long.toString(si.getFieldInfosGen(), 36);
            return reader.read(si.info.dir, si.info, segmentSuffix, IOContext.READONCE);
        }
        if (si.info.getUseCompoundFile()) {
            try (CompoundDirectory cfs = codec.compoundFormat().getCompoundReader(si.info.dir, si.info, IOContext.DEFAULT);){
                FieldInfos fieldInfos = reader.read(cfs, si.info, "", IOContext.READONCE);
                return fieldInfos;
            }
        }
        return reader.read(si.info.dir, si.info, "", IOContext.READONCE);
    }

    private FieldInfos.FieldNumbers getFieldNumberMap() throws IOException {
        FieldInfos.FieldNumbers map = new FieldInfos.FieldNumbers(this.config.softDeletesField);
        for (SegmentCommitInfo info : this.segmentInfos) {
            FieldInfos fis = IndexWriter.readFieldInfos(info);
            for (FieldInfo fi : fis) {
                map.addOrGet(fi.name, fi.number, fi.getIndexOptions(), fi.getDocValuesType(), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.isSoftDeletesField());
            }
        }
        return map;
    }

    public LiveIndexWriterConfig getConfig() {
        this.ensureOpen(false);
        return this.config;
    }

    private void messageState() {
        if (this.infoStream.isEnabled("IW") && !this.didMessageState) {
            this.didMessageState = true;
            this.infoStream.message("IW", "\ndir=" + this.directoryOrig + "\nindex=" + this.segString() + "\nversion=" + Version.LATEST.toString() + "\n" + this.config.toString());
            StringBuilder unmapInfo = new StringBuilder(Boolean.toString(MMapDirectory.UNMAP_SUPPORTED));
            if (!MMapDirectory.UNMAP_SUPPORTED) {
                unmapInfo.append(" (").append(MMapDirectory.UNMAP_NOT_SUPPORTED_REASON).append(")");
            }
            this.infoStream.message("IW", "MMapDirectory.UNMAP_SUPPORTED=" + unmapInfo);
        }
    }

    private void shutdown() throws IOException {
        if (this.pendingCommit != null) {
            throw new IllegalStateException("cannot close: prepareCommit was already called with no corresponding call to commit");
        }
        if (this.shouldClose(true)) {
            try {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now flush at close");
                }
                this.flush(true, true);
                this.waitForMerges();
                this.commitInternal(this.config.getMergePolicy());
            }
            finally {
                this.rollbackInternal();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.config.getCommitOnClose()) {
            this.shutdown();
        } else {
            this.rollback();
        }
    }

    private synchronized boolean shouldClose(boolean waitForClose) {
        while (!this.closed) {
            if (!this.closing) {
                this.closing = true;
                return true;
            }
            if (!waitForClose) {
                return false;
            }
            this.doWait();
        }
        return false;
    }

    public Directory getDirectory() {
        return this.directoryOrig;
    }

    @Override
    public InfoStream getInfoStream() {
        return this.infoStream;
    }

    public Analyzer getAnalyzer() {
        this.ensureOpen();
        return this.config.getAnalyzer();
    }

    public synchronized void advanceSegmentInfosVersion(long newVersion) {
        this.ensureOpen();
        if (this.segmentInfos.getVersion() < newVersion) {
            this.segmentInfos.setVersion(newVersion);
        }
        this.changed();
    }

    public synchronized boolean hasDeletions() {
        this.ensureOpen();
        if (this.bufferedUpdatesStream.any() || this.docWriter.anyDeletions() || this.readerPool.anyDeletions()) {
            return true;
        }
        for (SegmentCommitInfo info : this.segmentInfos) {
            if (!info.hasDeletions()) continue;
            return true;
        }
        return false;
    }

    public long addDocument(Iterable<? extends IndexableField> doc) throws IOException {
        return this.updateDocument(null, doc);
    }

    public long addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.updateDocuments((DocumentsWriterDeleteQueue.Node)null, docs);
    }

    public long updateDocuments(Term delTerm, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.updateDocuments(delTerm == null ? null : DocumentsWriterDeleteQueue.newNode(delTerm), docs);
    }

    private long updateDocuments(DocumentsWriterDeleteQueue.Node<?> delNode, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        this.ensureOpen();
        boolean success = false;
        try {
            long seqNo = this.maybeProcessEvents(this.docWriter.updateDocuments(docs, delNode));
            success = true;
            long l = seqNo;
            return l;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateDocuments");
            throw tragedy;
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception updating document");
                }
                this.maybeCloseOnTragicEvent();
            }
        }
    }

    public long softUpdateDocuments(Term term, Iterable<? extends Iterable<? extends IndexableField>> docs, Field ... softDeletes) throws IOException {
        if (term == null) {
            throw new IllegalArgumentException("term must not be null");
        }
        if (softDeletes == null || softDeletes.length == 0) {
            throw new IllegalArgumentException("at least one soft delete must be present");
        }
        return this.updateDocuments(DocumentsWriterDeleteQueue.newNode(this.buildDocValuesUpdate(term, softDeletes)), docs);
    }

    public synchronized long tryDeleteDocument(IndexReader readerIn, int docID) throws IOException {
        return this.tryModifyDocument(readerIn, docID, (leafDocId, rld) -> {
            if (rld.delete(leafDocId)) {
                if (this.isFullyDeleted(rld)) {
                    this.dropDeletedSegment(rld.info);
                    this.checkpoint();
                }
                this.changed();
            }
        });
    }

    public synchronized long tryUpdateDocValue(IndexReader readerIn, int docID, Field ... fields) throws IOException {
        DocValuesUpdate[] dvUpdates = this.buildDocValuesUpdate(null, fields);
        return this.tryModifyDocument(readerIn, docID, (leafDocId, rld) -> {
            long nextGen = this.bufferedUpdatesStream.getNextGen();
            try {
                HashMap<String, DocValuesFieldUpdates> fieldUpdatesMap = new HashMap<String, DocValuesFieldUpdates>();
                block7: for (DocValuesUpdate update : dvUpdates) {
                    DocValuesFieldUpdates docValuesFieldUpdates = fieldUpdatesMap.computeIfAbsent(update.field, k -> {
                        switch (update.type) {
                            case NUMERIC: {
                                return new NumericDocValuesFieldUpdates(nextGen, (String)k, rld.info.info.maxDoc());
                            }
                            case BINARY: {
                                return new BinaryDocValuesFieldUpdates(nextGen, (String)k, rld.info.info.maxDoc());
                            }
                        }
                        throw new AssertionError((Object)("type: " + (Object)((Object)update.type) + " is not supported"));
                    });
                    if (update.hasValue()) {
                        switch (update.type) {
                            case NUMERIC: {
                                docValuesFieldUpdates.add(leafDocId, ((DocValuesUpdate.NumericDocValuesUpdate)update).getValue());
                                continue block7;
                            }
                            case BINARY: {
                                docValuesFieldUpdates.add(leafDocId, ((DocValuesUpdate.BinaryDocValuesUpdate)update).getValue());
                                continue block7;
                            }
                            default: {
                                throw new AssertionError((Object)("type: " + (Object)((Object)update.type) + " is not supported"));
                            }
                        }
                    }
                    docValuesFieldUpdates.reset(leafDocId);
                }
                for (DocValuesFieldUpdates updates : fieldUpdatesMap.values()) {
                    updates.finish();
                    rld.addDVUpdate(updates);
                }
            }
            finally {
                this.bufferedUpdatesStream.finishedSegment(nextGen);
            }
            this.changed();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long tryModifyDocument(IndexReader readerIn, int docID, DocModifier toApply) throws IOException {
        ReadersAndUpdates rld;
        LeafReader reader;
        if (readerIn instanceof LeafReader) {
            reader = (LeafReader)readerIn;
        } else {
            List<LeafReaderContext> leaves = readerIn.leaves();
            int subIndex = ReaderUtil.subIndex(docID, leaves);
            reader = leaves.get(subIndex).reader();
            assert ((docID -= leaves.get((int)subIndex).docBase) >= 0);
            assert (docID < reader.maxDoc());
        }
        if (!(reader instanceof SegmentReader)) {
            throw new IllegalArgumentException("the reader must be a SegmentReader or composite reader containing only SegmentReaders");
        }
        SegmentCommitInfo info = ((SegmentReader)reader).getOriginalSegmentInfo();
        if (this.segmentInfos.indexOf(info) != -1 && (rld = this.getPooledInstance(info, false)) != null) {
            BufferedUpdatesStream bufferedUpdatesStream = this.bufferedUpdatesStream;
            synchronized (bufferedUpdatesStream) {
                toApply.run(docID, rld);
                return this.docWriter.getNextSequenceNumber();
            }
        }
        return -1L;
    }

    private synchronized void dropDeletedSegment(SegmentCommitInfo info) throws IOException {
        if (!this.mergingSegments.contains(info)) {
            boolean dropPendingDocs = this.segmentInfos.remove(info);
            try {
                dropPendingDocs |= this.readerPool.drop(info);
            }
            finally {
                if (dropPendingDocs) {
                    this.adjustPendingNumDocs(-info.info.maxDoc());
                }
            }
        }
    }

    public long deleteDocuments(Term ... terms) throws IOException {
        this.ensureOpen();
        try {
            return this.maybeProcessEvents(this.docWriter.deleteTerms(terms));
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteDocuments(Term..)");
            throw tragedy;
        }
    }

    public long deleteDocuments(Query ... queries) throws IOException {
        this.ensureOpen();
        for (Query query : queries) {
            if (query.getClass() != MatchAllDocsQuery.class) continue;
            return this.deleteAll();
        }
        try {
            return this.maybeProcessEvents(this.docWriter.deleteQueries(queries));
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteDocuments(Query..)");
            throw tragedy;
        }
    }

    public long updateDocument(Term term, Iterable<? extends IndexableField> doc) throws IOException {
        return this.updateDocuments(term == null ? null : DocumentsWriterDeleteQueue.newNode(term), Collections.singletonList(doc));
    }

    public long softUpdateDocument(Term term, Iterable<? extends IndexableField> doc, Field ... softDeletes) throws IOException {
        if (term == null) {
            throw new IllegalArgumentException("term must not be null");
        }
        if (softDeletes == null || softDeletes.length == 0) {
            throw new IllegalArgumentException("at least one soft delete must be present");
        }
        return this.updateDocuments(DocumentsWriterDeleteQueue.newNode(this.buildDocValuesUpdate(term, softDeletes)), Collections.singletonList(doc));
    }

    public long updateNumericDocValue(Term term, String field, long value) throws IOException {
        this.ensureOpen();
        if (!this.globalFieldNumberMap.contains(field, DocValuesType.NUMERIC)) {
            throw new IllegalArgumentException("can only update existing numeric-docvalues fields!");
        }
        if (this.config.getIndexSortFields().contains(field)) {
            throw new IllegalArgumentException("cannot update docvalues field involved in the index sort, field=" + field + ", sort=" + this.config.getIndexSort());
        }
        try {
            return this.maybeProcessEvents(this.docWriter.updateDocValues(new DocValuesUpdate.NumericDocValuesUpdate(term, field, value)));
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateNumericDocValue");
            throw tragedy;
        }
    }

    public long updateBinaryDocValue(Term term, String field, BytesRef value) throws IOException {
        this.ensureOpen();
        if (value == null) {
            throw new IllegalArgumentException("cannot update a field to a null value: " + field);
        }
        if (!this.globalFieldNumberMap.contains(field, DocValuesType.BINARY)) {
            throw new IllegalArgumentException("can only update existing binary-docvalues fields!");
        }
        try {
            return this.maybeProcessEvents(this.docWriter.updateDocValues(new DocValuesUpdate.BinaryDocValuesUpdate(term, field, value)));
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateBinaryDocValue");
            throw tragedy;
        }
    }

    public long updateDocValues(Term term, Field ... updates) throws IOException {
        this.ensureOpen();
        DocValuesUpdate[] dvUpdates = this.buildDocValuesUpdate(term, updates);
        try {
            return this.maybeProcessEvents(this.docWriter.updateDocValues(dvUpdates));
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "updateDocValues");
            throw tragedy;
        }
    }

    private DocValuesUpdate[] buildDocValuesUpdate(Term term, Field[] updates) {
        DocValuesUpdate[] dvUpdates = new DocValuesUpdate[updates.length];
        block4: for (int i = 0; i < updates.length; ++i) {
            Field f = updates[i];
            DocValuesType dvType = f.fieldType().docValuesType();
            if (dvType == null) {
                throw new NullPointerException("DocValuesType must not be null (field: \"" + f.name() + "\")");
            }
            if (dvType == DocValuesType.NONE) {
                throw new IllegalArgumentException("can only update NUMERIC or BINARY fields! field=" + f.name());
            }
            if (!this.globalFieldNumberMap.contains(f.name(), dvType)) {
                this.globalFieldNumberMap.addOrGet(f.name(), -1, IndexOptions.NONE, dvType, 0, 0, 0, f.name().equals(this.config.softDeletesField));
                assert (this.globalFieldNumberMap.contains(f.name(), dvType));
            }
            if (this.config.getIndexSortFields().contains(f.name())) {
                throw new IllegalArgumentException("cannot update docvalues field involved in the index sort, field=" + f.name() + ", sort=" + this.config.getIndexSort());
            }
            switch (dvType) {
                case NUMERIC: {
                    Long value = (Long)f.numericValue();
                    dvUpdates[i] = new DocValuesUpdate.NumericDocValuesUpdate(term, f.name(), value);
                    continue block4;
                }
                case BINARY: {
                    dvUpdates[i] = new DocValuesUpdate.BinaryDocValuesUpdate(term, f.name(), f.binaryValue());
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("can only update NUMERIC or BINARY fields: field=" + f.name() + ", type=" + (Object)((Object)dvType));
                }
            }
        }
        return dvUpdates;
    }

    final synchronized int getSegmentCount() {
        return this.segmentInfos.size();
    }

    final synchronized int getNumBufferedDocuments() {
        return this.docWriter.getNumDocs();
    }

    final synchronized int maxDoc(int i) {
        if (i >= 0 && i < this.segmentInfos.size()) {
            return this.segmentInfos.info((int)i).info.maxDoc();
        }
        return -1;
    }

    final int getFlushCount() {
        return this.flushCount.get();
    }

    final int getFlushDeletesCount() {
        return this.flushDeletesCount.get();
    }

    @Deprecated
    public Set<String> getFieldNames() {
        return this.globalFieldNumberMap.getFieldNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String newSegmentName() {
        SegmentInfos segmentInfos = this.segmentInfos;
        synchronized (segmentInfos) {
            this.changeCount.incrementAndGet();
            this.segmentInfos.changed();
            return "_" + Long.toString(this.segmentInfos.counter++, 36);
        }
    }

    public void forceMerge(int maxNumSegments) throws IOException {
        this.forceMerge(maxNumSegments, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMerge(int maxNumSegments, boolean doWait) throws IOException {
        this.ensureOpen();
        if (maxNumSegments < 1) {
            throw new IllegalArgumentException("maxNumSegments must be >= 1; got " + maxNumSegments);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMerge: index now " + this.segString());
            this.infoStream.message("IW", "now flush at forceMerge");
        }
        this.flush(true, true);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.resetMergeExceptions();
            this.segmentsToMerge.clear();
            for (SegmentCommitInfo info : this.segmentInfos) {
                assert (info != null);
                this.segmentsToMerge.put(info, Boolean.TRUE);
            }
            this.mergeMaxNumSegments = maxNumSegments;
            for (MergePolicy.OneMerge merge : this.pendingMerges) {
                merge.maxNumSegments = maxNumSegments;
                if (merge.info == null) continue;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
            for (MergePolicy.OneMerge merge : this.runningMerges) {
                merge.maxNumSegments = maxNumSegments;
                if (merge.info == null) continue;
                this.segmentsToMerge.put(merge.info, Boolean.TRUE);
            }
        }
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, maxNumSegments);
        if (doWait) {
            indexWriter = this;
            synchronized (indexWriter) {
                while (true) {
                    if (this.tragedy.get() != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMerge", this.tragedy.get());
                    }
                    if (this.mergeExceptions.size() > 0) {
                        int size = this.mergeExceptions.size();
                        for (int i = 0; i < size; ++i) {
                            MergePolicy.OneMerge merge = this.mergeExceptions.get(i);
                            if (merge.maxNumSegments == -1) continue;
                            throw new IOException("background merge hit exception: " + merge.segString(), merge.getException());
                        }
                    }
                    if (!this.maxNumSegmentsMergesPending()) break;
                    this.testPoint("forceMergeBeforeWait");
                    this.doWait();
                }
            }
            this.ensureOpen();
        }
    }

    private synchronized boolean maxNumSegmentsMergesPending() {
        for (MergePolicy.OneMerge merge : this.pendingMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        for (MergePolicy.OneMerge merge : this.runningMerges) {
            if (merge.maxNumSegments == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceMergeDeletes(boolean doWait) throws IOException {
        MergePolicy.MergeSpecification spec;
        this.ensureOpen();
        this.flush(true, true);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "forceMergeDeletes: index now " + this.segString());
        }
        MergePolicy mergePolicy = this.config.getMergePolicy();
        boolean newMergesFound = false;
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            spec = mergePolicy.findForcedDeletesMerges(this.segmentInfos, this);
            boolean bl = newMergesFound = spec != null;
            if (newMergesFound) {
                int numMerges = spec.merges.size();
                for (int i = 0; i < numMerges; ++i) {
                    this.registerMerge(spec.merges.get(i));
                }
            }
        }
        this.mergeScheduler.merge(this.mergeSource, MergeTrigger.EXPLICIT);
        if (spec != null && doWait) {
            int numMerges = spec.merges.size();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                boolean running = true;
                while (running) {
                    if (this.tragedy.get() != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete forceMergeDeletes", this.tragedy.get());
                    }
                    running = false;
                    for (int i = 0; i < numMerges; ++i) {
                        Throwable t;
                        MergePolicy.OneMerge merge = spec.merges.get(i);
                        if (this.pendingMerges.contains(merge) || this.runningMerges.contains(merge)) {
                            running = true;
                        }
                        if ((t = merge.getException()) == null) continue;
                        throw new IOException("background merge hit exception: " + merge.segString(), t);
                    }
                    if (!running) continue;
                    this.doWait();
                }
            }
        }
    }

    public void forceMergeDeletes() throws IOException {
        this.forceMergeDeletes(true);
    }

    public final void maybeMerge() throws IOException {
        this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.EXPLICIT, -1);
    }

    private final void maybeMerge(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        this.ensureOpen(false);
        if (this.updatePendingMerges(mergePolicy, trigger, maxNumSegments) != null) {
            this.executeMerge(trigger);
        }
    }

    final void executeMerge(MergeTrigger trigger) throws IOException {
        this.mergeScheduler.merge(this.mergeSource, trigger);
    }

    private synchronized MergePolicy.MergeSpecification updatePendingMerges(MergePolicy mergePolicy, MergeTrigger trigger, int maxNumSegments) throws IOException {
        int i;
        int numMerges;
        MergePolicy.MergeSpecification spec;
        this.messageState();
        assert (maxNumSegments == -1 || maxNumSegments > 0);
        assert (trigger != null);
        if (!this.merges.areEnabled()) {
            return null;
        }
        if (this.tragedy.get() != null) {
            return null;
        }
        if (maxNumSegments != -1) {
            assert (trigger == MergeTrigger.EXPLICIT || trigger == MergeTrigger.MERGE_FINISHED) : "Expected EXPLICT or MERGE_FINISHED as trigger even with maxNumSegments set but was: " + trigger.name();
            spec = mergePolicy.findForcedMerges(this.segmentInfos, maxNumSegments, Collections.unmodifiableMap(this.segmentsToMerge), this);
            if (spec != null) {
                numMerges = spec.merges.size();
                for (i = 0; i < numMerges; ++i) {
                    MergePolicy.OneMerge merge = spec.merges.get(i);
                    merge.maxNumSegments = maxNumSegments;
                }
            }
        } else {
            switch (trigger) {
                case GET_READER: 
                case COMMIT: {
                    spec = mergePolicy.findFullFlushMerges(trigger, this.segmentInfos, this);
                    break;
                }
                default: {
                    spec = mergePolicy.findMerges(trigger, this.segmentInfos, this);
                }
            }
        }
        if (spec != null) {
            numMerges = spec.merges.size();
            for (i = 0; i < numMerges; ++i) {
                this.registerMerge(spec.merges.get(i));
            }
        }
        return spec;
    }

    @Override
    public synchronized Set<SegmentCommitInfo> getMergingSegments() {
        return Collections.unmodifiableSet(this.mergingSegments);
    }

    private synchronized MergePolicy.OneMerge getNextMerge() {
        if (this.pendingMerges.size() == 0) {
            return null;
        }
        MergePolicy.OneMerge merge = this.pendingMerges.removeFirst();
        this.runningMerges.add(merge);
        return merge;
    }

    public synchronized boolean hasPendingMerges() {
        return this.pendingMerges.size() != 0;
    }

    @Override
    public void rollback() throws IOException {
        if (this.shouldClose(true)) {
            this.rollbackInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternal() throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            this.rollbackInternalNoCommit();
            assert (this.pendingNumDocs.get() == (long)this.segmentInfos.totalMaxDoc()) : "pendingNumDocs " + this.pendingNumDocs.get() + " != " + this.segmentInfos.totalMaxDoc() + " totalMaxDoc";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackInternalNoCommit() throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "rollback");
        }
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.abortMerges();
                assert (this.mergingSegments.isEmpty()) : "we aborted all merges but still have merging segments: " + this.mergingSegments;
            }
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "rollback: done finish merges");
            }
            this.mergeScheduler.close();
            this.docWriter.close();
            assert (!Thread.holdsLock(this)) : "IndexWriter lock should never be hold when aborting";
            this.docWriter.abort();
            this.docWriter.flushControl.waitForFlush();
            this.publishFlushedSegments(true);
            this.eventQueue.close();
            indexWriter = this;
            synchronized (indexWriter) {
                if (this.pendingCommit != null) {
                    this.pendingCommit.rollbackCommit(this.directory);
                    try {
                        this.deleter.decRef(this.pendingCommit);
                    }
                    finally {
                        this.pendingCommit = null;
                        this.notifyAll();
                    }
                }
                int totalMaxDoc = this.segmentInfos.totalMaxDoc();
                this.segmentInfos.rollbackSegmentInfos(this.rollbackSegments);
                int rollbackMaxDoc = this.segmentInfos.totalMaxDoc();
                this.adjustPendingNumDocs(-(totalMaxDoc - rollbackMaxDoc));
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "rollback: infos=" + this.segString(this.segmentInfos));
                }
                this.testPoint("rollback before checkpoint");
                if (this.tragedy.get() == null) {
                    this.deleter.checkpoint(this.segmentInfos, false);
                    this.deleter.refresh();
                    this.deleter.close();
                }
                this.lastCommitChangeCount = this.changeCount.get();
                this.readerPool.close();
                this.closed = true;
                IOUtils.close(this.writeLock);
                this.writeLock = null;
                this.closed = true;
                this.closing = false;
                this.notifyAll();
            }
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeWhileHandlingException(this.mergeScheduler);
                IndexWriter totalMaxDoc = this;
                synchronized (totalMaxDoc) {
                    if (this.pendingCommit != null) {
                        try {
                            this.pendingCommit.rollbackCommit(this.directory);
                            this.deleter.decRef(this.pendingCommit);
                        }
                        catch (Throwable t) {
                            throwable.addSuppressed(t);
                        }
                        this.pendingCommit = null;
                    }
                    IOUtils.closeWhileHandlingException(this.readerPool, this.deleter, this.writeLock);
                    this.writeLock = null;
                    this.closed = true;
                    this.closing = false;
                    this.notifyAll();
                }
            }
            catch (Throwable t) {
                throwable.addSuppressed(t);
            }
            finally {
                if (throwable instanceof VirtualMachineError) {
                    try {
                        this.tragicEvent(throwable, "rollbackInternal");
                    }
                    catch (Throwable t1) {
                        throwable.addSuppressed(t1);
                    }
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public long deleteAll() throws IOException {
        this.ensureOpen();
        boolean success = false;
        try {
            Object object = this.fullFlushLock;
            synchronized (object) {
                Throwable throwable = null;
                try (Closeable finalizer = this.docWriter.lockAndAbortAll();){
                    this.processEvents(false);
                    IndexWriter indexWriter = this;
                    synchronized (indexWriter) {
                        long l;
                        block31: {
                            long seqNo;
                            try {
                                this.abortMerges();
                                assert (!this.merges.areEnabled()) : "merges should be disabled - who enabled them?";
                                assert (this.mergingSegments.isEmpty()) : "found merging segments but merges are disabled: " + this.mergingSegments;
                            }
                            finally {
                                this.merges.enable();
                            }
                            this.adjustPendingNumDocs(-this.segmentInfos.totalMaxDoc());
                            this.segmentInfos.clear();
                            this.deleter.checkpoint(this.segmentInfos, false);
                            this.readerPool.dropAll();
                            this.changeCount.incrementAndGet();
                            this.segmentInfos.changed();
                            this.globalFieldNumberMap.clear();
                            success = true;
                            l = seqNo = this.docWriter.getNextSequenceNumber();
                            if (success || !this.infoStream.isEnabled("IW")) break block31;
                            this.infoStream.message("IW", "hit exception during deleteAll");
                        }
                        return l;
                        {
                            catch (Throwable throwable2) {
                                try {
                                    if (!success && this.infoStream.isEnabled("IW")) {
                                        this.infoStream.message("IW", "hit exception during deleteAll");
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "deleteAll");
            throw tragedy;
        }
    }

    private synchronized void abortMerges() throws IOException {
        this.merges.disable();
        IOUtils.applyToAll(this.pendingMerges, merge -> {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort pending merge " + this.segString(merge.segments));
            }
            this.abortOneMerge((MergePolicy.OneMerge)merge);
            this.mergeFinish((MergePolicy.OneMerge)merge);
        });
        this.pendingMerges.clear();
        for (MergePolicy.OneMerge merge2 : this.runningMerges) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now abort running merge " + this.segString(merge2.segments));
            }
            merge2.setAborted();
        }
        while (this.runningMerges.size() + this.runningAddIndexesMerges.size() != 0) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "now wait for " + this.runningMerges.size() + " running merge/s to abort; currently running addIndexes: " + this.runningAddIndexesMerges.size());
            }
            this.doWait();
        }
        this.notifyAll();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "all running merges have aborted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMerges() throws IOException {
        this.mergeScheduler.merge(this.mergeSource, MergeTrigger.CLOSING);
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges");
            }
            while (this.pendingMerges.size() > 0 || this.runningMerges.size() > 0) {
                this.doWait();
            }
            assert (0 == this.mergingSegments.size());
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "waitForMerges done");
            }
        }
    }

    private synchronized void checkpoint() throws IOException {
        this.changed();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    private synchronized void checkpointNoSIS() throws IOException {
        this.changeCount.incrementAndGet();
        this.deleter.checkpoint(this.segmentInfos, false);
    }

    private synchronized void changed() {
        this.changeCount.incrementAndGet();
        this.segmentInfos.changed();
    }

    private synchronized long publishFrozenUpdates(FrozenBufferedUpdates packet) {
        assert (packet != null && packet.any());
        long nextGen = this.bufferedUpdatesStream.push(packet);
        this.eventQueue.add(w -> {
            try {
                this.tryApply(packet);
            }
            catch (Throwable t) {
                try {
                    w.onTragicEvent(t, "applyUpdatesPacket");
                }
                catch (Throwable t1) {
                    t.addSuppressed(t1);
                }
                throw t;
            }
            w.flushDeletesCount.incrementAndGet();
        });
        return nextGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void publishFlushedSegment(SegmentCommitInfo newSegment, FieldInfos fieldInfos, FrozenBufferedUpdates packet, FrozenBufferedUpdates globalPacket, Sorter.DocMap sortMap) throws IOException {
        block14: {
            boolean published = false;
            try {
                boolean isFullyHardDeleted;
                FieldInfo fieldInfo;
                long nextGen;
                this.ensureOpen(false);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "publishFlushedSegment " + newSegment);
                }
                if (globalPacket != null && globalPacket.any()) {
                    this.publishFrozenUpdates(globalPacket);
                }
                if (packet != null && packet.any()) {
                    nextGen = this.publishFrozenUpdates(packet);
                } else {
                    nextGen = this.bufferedUpdatesStream.getNextGen();
                    this.bufferedUpdatesStream.finishedSegment(nextGen);
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "publish sets newSegment delGen=" + nextGen + " seg=" + this.segString(newSegment));
                }
                newSegment.setBufferedDeletesGen(nextGen);
                this.segmentInfos.add(newSegment);
                published = true;
                this.checkpoint();
                if (packet != null && packet.any() && sortMap != null) {
                    ReadersAndUpdates rld = this.getPooledInstance(newSegment, true);
                    rld.sortMap = sortMap;
                }
                boolean hasInitialSoftDeleted = (fieldInfo = fieldInfos.fieldInfo(this.config.softDeletesField)) != null && fieldInfo.getDocValuesGen() == -1L && fieldInfo.getDocValuesType() != DocValuesType.NONE;
                boolean bl = isFullyHardDeleted = newSegment.getDelCount() == newSegment.info.maxDoc();
                if (!hasInitialSoftDeleted && !isFullyHardDeleted) break block14;
                ReadersAndUpdates rld = this.getPooledInstance(newSegment, true);
                try {
                    if (this.isFullyDeleted(rld)) {
                        this.dropDeletedSegment(newSegment);
                        this.checkpoint();
                    }
                }
                finally {
                    this.release(rld);
                }
            }
            finally {
                if (!published) {
                    this.adjustPendingNumDocs(-newSegment.info.maxDoc());
                }
                this.flushCount.incrementAndGet();
                this.doAfterFlush();
            }
        }
    }

    private synchronized void resetMergeExceptions() {
        this.mergeExceptions.clear();
        ++this.mergeGen;
    }

    private void noDupDirs(Directory ... dirs) {
        HashSet<Directory> dups = new HashSet<Directory>();
        for (int i = 0; i < dirs.length; ++i) {
            if (dups.contains(dirs[i])) {
                throw new IllegalArgumentException("Directory " + dirs[i] + " appears more than once");
            }
            if (dirs[i] == this.directoryOrig) {
                throw new IllegalArgumentException("Cannot add directory to itself");
            }
            dups.add(dirs[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Lock> acquireWriteLocks(Directory ... dirs) throws IOException {
        ArrayList<Lock> locks = new ArrayList<Lock>(dirs.length);
        for (int i = 0; i < dirs.length; ++i) {
            boolean success = false;
            try {
                Lock lock = dirs[i].obtainLock(WRITE_LOCK_NAME);
                locks.add(lock);
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    IOUtils.closeWhileHandlingException(locks);
                }
            }
        }
        return locks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addIndexes(Directory ... dirs) throws IOException {
        long seqNo;
        this.ensureOpen();
        this.noDupDirs(dirs);
        List<Lock> locks = this.acquireWriteLocks(dirs);
        Sort indexSort = this.config.getIndexSort();
        boolean successTop = false;
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(Directory...)");
            }
            this.flush(false, true);
            ArrayList<SegmentCommitInfo> infos = new ArrayList<SegmentCommitInfo>();
            long totalMaxDoc = 0L;
            ArrayList<SegmentInfos> commits = new ArrayList<SegmentInfos>(dirs.length);
            for (Directory dir : dirs) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "addIndexes: process directory " + dir);
                }
                SegmentInfos sis = SegmentInfos.readLatestCommit(dir);
                if (this.segmentInfos.getIndexCreatedVersionMajor() != sis.getIndexCreatedVersionMajor()) {
                    throw new IllegalArgumentException("Cannot use addIndexes(Directory) with indexes that have been created by a different Lucene version. The current index was generated by Lucene " + this.segmentInfos.getIndexCreatedVersionMajor() + " while one of the directories contains an index that was generated with Lucene " + sis.getIndexCreatedVersionMajor());
                }
                totalMaxDoc += (long)sis.totalMaxDoc();
                commits.add(sis);
            }
            this.testReserveDocs(totalMaxDoc);
            boolean success = false;
            try {
                for (SegmentInfos sis : commits) {
                    for (SegmentCommitInfo info : sis) {
                        assert (!infos.contains(info)) : "dup info dir=" + info.info.dir + " name=" + info.info.name;
                        Sort segmentIndexSort = info.info.getIndexSort();
                        if (!(indexSort == null || segmentIndexSort != null && IndexWriter.isCongruentSort(indexSort, segmentIndexSort))) {
                            throw new IllegalArgumentException("cannot change index sort from " + segmentIndexSort + " to " + indexSort);
                        }
                        String newSegName = this.newSegmentName();
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "addIndexes: process segment origName=" + info.info.name + " newName=" + newSegName + " info=" + info);
                        }
                        IOContext context = new IOContext(new FlushInfo(info.info.maxDoc(), info.sizeInBytes()));
                        FieldInfos fis = IndexWriter.readFieldInfos(info);
                        for (FieldInfo fi : fis) {
                            this.globalFieldNumberMap.addOrGet(fi.name, fi.number, fi.getIndexOptions(), fi.getDocValuesType(), fi.getPointDimensionCount(), fi.getPointIndexDimensionCount(), fi.getPointNumBytes(), fi.isSoftDeletesField());
                        }
                        infos.add(this.copySegmentAsIs(info, newSegName, context));
                    }
                }
                success = true;
            }
            finally {
                if (!success) {
                    for (SegmentCommitInfo sipc : infos) {
                        this.deleteNewFiles(sipc.files());
                    }
                }
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                success = false;
                try {
                    this.ensureOpen();
                    this.reserveDocs(totalMaxDoc);
                    seqNo = this.docWriter.getNextSequenceNumber();
                    success = true;
                }
                finally {
                    if (!success) {
                        for (SegmentCommitInfo sipc : infos) {
                            this.deleteNewFiles(sipc.files());
                        }
                    }
                }
                this.segmentInfos.addAll(infos);
                this.checkpoint();
            }
            successTop = true;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "addIndexes(Directory...)");
            throw tragedy;
        }
        finally {
            if (successTop) {
                IOUtils.close(locks);
            } else {
                IOUtils.closeWhileHandlingException(locks);
            }
        }
        this.maybeMerge();
        return seqNo;
    }

    private void validateMergeReader(CodecReader leaf) {
        LeafMetaData segmentMeta = leaf.getMetaData();
        if (this.segmentInfos.getIndexCreatedVersionMajor() != segmentMeta.getCreatedVersionMajor()) {
            throw new IllegalArgumentException("Cannot merge a segment that has been created with major version " + segmentMeta.getCreatedVersionMajor() + " into this index which has been created by major version " + this.segmentInfos.getIndexCreatedVersionMajor());
        }
        if (this.segmentInfos.getIndexCreatedVersionMajor() >= 7 && segmentMeta.getMinVersion() == null) {
            throw new IllegalStateException("Indexes created on or after Lucene 7 must record the created version major, but " + leaf + " hides it");
        }
        Sort leafIndexSort = segmentMeta.getSort();
        if (!(this.config.getIndexSort() == null || leafIndexSort != null && IndexWriter.isCongruentSort(this.config.getIndexSort(), leafIndexSort))) {
            throw new IllegalArgumentException("cannot change index sort from " + leafIndexSort + " to " + this.config.getIndexSort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addIndexes(CodecReader ... readers) throws IOException {
        long seqNo;
        this.ensureOpen();
        long numDocs = 0L;
        try {
            boolean useCompoundFile;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "flush at addIndexes(CodecReader...)");
            }
            this.flush(false, true);
            String mergedName = this.newSegmentName();
            int numSoftDeleted = 0;
            for (CodecReader leaf : readers) {
                numDocs += (long)leaf.numDocs();
                this.validateMergeReader(leaf);
                if (!this.softDeletesEnabled) continue;
                Bits liveDocs = leaf.getLiveDocs();
                numSoftDeleted += PendingSoftDeletes.countSoftDeletes(DocValuesFieldExistsQuery.getDocValuesDocIdSetIterator(this.config.getSoftDeletesField(), leaf), liveDocs);
            }
            this.testReserveDocs(numDocs);
            IOContext context = new IOContext(new MergeInfo(Math.toIntExact(numDocs), -1L, false, -1));
            TrackingDirectoryWrapper trackingDir = new TrackingDirectoryWrapper(this.directory);
            Codec codec = this.config.getCodec();
            SegmentInfo info = new SegmentInfo(this.directoryOrig, Version.LATEST, null, mergedName, -1, false, codec, Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), this.config.getIndexSort());
            SegmentMerger merger = new SegmentMerger(Arrays.asList(readers), info, this.infoStream, trackingDir, this.globalFieldNumberMap, context);
            if (!merger.shouldMerge()) {
                return this.docWriter.getNextSequenceNumber();
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                this.ensureOpen();
                assert (this.merges.areEnabled());
                this.runningAddIndexesMerges.add(merger);
            }
            try {
                merger.merge();
            }
            finally {
                indexWriter = this;
                synchronized (indexWriter) {
                    this.runningAddIndexesMerges.remove(merger);
                    this.notifyAll();
                }
            }
            SegmentCommitInfo infoPerCommit = new SegmentCommitInfo(info, 0, numSoftDeleted, -1L, -1L, -1L, StringHelper.randomId());
            info.setFiles(new HashSet<String>(trackingDir.getCreatedFiles()));
            trackingDir.clearCreatedFiles();
            IndexWriter.setDiagnostics(info, SOURCE_ADDINDEXES_READERS);
            MergePolicy mergePolicy = this.config.getMergePolicy();
            IndexWriter indexWriter2 = this;
            synchronized (indexWriter2) {
                if (!this.merges.areEnabled()) {
                    this.deleteNewFiles(infoPerCommit.files());
                    return this.docWriter.getNextSequenceNumber();
                }
                this.ensureOpen();
                useCompoundFile = mergePolicy.useCompoundFile(this.segmentInfos, infoPerCommit, this);
            }
            if (useCompoundFile) {
                Collection<String> filesToDelete = infoPerCommit.files();
                TrackingDirectoryWrapper trackingCFSDir = new TrackingDirectoryWrapper(this.directory);
                try {
                    IndexWriter.createCompoundFile(this.infoStream, trackingCFSDir, info, context, this::deleteNewFiles);
                }
                finally {
                    this.deleteNewFiles(filesToDelete);
                }
                info.setUseCompoundFile(true);
            }
            codec.segmentInfoFormat().write(trackingDir, info, context);
            info.addFiles(trackingDir.getCreatedFiles());
            indexWriter2 = this;
            synchronized (indexWriter2) {
                if (!this.merges.areEnabled()) {
                    this.deleteNewFiles(infoPerCommit.files());
                    return this.docWriter.getNextSequenceNumber();
                }
                this.ensureOpen();
                this.reserveDocs(numDocs);
                this.segmentInfos.add(infoPerCommit);
                seqNo = this.docWriter.getNextSequenceNumber();
                this.checkpoint();
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, SOURCE_ADDINDEXES_READERS);
            throw tragedy;
        }
        this.maybeMerge();
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SegmentCommitInfo copySegmentAsIs(SegmentCommitInfo info, String segName, IOContext context) throws IOException {
        SegmentInfo newInfo = new SegmentInfo(this.directoryOrig, info.info.getVersion(), info.info.getMinVersion(), segName, info.info.maxDoc(), info.info.getUseCompoundFile(), info.info.getCodec(), info.info.getDiagnostics(), info.info.getId(), info.info.getAttributes(), info.info.getIndexSort());
        SegmentCommitInfo newInfoPerCommit = new SegmentCommitInfo(newInfo, info.getDelCount(), info.getSoftDelCount(), info.getDelGen(), info.getFieldInfosGen(), info.getDocValuesGen(), info.getId());
        newInfo.setFiles(info.info.files());
        newInfoPerCommit.setFieldInfosFiles(info.getFieldInfosFiles());
        newInfoPerCommit.setDocValuesUpdatesFiles(info.getDocValuesUpdatesFiles());
        boolean success = false;
        HashSet<String> copiedFiles = new HashSet<String>();
        try {
            for (String file : info.files()) {
                String newFileName = newInfo.namedForThisSegment(file);
                this.directory.copyFrom(info.info.dir, file, newFileName, context);
                copiedFiles.add(newFileName);
            }
            success = true;
        }
        finally {
            if (!success) {
                this.deleteNewFiles(copiedFiles);
            }
        }
        assert (copiedFiles.equals(newInfoPerCommit.files())) : "copiedFiles=" + copiedFiles + " vs " + newInfoPerCommit.files();
        return newInfoPerCommit;
    }

    protected void doAfterFlush() throws IOException {
    }

    protected void doBeforeFlush() throws IOException {
    }

    @Override
    public final long prepareCommit() throws IOException {
        this.ensureOpen();
        this.pendingSeqNo = this.prepareCommitInternal();
        if (this.maybeMerge.getAndSet(false)) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
        return this.pendingSeqNo;
    }

    public final boolean flushNextBuffer() throws IOException {
        try {
            if (this.docWriter.flushOneDWPT()) {
                this.processEvents(true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "flushNextBuffer");
            throw tragedy;
        }
        finally {
            this.maybeCloseOnTragicEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long prepareCommitInternal() throws IOException {
        this.startCommitTime = System.nanoTime();
        Object object = this.commitLock;
        synchronized (object) {
            long seqNo;
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "prepareCommit: flush");
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            if (this.tragedy.get() != null) {
                throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy.get());
            }
            if (this.pendingCommit != null) {
                throw new IllegalStateException("prepareCommit was already called with no corresponding call to commit");
            }
            this.doBeforeFlush();
            this.testPoint("startDoFlush");
            SegmentInfos toCommit = null;
            boolean anyChanges = false;
            MergePolicy.MergeSpecification pointInTimeMerges = null;
            AtomicBoolean stopAddingMergedSegments = new AtomicBoolean(false);
            long maxCommitMergeWaitMillis = this.config.getMaxFullFlushMergeWaitMillis();
            try {
                Object object2 = this.fullFlushLock;
                synchronized (object2) {
                    boolean flushSuccess = false;
                    boolean success = false;
                    try {
                        seqNo = this.docWriter.flushAllThreads();
                        if (seqNo < 0L) {
                            anyChanges = true;
                            seqNo = -seqNo;
                        }
                        if (!anyChanges) {
                            this.flushCount.incrementAndGet();
                        }
                        this.publishFlushedSegments(true);
                        this.processEvents(false);
                        flushSuccess = true;
                        this.applyAllDeletesAndUpdates();
                        IndexWriter indexWriter = this;
                        synchronized (indexWriter) {
                            this.writeReaderPool(true);
                            if (this.changeCount.get() != this.lastCommitChangeCount) {
                                this.changeCount.incrementAndGet();
                                this.segmentInfos.changed();
                            }
                            if (this.commitUserData != null) {
                                HashMap<String, String> userData = new HashMap<String, String>();
                                for (Map.Entry<String, String> ent : this.commitUserData) {
                                    userData.put(ent.getKey(), ent.getValue());
                                }
                                this.segmentInfos.setUserData(userData, false);
                            }
                            toCommit = this.segmentInfos.clone();
                            this.pendingCommitChangeCount = this.changeCount.get();
                            this.deleter.incRef(toCommit.files(false));
                            if (anyChanges && maxCommitMergeWaitMillis > 0L) {
                                pointInTimeMerges = this.preparePointInTimeMerge(toCommit, stopAddingMergedSegments::get, MergeTrigger.COMMIT, sci -> {});
                            }
                        }
                        success = true;
                    }
                    finally {
                        if (!success && this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during prepareCommit");
                        }
                        assert (Thread.holdsLock(this.fullFlushLock));
                        this.docWriter.finishFullFlush(flushSuccess);
                        this.doAfterFlush();
                    }
                }
            }
            catch (VirtualMachineError tragedy) {
                this.tragicEvent(tragedy, "prepareCommit");
                throw tragedy;
            }
            finally {
                this.maybeCloseOnTragicEvent();
            }
            if (pointInTimeMerges != null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "now run merges during commit: " + pointInTimeMerges.segString(this.directory));
                }
                this.mergeScheduler.merge(this.mergeSource, MergeTrigger.COMMIT);
                pointInTimeMerges.await(maxCommitMergeWaitMillis, TimeUnit.MILLISECONDS);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done waiting for merges during commit");
                }
                IndexWriter tragedy = this;
                synchronized (tragedy) {
                    stopAddingMergedSegments.set(true);
                }
            }
            this.filesToCommit = toCommit.files(false);
            try {
                if (anyChanges) {
                    this.maybeMerge.set(true);
                }
                this.startCommit(toCommit);
                if (this.pendingCommit == null) {
                    return -1L;
                }
                return seqNo;
            }
            catch (Throwable t) {
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    if (this.filesToCommit != null) {
                        try {
                            this.deleter.decRef(this.filesToCommit);
                        }
                        catch (Throwable t1) {
                            t.addSuppressed(t1);
                        }
                        finally {
                            this.filesToCommit = null;
                        }
                    }
                }
                throw t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MergePolicy.MergeSpecification preparePointInTimeMerge(SegmentInfos mergingSegmentInfos, final BooleanSupplier stopCollectingMergeResults, MergeTrigger trigger, IOUtils.IOConsumer<SegmentCommitInfo> mergeFinished) throws IOException {
        assert (Thread.holdsLock(this));
        assert (trigger == MergeTrigger.GET_READER || trigger == MergeTrigger.COMMIT) : "illegal trigger: " + (Object)((Object)trigger);
        MergePolicy.MergeSpecification pointInTimeMerges = this.updatePendingMerges(new OneMergeWrappingMergePolicy(this.config.getMergePolicy(), toWrap -> new MergePolicy.OneMerge(toWrap.segments, (MergePolicy.OneMerge)toWrap, trigger, mergingSegmentInfos, mergeFinished){
            SegmentCommitInfo origInfo;
            final AtomicBoolean onlyOnce;
            final /* synthetic */ MergePolicy.OneMerge val$toWrap;
            final /* synthetic */ MergeTrigger val$trigger;
            final /* synthetic */ SegmentInfos val$mergingSegmentInfos;
            final /* synthetic */ IOUtils.IOConsumer val$mergeFinished;
            {
                this.val$toWrap = oneMerge;
                this.val$trigger = mergeTrigger;
                this.val$mergingSegmentInfos = segmentInfos;
                this.val$mergeFinished = iOConsumer;
                super(segments);
                this.onlyOnce = new AtomicBoolean(false);
            }

            @Override
            public void mergeFinished(boolean committed, boolean segmentDropped) throws IOException {
                assert (Thread.holdsLock(IndexWriter.this));
                if (!segmentDropped && committed && !stopCollectingMergeResults.getAsBoolean()) {
                    assert (this.origInfo != null);
                    if (IndexWriter.this.infoStream.isEnabled("IW")) {
                        IndexWriter.this.infoStream.message("IW", "now apply merge during commit: " + this.val$toWrap.segString());
                    }
                    if (this.val$trigger == MergeTrigger.COMMIT) {
                        IndexWriter.this.deleter.incRef(this.origInfo.files());
                    }
                    HashSet<String> mergedSegmentNames = new HashSet<String>();
                    for (Object sci : this.segments) {
                        mergedSegmentNames.add(((SegmentCommitInfo)sci).info.name);
                    }
                    ArrayList<SegmentCommitInfo> toCommitMergedAwaySegments = new ArrayList<SegmentCommitInfo>();
                    for (SegmentCommitInfo sci : this.val$mergingSegmentInfos) {
                        if (!mergedSegmentNames.contains(sci.info.name)) continue;
                        toCommitMergedAwaySegments.add(sci);
                        if (this.val$trigger != MergeTrigger.COMMIT) continue;
                        IndexWriter.this.deleter.decRef(sci.files());
                    }
                    MergePolicy.OneMerge applicableMerge = new MergePolicy.OneMerge(toCommitMergedAwaySegments);
                    applicableMerge.info = this.origInfo;
                    long segmentCounter = Long.parseLong(this.origInfo.info.name.substring(1), 36);
                    this.val$mergingSegmentInfos.counter = Math.max(this.val$mergingSegmentInfos.counter, segmentCounter + 1L);
                    this.val$mergingSegmentInfos.applyMergeChanges(applicableMerge, false);
                } else if (IndexWriter.this.infoStream.isEnabled("IW")) {
                    IndexWriter.this.infoStream.message("IW", "skip apply merge during commit: " + this.val$toWrap.segString());
                }
                this.val$toWrap.mergeFinished(committed, segmentDropped);
                super.mergeFinished(committed, segmentDropped);
            }

            @Override
            void onMergeComplete() throws IOException {
                assert (Thread.holdsLock(IndexWriter.this));
                if (!stopCollectingMergeResults.getAsBoolean() && !this.isAborted() && this.info.info.maxDoc() > 0) {
                    this.val$mergeFinished.accept(this.info);
                    this.origInfo = this.info.clone();
                }
                this.val$toWrap.onMergeComplete();
                super.onMergeComplete();
            }

            @Override
            void initMergeReaders(IOUtils.IOFunction<SegmentCommitInfo, MergePolicy.MergeReader> readerFactory) throws IOException {
                if (this.onlyOnce.compareAndSet(false, true)) {
                    super.initMergeReaders(readerFactory);
                }
            }

            @Override
            public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                return this.val$toWrap.wrapForMerge(reader);
            }
        }), trigger, -1);
        if (pointInTimeMerges != null) {
            boolean closeReaders = true;
            try {
                for (MergePolicy.OneMerge merge2 : pointInTimeMerges.merges) {
                    IOContext context = new IOContext(merge2.getStoreMergeInfo());
                    merge2.initMergeReaders(sci -> {
                        ReadersAndUpdates rld = this.getPooledInstance((SegmentCommitInfo)sci, true);
                        rld.setIsMerging();
                        return rld.getReaderForMerge(context);
                    });
                }
                closeReaders = false;
            }
            finally {
                if (closeReaders) {
                    IOUtils.applyToAll(pointInTimeMerges.merges, merge -> {
                        boolean removed = this.pendingMerges.remove(merge);
                        assert (removed) : "merge should be pending but isn't: " + merge.segString();
                        try {
                            this.abortOneMerge((MergePolicy.OneMerge)merge);
                        }
                        finally {
                            this.mergeFinish((MergePolicy.OneMerge)merge);
                        }
                    });
                }
            }
        }
        return pointInTimeMerges;
    }

    private void writeReaderPool(boolean writeDeletes) throws IOException {
        assert (Thread.holdsLock(this));
        if (writeDeletes) {
            if (this.readerPool.commit(this.segmentInfos)) {
                this.checkpointNoSIS();
            }
        } else if (this.readerPool.writeAllDocValuesUpdates()) {
            this.checkpoint();
        }
        ArrayList<SegmentCommitInfo> toDrop = new ArrayList<SegmentCommitInfo>();
        for (SegmentCommitInfo info : this.segmentInfos) {
            ReadersAndUpdates readersAndUpdates = this.readerPool.get(info, false);
            if (readersAndUpdates == null || !this.isFullyDeleted(readersAndUpdates)) continue;
            toDrop.add(info);
        }
        for (SegmentCommitInfo info : toDrop) {
            this.dropDeletedSegment(info);
        }
        if (!toDrop.isEmpty()) {
            this.checkpoint();
        }
    }

    public final synchronized void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData) {
        this.setLiveCommitData(commitUserData, true);
    }

    public final synchronized void setLiveCommitData(Iterable<Map.Entry<String, String>> commitUserData, boolean doIncrementVersion) {
        this.commitUserData = commitUserData;
        if (doIncrementVersion) {
            this.segmentInfos.changed();
        }
        this.changeCount.incrementAndGet();
    }

    public final synchronized Iterable<Map.Entry<String, String>> getLiveCommitData() {
        return this.commitUserData;
    }

    @Override
    public final long commit() throws IOException {
        this.ensureOpen();
        return this.commitInternal(this.config.getMergePolicy());
    }

    public final boolean hasUncommittedChanges() {
        return this.changeCount.get() != this.lastCommitChangeCount || this.hasChangesInRam();
    }

    boolean hasChangesInRam() {
        return this.docWriter.anyChanges() || this.bufferedUpdatesStream.any();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long commitInternal(MergePolicy mergePolicy) throws IOException {
        long seqNo;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commit: start");
        }
        Object object = this.commitLock;
        synchronized (object) {
            this.ensureOpen(false);
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commit: enter lock");
            }
            if (this.pendingCommit == null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: now prepare");
                }
                seqNo = this.prepareCommitInternal();
            } else {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "commit: already prepared");
                }
                seqNo = this.pendingSeqNo;
            }
            this.finishCommit();
        }
        if (this.maybeMerge.getAndSet(false)) {
            this.maybeMerge(mergePolicy, MergeTrigger.FULL_FLUSH, -1);
        }
        return seqNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCommit() throws IOException {
        boolean commitCompleted = false;
        String committedSegmentsFileName = null;
        try {
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                block29: {
                    this.ensureOpen(false);
                    if (this.tragedy.get() != null) {
                        throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete commit", this.tragedy.get());
                    }
                    if (this.pendingCommit != null) {
                        Collection<String> commitFiles = this.filesToCommit;
                        try (Closeable finalizer = () -> this.deleter.decRef(commitFiles);){
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "commit: pendingCommit != null");
                            }
                            committedSegmentsFileName = this.pendingCommit.finishCommit(this.directory);
                            commitCompleted = true;
                            if (this.infoStream.isEnabled("IW")) {
                                this.infoStream.message("IW", "commit: done writing segments file \"" + committedSegmentsFileName + "\"");
                            }
                            this.deleter.checkpoint(this.pendingCommit, true);
                            this.segmentInfos.updateGeneration(this.pendingCommit);
                            this.lastCommitChangeCount = this.pendingCommitChangeCount;
                            this.rollbackSegments = this.pendingCommit.createBackupSegmentInfos();
                            break block29;
                        }
                        finally {
                            this.notifyAll();
                            this.pendingCommit = null;
                            this.filesToCommit = null;
                        }
                    }
                    assert (this.filesToCommit == null);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "commit: pendingCommit == null; skip");
                    }
                }
            }
        }
        catch (Throwable t) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "hit exception during finishCommit: " + t.getMessage());
            }
            if (commitCompleted) {
                this.tragicEvent(t, "finishCommit");
            }
            throw t;
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", String.format(Locale.ROOT, "commit: took %.1f msec", (double)(System.nanoTime() - this.startCommitTime) / 1000000.0));
            this.infoStream.message("IW", "commit: done");
        }
    }

    public final void flush() throws IOException {
        this.flush(true, true);
    }

    final void flush(boolean triggerMerge, boolean applyAllDeletes) throws IOException {
        this.ensureOpen(false);
        if (this.doFlush(applyAllDeletes) && triggerMerge) {
            this.maybeMerge(this.config.getMergePolicy(), MergeTrigger.FULL_FLUSH, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlush(boolean applyAllDeletes) throws IOException {
        if (this.tragedy.get() != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot flush", this.tragedy.get());
        }
        this.doBeforeFlush();
        this.testPoint("startDoFlush");
        boolean success = false;
        try {
            boolean anyChanges;
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "  start flush: applyAllDeletes=" + applyAllDeletes);
                this.infoStream.message("IW", "  index before flush " + this.segString());
            }
            Object object = this.fullFlushLock;
            synchronized (object) {
                boolean flushSuccess = false;
                try {
                    long seqNo = this.docWriter.flushAllThreads();
                    if (seqNo < 0L) {
                        seqNo = -seqNo;
                        anyChanges = true;
                    } else {
                        anyChanges = false;
                    }
                    if (!anyChanges) {
                        this.flushCount.incrementAndGet();
                    }
                    this.publishFlushedSegments(true);
                    flushSuccess = true;
                }
                finally {
                    assert (Thread.holdsLock(this.fullFlushLock));
                    this.docWriter.finishFullFlush(flushSuccess);
                    this.processEvents(false);
                }
            }
            if (applyAllDeletes) {
                this.applyAllDeletesAndUpdates();
            }
            anyChanges |= this.maybeMerge.getAndSet(false);
            object = this;
            synchronized (object) {
                try {
                    this.writeReaderPool(applyAllDeletes);
                    this.doAfterFlush();
                    success = true;
                    boolean bl = anyChanges;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (VirtualMachineError tragedy) {
                        this.tragicEvent(tragedy, "doFlush");
                        throw tragedy;
                    }
                }
            }
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception during flush");
                }
                this.maybeCloseOnTragicEvent();
            }
        }
    }

    private void applyAllDeletesAndUpdates() throws IOException {
        assert (!Thread.holdsLock(this));
        this.flushDeletesCount.incrementAndGet();
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply all deletes for all segments buffered updates bytesUsed=" + this.bufferedUpdatesStream.ramBytesUsed() + " reader pool bytesUsed=" + this.readerPool.ramBytesUsed());
        }
        this.bufferedUpdatesStream.waitApplyAll(this);
    }

    DocumentsWriter getDocsWriter() {
        return this.docWriter;
    }

    public final synchronized int numRamDocs() {
        this.ensureOpen();
        return this.docWriter.getNumDocs();
    }

    private synchronized void ensureValidMerge(MergePolicy.OneMerge merge) {
        for (SegmentCommitInfo info : merge.segments) {
            if (this.segmentInfos.contains(info)) continue;
            throw new MergePolicy.MergeException("MergePolicy selected a segment (" + info.info.name + ") that is not in the current index " + this.segString());
        }
    }

    private synchronized ReadersAndUpdates commitMergedDeletesAndUpdates(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        this.mergeFinishedGen.incrementAndGet();
        this.testPoint("startCommitMergeDeletes");
        List<SegmentCommitInfo> sourceSegments = merge.segments;
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMergeDeletes " + this.segString(merge.segments));
        }
        long minGen = Long.MAX_VALUE;
        ReadersAndUpdates mergedDeletesAndUpdates = this.getPooledInstance(merge.info, true);
        int numDeletesBefore = mergedDeletesAndUpdates.getDelCount();
        HashMap mappedDVUpdates = new HashMap();
        boolean anyDVUpdates = false;
        assert (sourceSegments.size() == mergeState.docMaps.length);
        for (int i = 0; i < sourceSegments.size(); ++i) {
            SegmentCommitInfo info = sourceSegments.get(i);
            minGen = Math.min(info.getBufferedDeletesGen(), minGen);
            int maxDoc = info.info.maxDoc();
            ReadersAndUpdates rld = this.getPooledInstance(info, false);
            assert (rld != null) : "seg=" + info.info.name;
            MergeState.DocMap segDocMap = mergeState.docMaps[i];
            MergeState.DocMap segLeafDocMap = mergeState.leafDocMaps[i];
            IndexWriter.carryOverHardDeletes(mergedDeletesAndUpdates, maxDoc, mergeState.liveDocs[i], merge.getMergeReader().get((int)i).hardLiveDocs, rld.getHardLiveDocs(), segDocMap, segLeafDocMap);
            Map<String, List<DocValuesFieldUpdates>> mergingDVUpdates = rld.getMergingDVUpdates();
            for (Map.Entry<String, List<DocValuesFieldUpdates>> ent : mergingDVUpdates.entrySet()) {
                String field = ent.getKey();
                HashMap<Long, DocValuesFieldUpdates> mappedField = (HashMap<Long, DocValuesFieldUpdates>)mappedDVUpdates.get(field);
                if (mappedField == null) {
                    mappedField = new HashMap<Long, DocValuesFieldUpdates>();
                    mappedDVUpdates.put(field, mappedField);
                }
                for (DocValuesFieldUpdates updates : ent.getValue()) {
                    int doc;
                    if (this.bufferedUpdatesStream.stillRunning(updates.delGen)) continue;
                    assert (field.equals(updates.field));
                    DocValuesFieldUpdates mappedUpdates = (DocValuesFieldUpdates)mappedField.get(updates.delGen);
                    if (mappedUpdates == null) {
                        switch (updates.type) {
                            case NUMERIC: {
                                mappedUpdates = new NumericDocValuesFieldUpdates(updates.delGen, updates.field, merge.info.info.maxDoc());
                                break;
                            }
                            case BINARY: {
                                mappedUpdates = new BinaryDocValuesFieldUpdates(updates.delGen, updates.field, merge.info.info.maxDoc());
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        mappedField.put(updates.delGen, mappedUpdates);
                    }
                    DocValuesFieldUpdates.Iterator it = updates.iterator();
                    while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
                        int mappedDoc = segDocMap.get(segLeafDocMap.get(doc));
                        if (mappedDoc == -1) continue;
                        if (it.hasValue()) {
                            mappedUpdates.add(mappedDoc, it);
                        } else {
                            mappedUpdates.reset(mappedDoc);
                        }
                        anyDVUpdates = true;
                    }
                }
            }
        }
        if (anyDVUpdates) {
            for (Map d : mappedDVUpdates.values()) {
                for (DocValuesFieldUpdates updates : d.values()) {
                    updates.finish();
                    mergedDeletesAndUpdates.addDVUpdate(updates);
                }
            }
        }
        if (this.infoStream.isEnabled("IW")) {
            if (mergedDeletesAndUpdates == null) {
                this.infoStream.message("IW", "no new deletes or field updates since merge started");
            } else {
                String msg = mergedDeletesAndUpdates.getDelCount() - numDeletesBefore + " new deletes";
                if (anyDVUpdates) {
                    msg = msg + " and " + mergedDeletesAndUpdates.getNumDVUpdates() + " new field updates";
                    msg = msg + " (" + mergedDeletesAndUpdates.ramBytesUsed.get() + ") bytes";
                }
                msg = msg + " since merge started";
                this.infoStream.message("IW", msg);
            }
        }
        merge.info.setBufferedDeletesGen(minGen);
        return mergedDeletesAndUpdates;
    }

    private static void carryOverHardDeletes(ReadersAndUpdates mergedReadersAndUpdates, int maxDoc, Bits mergeLiveDocs, Bits prevHardLiveDocs, Bits currentHardLiveDocs, MergeState.DocMap segDocMap, MergeState.DocMap segLeafDocMap) throws IOException {
        block12: {
            IntPredicate carryOverDelete;
            block11: {
                assert (mergeLiveDocs == null || mergeLiveDocs.length() == maxDoc);
                IntPredicate intPredicate = carryOverDelete = mergeLiveDocs == null || mergeLiveDocs == prevHardLiveDocs ? docId -> !currentHardLiveDocs.get(docId) : docId -> mergeLiveDocs.get(docId) && !currentHardLiveDocs.get(docId);
                if (prevHardLiveDocs == null) break block11;
                assert (currentHardLiveDocs != null);
                assert (mergeLiveDocs != null);
                assert (prevHardLiveDocs.length() == maxDoc);
                assert (currentHardLiveDocs.length() == maxDoc);
                if (currentHardLiveDocs == prevHardLiveDocs) break block12;
                for (int j = 0; j < maxDoc; ++j) {
                    if (!prevHardLiveDocs.get(j)) {
                        assert (!currentHardLiveDocs.get(j));
                        continue;
                    }
                    if (!carryOverDelete.test(j)) continue;
                    mergedReadersAndUpdates.delete(segDocMap.get(segLeafDocMap.get(j)));
                }
                break block12;
            }
            if (currentHardLiveDocs != null) {
                assert (currentHardLiveDocs.length() == maxDoc);
                for (int j = 0; j < maxDoc; ++j) {
                    if (!carryOverDelete.test(j)) continue;
                    mergedReadersAndUpdates.delete(segDocMap.get(segLeafDocMap.get(j)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean commitMerge(MergePolicy.OneMerge merge, MergeState mergeState) throws IOException {
        boolean allDeleted;
        ReadersAndUpdates mergedUpdates;
        merge.onMergeComplete();
        this.testPoint("startCommitMerge");
        if (this.tragedy.get() != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot complete merge", this.tragedy.get());
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "commitMerge: " + this.segString(merge.segments) + " index=" + this.segString());
        }
        assert (merge.registerDone);
        if (merge.isAborted()) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "commitMerge: skip: it was aborted");
            }
            this.readerPool.drop(merge.info);
            this.deleteNewFiles(merge.info.files());
            return false;
        }
        ReadersAndUpdates readersAndUpdates = mergedUpdates = merge.info.info.maxDoc() == 0 ? null : this.commitMergedDeletesAndUpdates(merge, mergeState);
        assert (!this.segmentInfos.contains(merge.info));
        boolean bl = allDeleted = merge.segments.size() == 0 || merge.info.info.maxDoc() == 0 || mergedUpdates != null && this.isFullyDeleted(mergedUpdates);
        if (this.infoStream.isEnabled("IW") && allDeleted) {
            this.infoStream.message("IW", "merged segment " + merge.info + " is 100% deleted; skipping insert");
        }
        boolean dropSegment = allDeleted;
        assert (merge.segments.size() > 0 || dropSegment);
        assert (merge.info.info.maxDoc() != 0 || dropSegment);
        if (mergedUpdates != null) {
            boolean success = false;
            try {
                if (dropSegment) {
                    mergedUpdates.dropChanges();
                }
                this.release(mergedUpdates, false);
                success = true;
            }
            finally {
                if (!success) {
                    mergedUpdates.dropChanges();
                    this.readerPool.drop(merge.info);
                }
            }
        }
        this.segmentInfos.applyMergeChanges(merge, dropSegment);
        int delDocCount = dropSegment ? merge.totalMaxDoc : merge.totalMaxDoc - merge.info.info.maxDoc();
        assert (delDocCount >= 0);
        this.adjustPendingNumDocs(-delDocCount);
        if (dropSegment) {
            assert (!this.segmentInfos.contains(merge.info));
            this.readerPool.drop(merge.info);
            this.deleteNewFiles(merge.info.files());
        }
        try (Closeable finalizer = this::checkpoint;){
            this.closeMergeReaders(merge, false, dropSegment);
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "after commitMerge: " + this.segString());
        }
        if (merge.maxNumSegments != -1 && !dropSegment && !this.segmentsToMerge.containsKey(merge.info)) {
            this.segmentsToMerge.put(merge.info, Boolean.FALSE);
        }
        return true;
    }

    private void handleMergeException(Throwable t, MergePolicy.OneMerge merge) throws IOException {
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "handleMergeException: merge=" + this.segString(merge.segments) + " exc=" + t);
        }
        merge.setException(t);
        this.addMergeException(merge);
        if (t instanceof MergePolicy.MergeAbortedException) {
            if (merge.isExternal) {
                throw (MergePolicy.MergeAbortedException)t;
            }
        } else {
            assert (t != null);
            throw IOUtils.rethrowAlways(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void merge(MergePolicy.OneMerge merge) throws IOException {
        boolean success = false;
        long t0 = System.currentTimeMillis();
        MergePolicy mergePolicy = this.config.getMergePolicy();
        try {
            try {
                try {
                    this.mergeInit(merge);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "now merge\n  merge=" + this.segString(merge.segments) + "\n  index=" + this.segString());
                    }
                    this.mergeMiddle(merge, mergePolicy);
                    this.mergeSuccess(merge);
                    success = true;
                }
                catch (Throwable t) {
                    this.handleMergeException(t, merge);
                }
            }
            finally {
                IndexWriter t = this;
                synchronized (t) {
                    if (!success) {
                        this.closeMergeReaders(merge, true, false);
                    }
                    this.mergeFinish(merge);
                    if (!success) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception during merge");
                        }
                    } else if (!(merge.isAborted() || merge.maxNumSegments == -1 && (this.closed || this.closing))) {
                        this.updatePendingMerges(mergePolicy, MergeTrigger.MERGE_FINISHED, merge.maxNumSegments);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.tragicEvent(t, SOURCE_MERGE);
            throw t;
        }
        if (merge.info != null && !merge.isAborted() && this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge time " + (System.currentTimeMillis() - t0) + " msec for " + merge.info.info.maxDoc() + " docs");
        }
    }

    protected void mergeSuccess(MergePolicy.OneMerge merge) {
    }

    private void abortOneMerge(MergePolicy.OneMerge merge) throws IOException {
        merge.setAborted();
        this.closeMergeReaders(merge, true, false);
    }

    private synchronized boolean registerMerge(MergePolicy.OneMerge merge) throws IOException {
        if (merge.registerDone) {
            return true;
        }
        assert (merge.segments.size() > 0);
        if (!this.merges.areEnabled()) {
            this.abortOneMerge(merge);
            throw new MergePolicy.MergeAbortedException("merge is aborted: " + this.segString(merge.segments));
        }
        boolean isExternal = false;
        for (SegmentCommitInfo segmentCommitInfo : merge.segments) {
            if (this.mergingSegments.contains(segmentCommitInfo)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(segmentCommitInfo) + " is already marked for merge");
                }
                return false;
            }
            if (!this.segmentInfos.contains(segmentCommitInfo)) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "reject merge " + this.segString(merge.segments) + ": segment " + this.segString(segmentCommitInfo) + " does not exist in live infos");
                }
                return false;
            }
            if (segmentCommitInfo.info.dir != this.directoryOrig) {
                isExternal = true;
            }
            if (!this.segmentsToMerge.containsKey(segmentCommitInfo)) continue;
            merge.maxNumSegments = this.mergeMaxNumSegments;
        }
        this.ensureValidMerge(merge);
        this.pendingMerges.add(merge);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "add merge to pendingMerges: " + this.segString(merge.segments) + " [total " + this.pendingMerges.size() + " pending]");
        }
        merge.mergeGen = this.mergeGen;
        merge.isExternal = isExternal;
        if (this.infoStream.isEnabled("IW")) {
            StringBuilder builder = new StringBuilder("registerMerge merging= [");
            for (SegmentCommitInfo info : this.mergingSegments) {
                builder.append(info.info.name).append(", ");
            }
            builder.append("]");
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", builder.toString());
            }
        }
        for (SegmentCommitInfo segmentCommitInfo : merge.segments) {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "registerMerge info=" + this.segString(segmentCommitInfo));
            }
            this.mergingSegments.add(segmentCommitInfo);
        }
        assert (merge.estimatedMergeBytes == 0L);
        assert (merge.totalMergeBytes == 0L);
        for (SegmentCommitInfo segmentCommitInfo : merge.segments) {
            if (segmentCommitInfo.info.maxDoc() <= 0) continue;
            int delCount = this.numDeletedDocs(segmentCommitInfo);
            assert (delCount <= segmentCommitInfo.info.maxDoc());
            double delRatio = (double)delCount / (double)segmentCommitInfo.info.maxDoc();
            merge.estimatedMergeBytes = (long)((double)merge.estimatedMergeBytes + (double)segmentCommitInfo.sizeInBytes() * (1.0 - delRatio));
            merge.totalMergeBytes += segmentCommitInfo.sizeInBytes();
        }
        merge.registerDone = true;
        return true;
    }

    final void mergeInit(MergePolicy.OneMerge merge) throws IOException {
        assert (!Thread.holdsLock(this));
        this.bufferedUpdatesStream.waitApplyForMerge(merge.segments, this);
        boolean success = false;
        try {
            this._mergeInit(merge);
            success = true;
        }
        finally {
            if (!success) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "hit exception in mergeInit");
                }
                this.mergeFinish(merge);
            }
        }
    }

    private synchronized void _mergeInit(MergePolicy.OneMerge merge) throws IOException {
        this.testPoint("startMergeInit");
        assert (merge.registerDone);
        assert (merge.maxNumSegments == -1 || merge.maxNumSegments > 0);
        if (this.tragedy.get() != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot merge", this.tragedy.get());
        }
        if (merge.info != null) {
            return;
        }
        merge.mergeInit();
        if (merge.isAborted()) {
            return;
        }
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "now apply deletes for " + merge.segments.size() + " merging segments");
        }
        if (this.readerPool.writeDocValuesUpdatesForMerge(merge.segments)) {
            this.checkpoint();
        }
        String mergeSegmentName = this.newSegmentName();
        SegmentInfo si = new SegmentInfo(this.directoryOrig, Version.LATEST, null, mergeSegmentName, -1, false, this.config.getCodec(), Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), this.config.getIndexSort());
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("mergeMaxNumSegments", "" + merge.maxNumSegments);
        details.put("mergeFactor", Integer.toString(merge.segments.size()));
        IndexWriter.setDiagnostics(si, SOURCE_MERGE, details);
        merge.setMergeInfo(new SegmentCommitInfo(si, 0, 0, -1L, -1L, -1L, StringHelper.randomId()));
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "merge seg=" + merge.info.info.name + " " + this.segString(merge.segments));
        }
    }

    static void setDiagnostics(SegmentInfo info, String source) {
        IndexWriter.setDiagnostics(info, source, null);
    }

    private static void setDiagnostics(SegmentInfo info, String source, Map<String, String> details) {
        HashMap<String, String> diagnostics = new HashMap<String, String>();
        diagnostics.put(SOURCE, source);
        diagnostics.put("lucene.version", Version.LATEST.toString());
        diagnostics.put("os", Constants.OS_NAME);
        diagnostics.put("os.arch", Constants.OS_ARCH);
        diagnostics.put("os.version", Constants.OS_VERSION);
        diagnostics.put("java.version", Constants.JAVA_VERSION);
        diagnostics.put("java.vendor", Constants.JAVA_VENDOR);
        diagnostics.put("java.runtime.version", System.getProperty("java.runtime.version", "undefined"));
        diagnostics.put("java.vm.version", System.getProperty("java.vm.version", "undefined"));
        diagnostics.put("timestamp", Long.toString(new Date().getTime()));
        if (details != null) {
            diagnostics.putAll(details);
        }
        info.setDiagnostics(diagnostics);
    }

    private synchronized void mergeFinish(MergePolicy.OneMerge merge) {
        this.notifyAll();
        if (merge.registerDone) {
            List<SegmentCommitInfo> sourceSegments = merge.segments;
            for (SegmentCommitInfo info : sourceSegments) {
                this.mergingSegments.remove(info);
            }
            merge.registerDone = false;
        }
        this.runningMerges.remove(merge);
    }

    private synchronized void closeMergeReaders(MergePolicy.OneMerge merge, boolean suppressExceptions, boolean droppedSegment) throws IOException {
        if (!merge.hasFinished()) {
            boolean drop = !suppressExceptions;
            merge.close(!suppressExceptions, droppedSegment, mr -> {
                SegmentReader sr = mr.reader;
                ReadersAndUpdates rld = this.getPooledInstance(sr.getOriginalSegmentInfo(), false);
                assert (rld != null);
                if (drop) {
                    rld.dropChanges();
                } else {
                    rld.dropMergingUpdates();
                }
                rld.release(sr);
                this.release(rld);
                if (drop) {
                    this.readerPool.drop(rld.info);
                }
            });
        } else {
            assert (merge.getMergeReader().isEmpty()) : "we are done but still have readers: " + merge.getMergeReader();
            assert (suppressExceptions) : "can't be done and not suppressing exceptions";
        }
    }

    private void countSoftDeletes(CodecReader reader, Bits wrappedLiveDocs, Bits hardLiveDocs, Counter softDeleteCounter, Counter hardDeleteCounter) throws IOException {
        int hardDeleteCount = 0;
        int softDeletesCount = 0;
        DocIdSetIterator softDeletedDocs = DocValuesFieldExistsQuery.getDocValuesDocIdSetIterator(this.config.getSoftDeletesField(), reader);
        if (softDeletedDocs != null) {
            int docId;
            while ((docId = softDeletedDocs.nextDoc()) != Integer.MAX_VALUE) {
                if (wrappedLiveDocs != null && !wrappedLiveDocs.get(docId)) continue;
                if (hardLiveDocs == null || hardLiveDocs.get(docId)) {
                    ++softDeletesCount;
                    continue;
                }
                ++hardDeleteCount;
            }
        }
        softDeleteCounter.addAndGet(softDeletesCount);
        hardDeleteCounter.addAndGet(hardDeleteCount);
    }

    private boolean assertSoftDeletesCount(CodecReader reader, int expectedCount) throws IOException {
        Counter count = Counter.newCounter(false);
        Counter hardDeletes = Counter.newCounter(false);
        this.countSoftDeletes(reader, reader.getLiveDocs(), null, count, hardDeletes);
        assert (count.get() == (long)expectedCount) : "soft-deletes count mismatch expected: " + expectedCount + " but actual: " + count.get();
        return true;
    }

    /*
     * Exception decompiling
     */
    private int mergeMiddle(MergePolicy.OneMerge merge, MergePolicy mergePolicy) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[MONITOR]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void addMergeException(MergePolicy.OneMerge merge) {
        assert (merge.getException() != null);
        if (!this.mergeExceptions.contains(merge) && this.mergeGen == merge.mergeGen) {
            this.mergeExceptions.add(merge);
        }
    }

    final int getBufferedDeleteTermsSize() {
        return this.docWriter.getBufferedDeleteTermsSize();
    }

    final int getNumBufferedDeleteTerms() {
        return this.docWriter.getNumBufferedDeleteTerms();
    }

    synchronized SegmentCommitInfo newestSegment() {
        return this.segmentInfos.size() > 0 ? this.segmentInfos.info(this.segmentInfos.size() - 1) : null;
    }

    synchronized String segString() {
        return this.segString(this.segmentInfos);
    }

    synchronized String segString(Iterable<SegmentCommitInfo> infos) {
        return StreamSupport.stream(infos.spliterator(), false).map(this::segString).collect(Collectors.joining(" "));
    }

    private synchronized String segString(SegmentCommitInfo info) {
        return info.toString(this.numDeletedDocs(info) - info.getDelCount(this.softDeletesEnabled));
    }

    private synchronized void doWait() {
        try {
            this.wait(1000L);
        }
        catch (InterruptedException ie) {
            throw new ThreadInterruptedException(ie);
        }
    }

    private boolean filesExist(SegmentInfos toSync) throws IOException {
        Collection<String> files = toSync.files(false);
        for (String fileName : files) {
            assert (this.deleter.exists(fileName)) : "IndexFileDeleter doesn't know about file " + fileName;
        }
        return true;
    }

    synchronized SegmentInfos toLiveInfos(SegmentInfos sis) {
        SegmentInfos newSIS = new SegmentInfos(sis.getIndexCreatedVersionMajor());
        HashMap<SegmentCommitInfo, SegmentCommitInfo> liveSIS = new HashMap<SegmentCommitInfo, SegmentCommitInfo>();
        for (SegmentCommitInfo info : this.segmentInfos) {
            liveSIS.put(info, info);
        }
        for (SegmentCommitInfo info : sis) {
            SegmentCommitInfo liveInfo = (SegmentCommitInfo)liveSIS.get(info);
            if (liveInfo != null) {
                info = liveInfo;
            }
            newSIS.add(info);
        }
        return newSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCommit(SegmentInfos toSync) throws IOException {
        this.testPoint("startStartCommit");
        assert (this.pendingCommit == null);
        if (this.tragedy.get() != null) {
            throw new IllegalStateException("this writer hit an unrecoverable error; cannot commit", this.tragedy.get());
        }
        try {
            if (this.infoStream.isEnabled("IW")) {
                this.infoStream.message("IW", "startCommit(): start");
            }
            IndexWriter indexWriter = this;
            synchronized (indexWriter) {
                if (this.lastCommitChangeCount > this.changeCount.get()) {
                    throw new IllegalStateException("lastCommitChangeCount=" + this.lastCommitChangeCount + ",changeCount=" + this.changeCount);
                }
                if (this.pendingCommitChangeCount == this.lastCommitChangeCount) {
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "  skip startCommit(): no changes pending");
                    }
                    try {
                        this.deleter.decRef(this.filesToCommit);
                    }
                    finally {
                        this.filesToCommit = null;
                    }
                    return;
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "startCommit index=" + this.segString(this.toLiveInfos(toSync)) + " changeCount=" + this.changeCount);
                }
                assert (this.filesExist(toSync));
            }
            this.testPoint("midStartCommit");
            boolean pendingCommitSet = false;
            try {
                Collection<String> filesToSync;
                this.testPoint("midStartCommit2");
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    assert (this.pendingCommit == null);
                    assert (this.segmentInfos.getGeneration() == toSync.getGeneration());
                    toSync.prepareCommit(this.directory);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "startCommit: wrote pending segments file \"" + IndexFileNames.fileNameFromGeneration("pending_segments", "", toSync.getGeneration()) + "\"");
                    }
                    pendingCommitSet = true;
                    this.pendingCommit = toSync;
                }
                boolean success = false;
                try {
                    filesToSync = toSync.files(false);
                    this.directory.sync(filesToSync);
                    success = true;
                }
                finally {
                    if (!success) {
                        pendingCommitSet = false;
                        this.pendingCommit = null;
                        toSync.rollbackCommit(this.directory);
                    }
                }
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "done all syncs: " + filesToSync);
                }
                this.testPoint("midStartCommitSuccess");
            }
            catch (Throwable t) {
                IndexWriter indexWriter3 = this;
                synchronized (indexWriter3) {
                    if (!pendingCommitSet) {
                        if (this.infoStream.isEnabled("IW")) {
                            this.infoStream.message("IW", "hit exception committing segments file");
                        }
                        try {
                            this.deleter.decRef(this.filesToCommit);
                        }
                        catch (Throwable t1) {
                            t.addSuppressed(t1);
                        }
                        finally {
                            this.filesToCommit = null;
                        }
                    }
                }
                throw t;
            }
            finally {
                IndexWriter success = this;
                synchronized (success) {
                    this.segmentInfos.updateGeneration(toSync);
                }
            }
        }
        catch (VirtualMachineError tragedy) {
            this.tragicEvent(tragedy, "startCommit");
            throw tragedy;
        }
        this.testPoint("finishStartCommit");
    }

    private void onTragicEvent(Throwable tragedy, String location) {
        assert (!(tragedy instanceof MergePolicy.MergeAbortedException));
        assert (tragedy != null);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "hit tragic " + tragedy.getClass().getSimpleName() + " inside " + location);
        }
        this.tragedy.compareAndSet(null, tragedy);
    }

    private void tragicEvent(Throwable tragedy, String location) throws IOException {
        try {
            this.onTragicEvent(tragedy, location);
        }
        finally {
            this.maybeCloseOnTragicEvent();
        }
    }

    private void maybeCloseOnTragicEvent() throws IOException {
        assert (!Thread.holdsLock(this));
        assert (!Thread.holdsLock(this.fullFlushLock));
        if (this.tragedy.get() != null && this.shouldClose(false)) {
            this.rollbackInternal();
        }
    }

    public Throwable getTragicException() {
        return this.tragedy.get();
    }

    public boolean isOpen() {
        return !this.closing && !this.closed;
    }

    private void testPoint(String message) {
        if (this.enableTestPoints) {
            assert (this.infoStream.isEnabled("TP"));
            this.infoStream.message("TP", message);
        }
    }

    synchronized boolean nrtIsCurrent(SegmentInfos infos) {
        boolean isCurrent;
        this.ensureOpen();
        boolean bl = isCurrent = infos.getVersion() == this.segmentInfos.getVersion() && !this.docWriter.anyChanges() && !this.bufferedUpdatesStream.any() && !this.readerPool.anyDocValuesChanges();
        if (this.infoStream.isEnabled("IW") && !isCurrent) {
            this.infoStream.message("IW", "nrtIsCurrent: infoVersion matches: " + (infos.getVersion() == this.segmentInfos.getVersion()) + "; DW changes: " + this.docWriter.anyChanges() + "; BD changes: " + this.bufferedUpdatesStream.any());
        }
        return isCurrent;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    boolean isDeleterClosed() {
        return this.deleter.isClosed();
    }

    public synchronized void deleteUnusedFiles() throws IOException {
        this.ensureOpen(false);
        this.deleter.revisitPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createCompoundFile(InfoStream infoStream, TrackingDirectoryWrapper directory, SegmentInfo info, IOContext context, IOUtils.IOConsumer<Collection<String>> deleteFiles) throws IOException {
        if (!directory.getCreatedFiles().isEmpty()) {
            throw new IllegalStateException("pass a clean trackingdir for CFS creation");
        }
        if (infoStream.isEnabled("IW")) {
            infoStream.message("IW", "create compound file");
        }
        boolean success = false;
        try {
            info.getCodec().compoundFormat().write(directory, info, context);
            success = true;
        }
        finally {
            if (!success) {
                deleteFiles.accept(directory.getCreatedFiles());
            }
        }
        info.setFiles(new HashSet<String>(directory.getCreatedFiles()));
    }

    private synchronized void deleteNewFiles(Collection<String> files) throws IOException {
        this.deleter.deleteNewFiles(files);
    }

    private synchronized void flushFailed(SegmentInfo info) throws IOException {
        Set<String> files;
        try {
            files = info.files();
        }
        catch (IllegalStateException ise) {
            files = null;
        }
        if (files != null) {
            this.deleter.deleteNewFiles(files);
        }
    }

    private void publishFlushedSegments(boolean forced) throws IOException {
        this.docWriter.purgeFlushTickets(forced, ticket -> {
            DocumentsWriterPerThread.FlushedSegment newSegment = ticket.getFlushedSegment();
            FrozenBufferedUpdates bufferedUpdates = ticket.getFrozenUpdates();
            ticket.markPublished();
            if (newSegment == null) {
                if (bufferedUpdates != null && bufferedUpdates.any()) {
                    this.publishFrozenUpdates(bufferedUpdates);
                    if (this.infoStream.isEnabled("IW")) {
                        this.infoStream.message("IW", "flush: push buffered updates: " + bufferedUpdates);
                    }
                }
            } else {
                assert (newSegment.segmentInfo != null);
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "publishFlushedSegment seg-private updates=" + newSegment.segmentUpdates);
                }
                if (newSegment.segmentUpdates != null && this.infoStream.isEnabled("DW")) {
                    this.infoStream.message("IW", "flush: push buffered seg private updates: " + newSegment.segmentUpdates);
                }
                this.publishFlushedSegment(newSegment.segmentInfo, newSegment.fieldInfos, newSegment.segmentUpdates, bufferedUpdates, newSegment.sortMap);
            }
        });
    }

    public synchronized void incRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.incRef(segmentInfos, false);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "incRefDeleter for NRT reader version=" + segmentInfos.getVersion() + " segments=" + this.segString(segmentInfos));
        }
    }

    public synchronized void decRefDeleter(SegmentInfos segmentInfos) throws IOException {
        this.ensureOpen();
        this.deleter.decRef(segmentInfos);
        if (this.infoStream.isEnabled("IW")) {
            this.infoStream.message("IW", "decRefDeleter for NRT reader version=" + segmentInfos.getVersion() + " segments=" + this.segString(segmentInfos));
        }
    }

    private long maybeProcessEvents(long seqNo) throws IOException {
        if (seqNo < 0L) {
            seqNo = -seqNo;
            this.processEvents(true);
        }
        return seqNo;
    }

    private void processEvents(boolean triggerMerge) throws IOException {
        if (this.tragedy.get() == null) {
            this.eventQueue.processEvents();
        }
        if (triggerMerge) {
            this.maybeMerge(this.getConfig().getMergePolicy(), MergeTrigger.SEGMENT_FLUSH, -1);
        }
    }

    private void reserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.adjustPendingNumDocs(addedNumDocs) > (long)actualMaxDocs) {
            this.adjustPendingNumDocs(-addedNumDocs);
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void testReserveDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        if (this.pendingNumDocs.get() + addedNumDocs > (long)actualMaxDocs) {
            this.tooManyDocs(addedNumDocs);
        }
    }

    private void tooManyDocs(long addedNumDocs) {
        assert (addedNumDocs >= 0L);
        throw new IllegalArgumentException("number of documents in the index cannot exceed " + actualMaxDocs + " (current document count is " + this.pendingNumDocs.get() + "; added numDocs is " + addedNumDocs + ")");
    }

    public long getPendingNumDocs() {
        return this.pendingNumDocs.get();
    }

    public long getMaxCompletedSequenceNumber() {
        this.ensureOpen();
        return this.docWriter.getMaxCompletedSequenceNumber();
    }

    private long adjustPendingNumDocs(long numDocs) {
        long count = this.pendingNumDocs.addAndGet(numDocs);
        assert (count >= 0L) : "pendingNumDocs is negative: " + count;
        return count;
    }

    final boolean isFullyDeleted(ReadersAndUpdates readersAndUpdates) throws IOException {
        if (readersAndUpdates.isFullyDeleted()) {
            assert (Thread.holdsLock(this));
            return !readersAndUpdates.keepFullyDeletedSegment(this.config.getMergePolicy());
        }
        return false;
    }

    @Override
    public final int numDeletesToMerge(SegmentCommitInfo info) throws IOException {
        this.ensureOpen(false);
        this.validate(info);
        MergePolicy mergePolicy = this.config.getMergePolicy();
        ReadersAndUpdates rld = this.getPooledInstance(info, false);
        int numDeletesToMerge = rld != null ? rld.numDeletesToMerge(mergePolicy) : info.getDelCount();
        assert (numDeletesToMerge <= info.info.maxDoc()) : "numDeletesToMerge: " + numDeletesToMerge + " > maxDoc: " + info.info.maxDoc();
        return numDeletesToMerge;
    }

    void release(ReadersAndUpdates readersAndUpdates) throws IOException {
        this.release(readersAndUpdates, true);
    }

    private void release(ReadersAndUpdates readersAndUpdates, boolean assertLiveInfo) throws IOException {
        assert (Thread.holdsLock(this));
        if (this.readerPool.release(readersAndUpdates, assertLiveInfo)) {
            assert (Thread.holdsLock(this));
            this.checkpointNoSIS();
        }
    }

    ReadersAndUpdates getPooledInstance(SegmentCommitInfo info, boolean create) {
        this.ensureOpen(false);
        return this.readerPool.get(info, create);
    }

    final boolean tryApply(FrozenBufferedUpdates updates) throws IOException {
        if (updates.tryLock()) {
            try {
                this.forceApply(updates);
                boolean bl = true;
                return bl;
            }
            finally {
                updates.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void forceApply(FrozenBufferedUpdates updates) throws IOException {
        updates.lock();
        try {
            if (updates.isApplied()) {
                return;
            }
            long startNS = System.nanoTime();
            assert (updates.any());
            HashSet<SegmentCommitInfo> seenSegments = new HashSet<SegmentCommitInfo>();
            int iter = 0;
            int totalSegmentCount = 0;
            long totalDelCount = 0L;
            boolean finished = false;
            while (true) {
                long delCount;
                BufferedUpdatesStream.SegmentState[] segStates;
                String messagePrefix = iter == 0 ? "" : "iter " + iter;
                long iterStartNS = System.nanoTime();
                long mergeGenStart = this.mergeFinishedGen.get();
                HashSet<String> delFiles = new HashSet<String>();
                IndexWriter indexWriter = this;
                synchronized (indexWriter) {
                    List<SegmentCommitInfo> infos = this.getInfosToApply(updates);
                    if (infos == null) {
                        break;
                    }
                    for (SegmentCommitInfo info : infos) {
                        delFiles.addAll(info.files());
                    }
                    segStates = this.openSegmentStates(infos, seenSegments, updates.delGen());
                    if (segStates.length == 0) {
                        if (this.infoStream.isEnabled("BD")) {
                            this.infoStream.message("BD", "packet matches no segments");
                        }
                        break;
                    }
                    if (this.infoStream.isEnabled("BD")) {
                        this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "now apply del packet (%s) to %d segments, mergeGen %d", this, segStates.length, mergeGenStart));
                    }
                    totalSegmentCount += segStates.length;
                    this.deleter.incRef(delFiles);
                }
                AtomicBoolean success = new AtomicBoolean();
                try (Closeable finalizer = () -> this.finishApply(segStates, success.get(), delFiles);){
                    assert (finalizer != null);
                    delCount = updates.apply(segStates);
                    success.set(true);
                }
                this.writeSomeDocValuesUpdates();
                totalDelCount += delCount;
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", String.format(Locale.ROOT, messagePrefix + "done inner apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, segStates.length, delCount, (double)(System.nanoTime() - iterStartNS) / 1.0E9));
                }
                if (updates.privateSegment != null) break;
                IndexWriter indexWriter2 = this;
                synchronized (indexWriter2) {
                    long mergeGenCur = this.mergeFinishedGen.get();
                    if (mergeGenCur == mergeGenStart) {
                        this.bufferedUpdatesStream.finished(updates);
                        finished = true;
                        break;
                    }
                }
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", messagePrefix + "concurrent merges finished; move to next iter");
                }
                ++iter;
            }
            if (!finished) {
                this.bufferedUpdatesStream.finished(updates);
            }
            if (this.infoStream.isEnabled("BD")) {
                String message = String.format(Locale.ROOT, "done apply del packet (%s) to %d segments; %d new deletes/updates; took %.3f sec", this, totalSegmentCount, totalDelCount, (double)(System.nanoTime() - startNS) / 1.0E9);
                if (iter > 0) {
                    message = message + "; " + (iter + 1) + " iters due to concurrent merges";
                }
                message = message + "; " + this.bufferedUpdatesStream.getPendingUpdatesCount() + " packets remain";
                this.infoStream.message("BD", message);
            }
        }
        finally {
            updates.unlock();
        }
    }

    private synchronized List<SegmentCommitInfo> getInfosToApply(FrozenBufferedUpdates updates) {
        List<SegmentCommitInfo> infos;
        if (updates.privateSegment != null) {
            if (this.segmentInfos.contains(updates.privateSegment)) {
                infos = Collections.singletonList(updates.privateSegment);
            } else {
                if (this.infoStream.isEnabled("BD")) {
                    this.infoStream.message("BD", "private segment already gone; skip processing updates");
                }
                infos = null;
            }
        } else {
            infos = this.segmentInfos.asList();
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishApply(BufferedUpdatesStream.SegmentState[] segStates, boolean success, Set<String> delFiles) throws IOException {
        IndexWriter indexWriter = this;
        synchronized (indexWriter) {
            BufferedUpdatesStream.ApplyDeletesResult result;
            try {
                result = this.closeSegmentStates(segStates, success);
            }
            finally {
                this.deleter.decRef(delFiles);
            }
            if (result.anyDeletes) {
                this.maybeMerge.set(true);
                this.checkpoint();
            }
            if (result.allDeleted != null) {
                if (this.infoStream.isEnabled("IW")) {
                    this.infoStream.message("IW", "drop 100% deleted segments: " + this.segString(result.allDeleted));
                }
                for (SegmentCommitInfo info : result.allDeleted) {
                    this.dropDeletedSegment(info);
                }
                this.checkpoint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedUpdatesStream.ApplyDeletesResult closeSegmentStates(BufferedUpdatesStream.SegmentState[] segStates, boolean success) throws IOException {
        ArrayList<SegmentCommitInfo> allDeleted = null;
        long totDelCount = 0L;
        try {
            for (BufferedUpdatesStream.SegmentState segState : segStates) {
                if (!success) continue;
                totDelCount += (long)(segState.rld.getDelCount() - segState.startDelCount);
                int fullDelCount = segState.rld.getDelCount();
                assert (fullDelCount <= segState.rld.info.info.maxDoc()) : fullDelCount + " > " + segState.rld.info.info.maxDoc();
                if (!segState.rld.isFullyDeleted() || this.getConfig().getMergePolicy().keepFullyDeletedSegment(() -> segState.reader)) continue;
                if (allDeleted == null) {
                    allDeleted = new ArrayList<SegmentCommitInfo>();
                }
                allDeleted.add(segState.reader.getOriginalSegmentInfo());
            }
        }
        finally {
            IOUtils.close(segStates);
        }
        if (this.infoStream.isEnabled("BD")) {
            this.infoStream.message("BD", "closeSegmentStates: " + totDelCount + " new deleted documents; pool " + this.bufferedUpdatesStream.getPendingUpdatesCount() + " packets; bytesUsed=" + this.readerPool.ramBytesUsed());
        }
        return new BufferedUpdatesStream.ApplyDeletesResult(totDelCount > 0L, allDeleted);
    }

    private BufferedUpdatesStream.SegmentState[] openSegmentStates(List<SegmentCommitInfo> infos, Set<SegmentCommitInfo> alreadySeenSegments, long delGen) throws IOException {
        ArrayList<BufferedUpdatesStream.SegmentState> segStates = new ArrayList<BufferedUpdatesStream.SegmentState>();
        try {
            for (SegmentCommitInfo info : infos) {
                if (info.getBufferedDeletesGen() > delGen || alreadySeenSegments.contains(info)) continue;
                segStates.add(new BufferedUpdatesStream.SegmentState(this.getPooledInstance(info, true), this::release, info));
                alreadySeenSegments.add(info);
            }
        }
        catch (Throwable t) {
            try {
                IOUtils.close(segStates);
            }
            catch (Throwable t1) {
                t.addSuppressed(t1);
            }
            throw t;
        }
        return segStates.toArray(new BufferedUpdatesStream.SegmentState[0]);
    }

    protected boolean isEnableTestPoints() {
        return false;
    }

    private void validate(SegmentCommitInfo info) {
        if (info.info.dir != this.directoryOrig) {
            throw new IllegalArgumentException("SegmentCommitInfo must be from the same directory");
        }
    }

    final synchronized SegmentInfos cloneSegmentInfos() {
        return this.segmentInfos.clone();
    }

    public synchronized DocStats getDocStats() {
        int numDocs;
        this.ensureOpen();
        int maxDoc = numDocs = this.docWriter.getNumDocs();
        for (SegmentCommitInfo info : this.segmentInfos) {
            maxDoc += info.info.maxDoc();
            numDocs += info.info.maxDoc() - this.numDeletedDocs(info);
        }
        assert (maxDoc >= numDocs) : "maxDoc is less than numDocs: " + maxDoc + " < " + numDocs;
        return new DocStats(maxDoc, numDocs);
    }

    private static /* synthetic */ String lambda$mergeMiddle$21(Map.Entry e) {
        return String.format(Locale.ROOT, "%.1f sec %s", (double)((Long)e.getValue()).longValue() / 1.0E9, ((MergePolicy.OneMergeProgress.PauseReason)((Object)e.getKey())).name().toLowerCase(Locale.ROOT));
    }

    private static /* synthetic */ boolean lambda$mergeMiddle$20(Map.Entry e) {
        return (Long)e.getValue() > 0L;
    }

    private /* synthetic */ MergePolicy.MergeReader lambda$mergeMiddle$19(IOContext context, SegmentCommitInfo sci) throws IOException {
        ReadersAndUpdates rld = this.getPooledInstance(sci, true);
        rld.setIsMerging();
        return rld.getReaderForMerge(context);
    }

    private class Merges {
        private boolean mergesEnabled = true;

        private Merges() {
        }

        boolean areEnabled() {
            assert (Thread.holdsLock(IndexWriter.this));
            return this.mergesEnabled;
        }

        void disable() {
            assert (Thread.holdsLock(IndexWriter.this));
            this.mergesEnabled = false;
        }

        void enable() {
            IndexWriter.this.ensureOpen();
            assert (Thread.holdsLock(IndexWriter.this));
            this.mergesEnabled = true;
        }
    }

    private static class IndexWriterMergeSource
    implements MergeScheduler.MergeSource {
        private final IndexWriter writer;

        private IndexWriterMergeSource(IndexWriter writer) {
            this.writer = writer;
        }

        @Override
        public MergePolicy.OneMerge getNextMerge() {
            MergePolicy.OneMerge nextMerge = this.writer.getNextMerge();
            if (nextMerge != null && this.writer.mergeScheduler.verbose()) {
                this.writer.mergeScheduler.message("  checked out merge " + this.writer.segString(nextMerge.segments));
            }
            return nextMerge;
        }

        @Override
        public void onMergeFinished(MergePolicy.OneMerge merge) {
            this.writer.mergeFinish(merge);
        }

        @Override
        public boolean hasPendingMerges() {
            return this.writer.hasPendingMerges();
        }

        @Override
        public void merge(MergePolicy.OneMerge merge) throws IOException {
            assert (!Thread.holdsLock(this.writer));
            this.writer.merge(merge);
        }

        public String toString() {
            return this.writer.segString();
        }
    }

    public static final class DocStats {
        public final int maxDoc;
        public final int numDocs;

        private DocStats(int maxDoc, int numDocs) {
            this.maxDoc = maxDoc;
            this.numDocs = numDocs;
        }
    }

    @FunctionalInterface
    static interface Event {
        public void process(IndexWriter var1) throws IOException;
    }

    @FunctionalInterface
    public static interface IndexReaderWarmer {
        public void warm(LeafReader var1) throws IOException;
    }

    @FunctionalInterface
    private static interface DocModifier {
        public void run(int var1, ReadersAndUpdates var2) throws IOException;
    }

    static final class EventQueue
    implements Closeable {
        private volatile boolean closed;
        private final Semaphore permits = new Semaphore(Integer.MAX_VALUE);
        private final Queue<Event> queue = new ConcurrentLinkedQueue<Event>();
        private final IndexWriter writer;

        EventQueue(IndexWriter writer) {
            this.writer = writer;
        }

        private void acquire() {
            if (!this.permits.tryAcquire()) {
                throw new AlreadyClosedException("queue is closed");
            }
            if (this.closed) {
                this.permits.release();
                throw new AlreadyClosedException("queue is closed");
            }
        }

        boolean add(Event event) {
            this.acquire();
            try {
                boolean bl = this.queue.add(event);
                return bl;
            }
            finally {
                this.permits.release();
            }
        }

        void processEvents() throws IOException {
            this.acquire();
            try {
                this.processEventsInternal();
            }
            finally {
                this.permits.release();
            }
        }

        private void processEventsInternal() throws IOException {
            Event event;
            assert (Integer.MAX_VALUE - this.permits.availablePermits() > 0) : "must acquire a permit before processing events";
            while ((event = this.queue.poll()) != null) {
                event.process(this.writer);
            }
        }

        @Override
        public synchronized void close() throws IOException {
            assert (!this.closed) : "we should never close this twice";
            this.closed = true;
            if (this.writer.getTragicException() != null) {
                this.queue.clear();
            } else {
                try {
                    this.permits.acquire(Integer.MAX_VALUE);
                }
                catch (InterruptedException e) {
                    throw new ThreadInterruptedException(e);
                }
                try {
                    this.processEventsInternal();
                }
                finally {
                    this.permits.release(Integer.MAX_VALUE);
                }
            }
        }
    }
}

