/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view;

import java.util.Objects;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;

public class RabbitMQMailQueueConfiguration {
    private static final boolean DEFAULT_SIZE_METRICS_DISABLED = false;
    public static final String SIZE_METRICS_ENABLED_PROPERTY = "mailqueue.size.metricsEnabled";
    private final boolean sizeMetricsEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public static RabbitMQMailQueueConfiguration from(Configuration configuration) {
        return RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(Optional.ofNullable(configuration.getBoolean(SIZE_METRICS_ENABLED_PROPERTY, null))).build();
    }

    public static RabbitMQMailQueueConfiguration sizeMetricsEnabled() {
        return RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(true).build();
    }

    public static RabbitMQMailQueueConfiguration sizeMetricsDisabled() {
        return RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(false).build();
    }

    private RabbitMQMailQueueConfiguration(boolean sizeMetricsEnabled) {
        this.sizeMetricsEnabled = sizeMetricsEnabled;
    }

    public boolean isSizeMetricsEnabled() {
        return this.sizeMetricsEnabled;
    }

    public final boolean equals(Object o) {
        if (o instanceof RabbitMQMailQueueConfiguration) {
            RabbitMQMailQueueConfiguration that = (RabbitMQMailQueueConfiguration)o;
            return Objects.equals(this.sizeMetricsEnabled, that.sizeMetricsEnabled);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.sizeMetricsEnabled);
    }

    public static class Builder {
        private Optional<Boolean> sizeMetricsEnabled;

        public Builder sizeMetricsEnabled(boolean sizeMetricsEnabled) {
            this.sizeMetricsEnabled = Optional.of(sizeMetricsEnabled);
            return this;
        }

        public Builder sizeMetricsEnabled(Optional<Boolean> sizeMetricsEnabled) {
            this.sizeMetricsEnabled = sizeMetricsEnabled;
            return this;
        }

        public RabbitMQMailQueueConfiguration build() {
            return new RabbitMQMailQueueConfiguration(this.sizeMetricsEnabled.orElse(false));
        }
    }
}

