/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class FoxProDictionary
extends DBDictionary {
    public FoxProDictionary() {
        this.platform = "Visual FoxPro";
        this.joinSyntax = 1;
        this.supportsForeignKeys = false;
        this.supportsDeferredConstraints = false;
        this.maxTableNameLength = 30;
        this.maxColumnNameLength = 30;
        this.maxIndexNameLength = 8;
        this.maxConstraintNameLength = 8;
        this.binaryTypeName = "GENERAL";
        this.blobTypeName = "GENERAL";
        this.longVarbinaryTypeName = "GENERAL";
        this.clobTypeName = "MEMO";
        this.longVarcharTypeName = "MEMO";
        this.dateTypeName = "TIMESTAMP";
        this.timeTypeName = "TIMESTAMP";
        this.varcharTypeName = "CHARACTER{0}";
        this.bigintTypeName = "DOUBLE";
        this.numericTypeName = "INTEGER";
        this.smallintTypeName = "INTEGER";
        this.bitTypeName = "NUMERIC(1)";
        this.integerTypeName = "INTEGER";
        this.tinyintTypeName = "INTEGER";
        this.decimalTypeName = "DOUBLE";
        this.doubleTypeName = "DOUBLE";
        this.realTypeName = "DOUBLE";
        this.floatTypeName = "NUMERIC(19,16)";
        this.characterColumnSize = 240;
        this.reservedWordSet.add("NAME");
    }

    @Override
    public String getString(ResultSet rs, int column) throws SQLException {
        String str = rs.getString(column);
        if (str != null) {
            str = str.trim();
        }
        return str;
    }

    @Override
    public void setNull(PreparedStatement stmnt, int idx, int colType, Column col) throws SQLException {
        switch (colType) {
            case 2004: {
                stmnt.setBytes(idx, null);
                break;
            }
            case 2005: {
                stmnt.setString(idx, null);
                break;
            }
            default: {
                super.setNull(stmnt, idx, colType, col);
            }
        }
    }

    @Override
    protected String appendSize(Column col, String typeName) {
        if (col.getSize() == 0) {
            if ("CHARACTER".equals(typeName)) {
                col.setSize(240);
            } else if ("NUMERIC".equals(typeName)) {
                col.setSize(19);
            }
        }
        return super.appendSize(col, typeName);
    }

    @Override
    protected String getPrimaryKeyConstraintSQL(PrimaryKey pk) {
        return null;
    }

    @Override
    public String[] getCreateIndexSQL(Index index) {
        return new String[0];
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, String catalog, String schemaName, String tableName, String columnName, Connection conn) throws SQLException {
        return this.getColumns(meta, DBIdentifier.newCatalog(catalog), DBIdentifier.newSchema(schemaName), DBIdentifier.newTable(tableName), DBIdentifier.newColumn(columnName), conn);
    }

    @Override
    public Column[] getColumns(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, DBIdentifier columnName, Connection conn) throws SQLException {
        try {
            Column[] cols = super.getColumns(meta, catalog, schemaName, tableName, columnName, conn);
            for (int i = 0; cols != null && i < cols.length; ++i) {
                if (cols[i].getType() == 11) {
                    cols[i].setType(93);
                    continue;
                }
                if (!"MEMO".equals(cols[i].getTypeIdentifier().getName())) continue;
                cols[i].setType(2005);
            }
            return cols;
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 562) {
                return null;
            }
            throw se;
        }
    }

    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, String catalog, String schemaName, String tableName, Connection conn) throws SQLException {
        return null;
    }

    @Override
    public PrimaryKey[] getPrimaryKeys(DatabaseMetaData meta, DBIdentifier catalog, DBIdentifier schemaName, DBIdentifier tableName, Connection conn) throws SQLException {
        return null;
    }
}

