/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Set;
import javax.inject.Inject;
import org.apache.james.jmap.api.change.TypeStateFactory;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId;
import org.apache.james.jmap.api.model.PushSubscriptionNotFoundException;
import org.apache.james.jmap.api.model.TypeName;
import org.apache.james.jmap.api.model.VerificationCode;
import org.apache.james.jmap.api.model.VerificationCode$;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.core.PushSubscriptionPatchObject;
import org.apache.james.jmap.core.PushSubscriptionSetRequest;
import org.apache.james.jmap.core.UTCDate;
import org.apache.james.jmap.core.UnparsedPushSubscriptionId;
import org.apache.james.jmap.core.ValidatedPushSubscriptionPatchObject;
import org.apache.james.jmap.method.PushSubscriptionSetUpdatePerformer;
import org.apache.james.jmap.method.PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateResults$;
import org.apache.james.jmap.method.PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateSuccess$;
import org.apache.james.mailbox.MailboxSession;
import org.reactivestreams.Publisher;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005mc\u0001\u0002\u0006\f\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\tM\u0001\u0011\t\u0011)A\u0005O!)Q\u0006\u0001C\u0001]!)A\b\u0001C\u0001{!)A\u000e\u0001C\u0005[\"9\u0011\u0011\u0001\u0001\u0005\n\u0005\r\u0001bBA\u000e\u0001\u0011%\u0011Q\u0004\u0005\b\u0003{\u0001A\u0011BA \u0011\u001d\ty\u0005\u0001C\u0005\u0003#\u0012q\u0004U;tQN+(m]2sSB$\u0018n\u001c8Va\u0012\fG/\u001a)fe\u001a|'/\\3s\u0015\taQ\"\u0001\u0004nKRDw\u000e\u001a\u0006\u0003\u001d=\tAA[7ba*\u0011\u0001#E\u0001\u0006U\u0006lWm\u001d\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u000eqkND7+\u001e2tGJL\u0007\u000f^5p]J+\u0007o\\:ji>\u0014\u0018\u0010\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005\u0001\u0002/^:igV\u00147o\u0019:jaRLwN\u001c\u0006\u0003G5\t1!\u00199j\u0013\t)\u0003E\u0001\u000eQkND7+\u001e2tGJL\u0007\u000f^5p]J+\u0007o\\:ji>\u0014\u00180\u0001\tusB,7\u000b^1uK\u001a\u000b7\r^8ssB\u0011\u0001fK\u0007\u0002S)\u0011!FI\u0001\u0007G\"\fgnZ3\n\u00051J#\u0001\u0005+za\u0016\u001cF/\u0019;f\r\u0006\u001cGo\u001c:z\u0003\u0019a\u0014N\\5u}Q\u0019q&\r\u001a\u0011\u0005A\u0002Q\"A\u0006\t\u000bu\u0019\u0001\u0019\u0001\u0010\t\u000b\u0019\u001a\u0001\u0019A\u0014)\u0005\r!\u0004CA\u001b;\u001b\u00051$BA\u001c9\u0003\u0019IgN[3di*\t\u0011(A\u0003kCZ\f\u00070\u0003\u0002<m\t1\u0011J\u001c6fGR\fa!\u001e9eCR,Gc\u0001 ^IB\u0019qhR%\u000e\u0003\u0001S!!\u0011\"\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u000eD\u0015\t!U)\u0001\u0003d_J,'\"\u0001$\u0002\u000fI,\u0017m\u0019;pe&\u0011\u0001\n\u0011\u0002\u0006'6{gn\u001c\t\u0003\u0015js!a\u0013-\u000f\u00051;fBA'W\u001d\tqUK\u0004\u0002P):\u0011\u0001kU\u0007\u0002#*\u0011!+F\u0001\u0007yI|w\u000e\u001e \n\u0003QI!AE\n\n\u0005A\t\u0012B\u0001\b\u0010\u0013\taQ\"\u0003\u0002Z\u0017\u0005\u0011\u0003+^:i'V\u00147o\u0019:jaRLwN\\*fiV\u0003H-\u0019;f!\u0016\u0014hm\u001c:nKJL!a\u0017/\u0003;A+8\u000f[*vEN\u001c'/\u001b9uS>tW\u000b\u001d3bi\u0016\u0014Vm];miNT!!W\u0006\t\u000by#\u0001\u0019A0\u00025A,8\u000f[*vEN\u001c'/\u001b9uS>t7+\u001a;SKF,Xm\u001d;\u0011\u0005\u0001\u0014W\"A1\u000b\u0005\u0011k\u0011BA2b\u0005i\u0001Vo\u001d5Tk\n\u001c8M]5qi&|gnU3u%\u0016\fX/Z:u\u0011\u0015)G\u00011\u0001g\u00039i\u0017-\u001b7c_b\u001cVm]:j_:\u0004\"a\u001a6\u000e\u0003!T!![\b\u0002\u000f5\f\u0017\u000e\u001c2pq&\u00111\u000e\u001b\u0002\u000f\u001b\u0006LGNY8y'\u0016\u001c8/[8o\u0003Y)\b\u000fZ1uKB+8\u000f[*vEN\u001c'/\u001b9uS>tG\u0003\u00028su~\u00042aP$p!\tQ\u0005/\u0003\u0002r9\na\u0002+^:i'V\u00147o\u0019:jaRLwN\\+qI\u0006$XMU3tk2$\b\"B:\u0006\u0001\u0004!\u0018AA5e!\t)\b0D\u0001w\u0015\t9(%A\u0003n_\u0012,G.\u0003\u0002zm\n\u0011\u0002+^:i'V\u00147o\u0019:jaRLwN\\%e\u0011\u0015YX\u00011\u0001}\u000391\u0018\r\\5eCR,G\rU1uG\"\u0004\"\u0001Y?\n\u0005y\f'\u0001\n,bY&$\u0017\r^3e!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0016\r^2i\u001f\nTWm\u0019;\t\u000b\u0015,\u0001\u0019\u00014\u0002-U\u0004H-\u0019;f-\u0016\u0014\u0018NZ5dCRLwN\\\"pI\u0016$rA\\A\u0003\u0003\u001f\tI\u0002C\u0004\u0002\b\u0019\u0001\r!!\u0003\u0002!A,8\u000f[*vEN\u001c'/\u001b9uS>t\u0007cA;\u0002\f%\u0019\u0011Q\u0002<\u0003!A+8\u000f[*vEN\u001c'/\u001b9uS>t\u0007bBA\t\r\u0001\u0007\u00111C\u0001\u0011m\u0016\u0014\u0018NZ5dCRLwN\\\"pI\u0016\u00042!^A\u000b\u0013\r\t9B\u001e\u0002\u0011-\u0016\u0014\u0018NZ5dCRLwN\\\"pI\u0016DQ!\u001a\u0004A\u0002\u0019\f1\"\u001e9eCR,G+\u001f9fgR9a.a\b\u0002\"\u0005m\u0002bBA\u0004\u000f\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003G9\u0001\u0019AA\u0013\u0003\u0015!\u0018\u0010]3t!\u0019\t9#a\f\u000269!\u0011\u0011FA\u0016!\t\u0001\u0016$C\u0002\u0002.e\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003g\u00111aU3u\u0015\r\ti#\u0007\t\u0004k\u0006]\u0012bAA\u001dm\nAA+\u001f9f\u001d\u0006lW\rC\u0003f\u000f\u0001\u0007a-A\u0007va\u0012\fG/Z#ya&\u0014Xm\u001d\u000b\b]\u0006\u0005\u00131IA'\u0011\u001d\t9\u0001\u0003a\u0001\u0003\u0013Aq!!\u0012\t\u0001\u0004\t9%\u0001\u0007j]B,H/\u0012=qSJ,7\u000fE\u0002v\u0003\u0013J1!a\u0013w\u0005m\u0001Vo\u001d5Tk\n\u001c8M]5qi&|g.\u0012=qSJ,G\rV5nK\")Q\r\u0003a\u0001M\u0006ABo\u001c)vg\"\u001cVOY:de&\u0004H/[8o+B$\u0017\r^3\u0015\u000f=\f\u0019&!\u0016\u0002X!9\u0011qA\u0005A\u0002\u0005%\u0001bBA#\u0013\u0001\u0007\u0011q\t\u0005\b\u00033J\u0001\u0019AA$\u00039)\b\u000fZ1uK\u0012,\u0005\u0010]5sKN\u0004")
public class PushSubscriptionUpdatePerformer {
    private final PushSubscriptionRepository pushSubscriptionRepository;
    private final TypeStateFactory typeStateFactory;

    public SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResults> update(PushSubscriptionSetRequest pushSubscriptionSetRequest, MailboxSession mailboxSession) {
        SFlux qual$1 = SFlux$.MODULE$.fromIterable((Iterable)pushSubscriptionSetRequest.update().getOrElse((Function0 & Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        Function1 & Serializable x$1 = (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                UnparsedPushSubscriptionId unparsedId = (UnparsedPushSubscriptionId)tuple2._1();
                PushSubscriptionPatchObject patch = (PushSubscriptionPatchObject)tuple2._2();
                if (unparsedId != null) {
                    UnparsedPushSubscriptionId unparsedPushSubscriptionId = unparsedId;
                    if (patch != null) {
                        PushSubscriptionPatchObject pushSubscriptionPatchObject = patch;
                        Either either = unparsedPushSubscriptionId.parse().flatMap((Function1 & Serializable)id -> pushSubscriptionPatchObject.validate($this.typeStateFactory).map((Function1 & Serializable)validatedPatch -> this.updatePushSubscription((PushSubscriptionId)id, (ValidatedPushSubscriptionPatchObject)validatedPatch, mailboxSession)));
                        return (SMono)either.fold((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateFailure(unparsedPushSubscriptionId, (Throwable)e)), (Function1 & Serializable)smono -> smono.onErrorResume((Function1 & Serializable)e -> SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateFailure(unparsedPushSubscriptionId, (Throwable)e))));
                    }
                }
            }
            throw new MatchError((Object)tuple2);
        };
        int x$2 = 5;
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, 5, x$3, x$4).collectSeq().map((Function1)PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateResults$.MODULE$);
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updatePushSubscription(PushSubscriptionId id, ValidatedPushSubscriptionPatchObject validatedPatch, MailboxSession mailboxSession) {
        if (validatedPatch.shouldUpdate()) {
            return SMono$.MODULE$.apply(this.pushSubscriptionRepository.get(mailboxSession.getUser(), (Set)ImmutableSet.of((Object)id))).switchIfEmpty(SMono$.MODULE$.error((Throwable)new PushSubscriptionNotFoundException(id))).flatMap((Function1 & Serializable)pushSubscription -> {
                SFlux qual$1 = SFlux$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Publisher[]{(Publisher)validatedPatch.verificationCodeUpdate().map((Function1 & Serializable)verificationCode -> this.updateVerificationCode(pushSubscription, ((VerificationCode)verificationCode).value(), mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()), (Publisher)validatedPatch.typesUpdate().map((Function1 & Serializable)types -> this.updateTypes((PushSubscription)pushSubscription, (scala.collection.immutable.Set<TypeName>)types, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty()), (Publisher)validatedPatch.expiresUpdate().map((Function1 & Serializable)expires -> this.updateExpires((PushSubscription)pushSubscription, (PushSubscriptionExpiredTime)expires, mailboxSession)).getOrElse((Function0 & Serializable)() -> SMono$.MODULE$.empty())}));
                None$ x$1 = qual$1.last$default$1();
                return qual$1.last((Option)x$1);
            });
        }
        return SMono$.MODULE$.empty();
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updateVerificationCode(PushSubscription pushSubscription, String verificationCode, MailboxSession mailboxSession) {
        if (VerificationCode$.MODULE$.equals$extension(verificationCode, (Object)new VerificationCode(pushSubscription.verificationCode()))) {
            return SMono$.MODULE$.apply(this.pushSubscriptionRepository.validateVerificationCode(mailboxSession.getUser(), pushSubscription.id())).then(SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateSuccess(pushSubscription.id(), PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateSuccess$.MODULE$.apply$default$2())));
        }
        return SMono$.MODULE$.error((Throwable)new PushSubscriptionSetUpdatePerformer.WrongVerificationCodeException());
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updateTypes(PushSubscription pushSubscription, scala.collection.immutable.Set<TypeName> types, MailboxSession mailboxSession) {
        return SMono$.MODULE$.apply(this.pushSubscriptionRepository.updateTypes(mailboxSession.getUser(), pushSubscription.id(), CollectionConverters$.MODULE$.SetHasAsJava(types).asJava())).then(SMono$.MODULE$.just((Object)new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateSuccess(pushSubscription.id(), PushSubscriptionSetUpdatePerformer$PushSubscriptionUpdateSuccess$.MODULE$.apply$default$2())));
    }

    private SMono<PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult> updateExpires(PushSubscription pushSubscription, PushSubscriptionExpiredTime inputExpires, MailboxSession mailboxSession) {
        return SMono$.MODULE$.apply(this.pushSubscriptionRepository.updateExpireTime(mailboxSession.getUser(), pushSubscription.id(), inputExpires.value())).map((Function1 & Serializable)x$1 -> this.toPushSubscriptionUpdate(pushSubscription, inputExpires, (PushSubscriptionExpiredTime)x$1));
    }

    private PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateResult toPushSubscriptionUpdate(PushSubscription pushSubscription, PushSubscriptionExpiredTime inputExpires, PushSubscriptionExpiredTime updatedExpires2) {
        return new PushSubscriptionSetUpdatePerformer.PushSubscriptionUpdateSuccess(pushSubscription.id(), (Option<UTCDate>)new Some((Object)updatedExpires2).filter((Function1 & Serializable)updatedExpires -> BoxesRunTime.boxToBoolean((boolean)PushSubscriptionUpdatePerformer.$anonfun$toPushSubscriptionUpdate$1(inputExpires, updatedExpires))).map((Function1 & Serializable)x$2 -> x$2.value()).map((Function1 & Serializable)x$3 -> new UTCDate((ZonedDateTime)x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$toPushSubscriptionUpdate$1(PushSubscriptionExpiredTime inputExpires$2, PushSubscriptionExpiredTime updatedExpires) {
        return !updatedExpires.equals((Object)inputExpires$2);
    }

    @Inject
    public PushSubscriptionUpdatePerformer(PushSubscriptionRepository pushSubscriptionRepository, TypeStateFactory typeStateFactory) {
        this.pushSubscriptionRepository = pushSubscriptionRepository;
        this.typeStateFactory = typeStateFactory;
    }
}

