/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.cassandra.mail;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BatchStatementBuilder;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.relation.Relation;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.cassandra.ids.CassandraId;
import org.apache.james.mailbox.cassandra.table.CassandraFirstUnseenTable;
import org.apache.james.mailbox.model.MessageRange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CassandraFirstUnseenDAO {
    private static final String UID_TO = "uid_to";
    private static final String UID_FROM = "uid_from";
    private static final int BATCH_STATEMENT_WINDOW = 1024;
    private static final int LOW_CONCURRENCY = 2;
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement addStatement;
    private final PreparedStatement deleteStatement;
    private final PreparedStatement deleteAllStatement;
    private final PreparedStatement readStatement;
    private final PreparedStatement listStatement;
    private final PreparedStatement selectOneUidStatement;
    private final PreparedStatement selectBetweenUidStatement;
    private final PreparedStatement selectFromUidStatement;
    private final ProtocolVersion protocolVersion;

    @Inject
    public CassandraFirstUnseenDAO(CqlSession session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.addStatement = this.prepareAddStatement(session);
        this.deleteStatement = this.prepareDeleteStatement(session);
        this.deleteAllStatement = this.prepareDeleteAllStatement(session);
        this.readStatement = this.prepareReadStatement(session);
        this.listStatement = this.prepareListStatement(session);
        this.protocolVersion = session.getContext().getProtocolVersion();
        this.selectOneUidStatement = this.prepareOneUidStatement(session);
        this.selectBetweenUidStatement = this.prepareBetweenUidStatement(session);
        this.selectFromUidStatement = this.prepareFromUidStatement(session);
    }

    private PreparedStatement prepareOneUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"firstUnseen").column(CassandraFirstUnseenTable.UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.UID))})).build());
    }

    private PreparedStatement prepareBetweenUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"firstUnseen").column(CassandraFirstUnseenTable.UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)UID_FROM)), (Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.UID).isLessThanOrEqualTo((Term)QueryBuilder.bindMarker((String)UID_TO))})).build());
    }

    private PreparedStatement prepareFromUidStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"firstUnseen").column(CassandraFirstUnseenTable.UID).where(new Relation[]{(Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)), (Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.UID).isGreaterThanOrEqualTo((Term)QueryBuilder.bindMarker((String)UID_FROM))})).build());
    }

    private PreparedStatement prepareReadStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"firstUnseen").column(CassandraFirstUnseenTable.UID).where((Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)))).orderBy(CassandraFirstUnseenTable.UID, ClusteringOrder.ASC).limit(1).build());
    }

    private PreparedStatement prepareListStatement(CqlSession session) {
        return session.prepare(((Select)QueryBuilder.selectFrom((String)"firstUnseen").column(CassandraFirstUnseenTable.UID).where((Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)))).orderBy(CassandraFirstUnseenTable.UID, ClusteringOrder.ASC).build());
    }

    private PreparedStatement prepareDeleteStatement(CqlSession session) {
        return session.prepare(((Delete)((Delete)QueryBuilder.deleteFrom((String)"firstUnseen").whereColumn(CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID))).whereColumn(CassandraFirstUnseenTable.UID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.UID))).build());
    }

    private PreparedStatement prepareDeleteAllStatement(CqlSession session) {
        return session.prepare(((Delete)QueryBuilder.deleteFrom((String)"firstUnseen").where((Relation)Relation.column((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID).isEqualTo((Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)))).build());
    }

    private PreparedStatement prepareAddStatement(CqlSession session) {
        return session.prepare(QueryBuilder.insertInto((String)"firstUnseen").value(CassandraFirstUnseenTable.MAILBOX_ID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.MAILBOX_ID)).value(CassandraFirstUnseenTable.UID, (Term)QueryBuilder.bindMarker((CqlIdentifier)CassandraFirstUnseenTable.UID)).build());
    }

    public Mono<Void> addUnread(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraFirstUnseenTable.UID, uid.asLong()));
    }

    public Mono<Void> addUnread(CassandraId mailboxId, List<MessageUid> uids) {
        if (uids.size() == 1) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraFirstUnseenTable.UID, uids.iterator().next().asLong()));
        }
        Stream<BatchStatement> batches = Lists.partition(uids, (int)1024).stream().map(uidBatch -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.UNLOGGED);
            uidBatch.forEach(uid -> batch.addStatement((BatchableStatement)((BoundStatement)this.addStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraFirstUnseenTable.UID, uid.asLong())));
            return batch.build();
        });
        return Flux.fromStream(batches).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.cassandraAsyncExecutor).executeVoid(arg_0), 2).then();
    }

    public Mono<Void> removeUnread(CassandraId cassandraId, MessageUid uid) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, cassandraId.asUuid())).setLong(CassandraFirstUnseenTable.UID, uid.asLong()));
    }

    public Mono<Void> removeUnread(CassandraId mailboxId, List<MessageUid> uids) {
        if (uids.size() == 1) {
            return this.cassandraAsyncExecutor.executeVoid((Statement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraFirstUnseenTable.UID, uids.iterator().next().asLong()));
        }
        Stream<BatchStatement> batches = Lists.partition(uids, (int)1024).stream().map(uidBatch -> {
            BatchStatementBuilder batch = new BatchStatementBuilder(BatchType.UNLOGGED);
            uidBatch.forEach(uid -> batch.addStatement((BatchableStatement)((BoundStatement)this.deleteStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, mailboxId.asUuid())).setLong(CassandraFirstUnseenTable.UID, uid.asLong())));
            return batch.build();
        });
        return Flux.fromStream(batches).flatMap(arg_0 -> ((CassandraAsyncExecutor)this.cassandraAsyncExecutor).executeVoid(arg_0), 2).then();
    }

    public Mono<Void> removeAll(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteAllStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, cassandraId.asUuid()));
    }

    public Mono<MessageUid> retrieveFirstUnread(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.readStatement.bind(new Object[0]).setUuid(CassandraFirstUnseenTable.MAILBOX_ID, cassandraId.asUuid())).map(this::asMessageUid);
    }

    public Flux<MessageUid> listUnseen(CassandraId cassandraId) {
        return this.cassandraAsyncExecutor.executeRows((Statement)this.listStatement.bind(new Object[0]).set(CassandraFirstUnseenTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID)).map(this::asMessageUid);
    }

    public Flux<MessageUid> listUnseen(CassandraId cassandraId, MessageRange range) {
        switch (range.getType()) {
            case ALL: {
                return this.listUnseen(cassandraId);
            }
            case FROM: {
                return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)this.selectFromUidStatement.bind(new Object[0]).setLong(UID_FROM, range.getUidFrom().asLong())).set(CassandraFirstUnseenTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID)).map(this::asMessageUid);
            }
            case RANGE: {
                return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)((BoundStatement)this.selectBetweenUidStatement.bind(new Object[0]).setLong(UID_FROM, range.getUidFrom().asLong())).setLong(UID_TO, range.getUidTo().asLong())).set(CassandraFirstUnseenTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID)).map(this::asMessageUid);
            }
            case ONE: {
                return this.cassandraAsyncExecutor.executeRows((Statement)((BoundStatement)this.selectOneUidStatement.bind(new Object[0]).setLong(CassandraFirstUnseenTable.UID, range.getUidFrom().asLong())).set(CassandraFirstUnseenTable.MAILBOX_ID, (Object)cassandraId.asUuid(), TypeCodecs.TIMEUUID)).map(this::asMessageUid);
            }
        }
        throw new RuntimeException("Unsupported range type " + range.getType());
    }

    private MessageUid asMessageUid(Row row) {
        return MessageUid.of((long)TypeCodecs.BIGINT.decodePrimitive(row.getBytesUnsafe(0), this.protocolVersion));
    }
}

