/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class FileSystemTotal
implements JsonpSerializable {
    private final String available;
    private final long availableInBytes;
    private final String free;
    private final long freeInBytes;
    private final String total;
    private final long totalInBytes;
    public static final JsonpDeserializer<FileSystemTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystemTotal::setupFileSystemTotalDeserializer);

    private FileSystemTotal(Builder builder) {
        this.available = ApiTypeHelper.requireNonNull(builder.available, this, "available");
        this.availableInBytes = ApiTypeHelper.requireNonNull(builder.availableInBytes, this, "availableInBytes");
        this.free = ApiTypeHelper.requireNonNull(builder.free, this, "free");
        this.freeInBytes = ApiTypeHelper.requireNonNull(builder.freeInBytes, this, "freeInBytes");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, this, "totalInBytes");
    }

    public static FileSystemTotal of(Function<Builder, ObjectBuilder<FileSystemTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String available() {
        return this.available;
    }

    public final long availableInBytes() {
        return this.availableInBytes;
    }

    public final String free() {
        return this.free;
    }

    public final long freeInBytes() {
        return this.freeInBytes;
    }

    public final String total() {
        return this.total;
    }

    public final long totalInBytes() {
        return this.totalInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("available");
        generator.write(this.available);
        generator.writeKey("available_in_bytes");
        generator.write(this.availableInBytes);
        generator.writeKey("free");
        generator.write(this.free);
        generator.writeKey("free_in_bytes");
        generator.write(this.freeInBytes);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
    }

    protected static void setupFileSystemTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::available, JsonpDeserializer.stringDeserializer(), "available");
        op.add(Builder::availableInBytes, JsonpDeserializer.longDeserializer(), "available_in_bytes");
        op.add(Builder::free, JsonpDeserializer.stringDeserializer(), "free");
        op.add(Builder::freeInBytes, JsonpDeserializer.longDeserializer(), "free_in_bytes");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.longDeserializer(), "total_in_bytes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FileSystemTotal> {
        private String available;
        private Long availableInBytes;
        private String free;
        private Long freeInBytes;
        private String total;
        private Long totalInBytes;

        public final Builder available(String value) {
            this.available = value;
            return this;
        }

        public final Builder availableInBytes(long value) {
            this.availableInBytes = value;
            return this;
        }

        public final Builder free(String value) {
            this.free = value;
            return this;
        }

        public final Builder freeInBytes(long value) {
            this.freeInBytes = value;
            return this;
        }

        public final Builder total(String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInBytes(long value) {
            this.totalInBytes = value;
            return this;
        }

        @Override
        public FileSystemTotal build() {
            this._checkSingleUse();
            return new FileSystemTotal(this);
        }
    }
}

