/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot.restore;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ShardStatistics;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class SnapshotRestore
implements JsonpSerializable {
    private final List<String> indices;
    private final String snapshot;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<SnapshotRestore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotRestore::setupSnapshotRestoreDeserializer);

    private SnapshotRestore(Builder builder) {
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
    }

    public static SnapshotRestore of(Function<Builder, ObjectBuilder<SnapshotRestore>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String item0 : this.indices) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupSnapshotRestoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SnapshotRestore> {
        private List<String> indices;
        private String snapshot;
        private ShardStatistics shards;

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        public SnapshotRestore build() {
            this._checkSingleUse();
            return new SnapshotRestore(this);
        }
    }
}

