/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageSizeEstimator;
import io.netty.channel.socket.DatagramPacket;
import io.netty.incubator.codec.quic.FlushStrategy;
import io.netty.incubator.codec.quic.QuicHeaderParser;
import io.netty.incubator.codec.quic.QuicPacketType;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.incubator.codec.quic.QuicheConfig;
import io.netty.incubator.codec.quic.QuicheQuicChannel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;

abstract class QuicheQuicCodec
extends ChannelDuplexHandler {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(QuicheQuicCodec.class);
    private final Map<ByteBuffer, QuicheQuicChannel> connections = new HashMap<ByteBuffer, QuicheQuicChannel>();
    private final Queue<QuicheQuicChannel> needsFireChannelReadComplete = new ArrayDeque<QuicheQuicChannel>();
    private final int maxTokenLength;
    private final FlushStrategy flushStrategy;
    private MessageSizeEstimator.Handle estimatorHandle;
    private QuicHeaderParser headerParser;
    private QuicHeaderParser.QuicHeaderProcessor parserCallback;
    private int pendingBytes;
    private int pendingPackets;
    protected final QuicheConfig config;
    protected final int localConnIdLength;
    protected ByteBuf senderSockaddrMemory;
    protected ByteBuf recipientSockaddrMemory;

    QuicheQuicCodec(QuicheConfig config, int localConnIdLength, int maxTokenLength, FlushStrategy flushStrategy) {
        this.config = config;
        this.localConnIdLength = localConnIdLength;
        this.maxTokenLength = maxTokenLength;
        this.flushStrategy = flushStrategy;
    }

    protected QuicheQuicChannel getChannel(ByteBuffer key) {
        return this.connections.get(key);
    }

    protected void putChannel(QuicheQuicChannel channel) {
        this.connections.put(channel.key(), channel);
    }

    protected void removeChannel(QuicheQuicChannel channel) {
        this.connections.remove(channel.key());
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.senderSockaddrMemory = Quiche.allocateNativeOrder(Quiche.SIZEOF_SOCKADDR_STORAGE);
        this.recipientSockaddrMemory = Quiche.allocateNativeOrder(Quiche.SIZEOF_SOCKADDR_STORAGE);
        this.headerParser = new QuicHeaderParser(this.maxTokenLength, this.localConnIdLength);
        this.parserCallback = (sender, recipient, buffer, type, version, scid, dcid, token) -> {
            QuicheQuicChannel channel = this.quicPacketRead(ctx, sender, recipient, type, version, scid, dcid, token);
            if (channel != null) {
                channel.recv(recipient, sender, buffer);
                if (channel.markInFireChannelReadCompleteQueue()) {
                    this.needsFireChannelReadComplete.add(channel);
                }
            }
        };
        this.estimatorHandle = ctx.channel().config().getMessageSizeEstimator().newHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerRemoved(ChannelHandlerContext ctx) {
        try {
            for (QuicheQuicChannel ch : this.connections.values().toArray(new QuicheQuicChannel[0])) {
                ch.forceClose();
            }
            this.connections.clear();
            this.needsFireChannelReadComplete.clear();
        }
        finally {
            this.config.free();
            if (this.senderSockaddrMemory != null) {
                this.senderSockaddrMemory.release();
            }
            if (this.recipientSockaddrMemory != null) {
                this.recipientSockaddrMemory.release();
            }
            if (this.headerParser != null) {
                this.headerParser.close();
                this.headerParser = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        block7: {
            DatagramPacket packet = (DatagramPacket)msg;
            try {
                ByteBuf buffer = (ByteBuf)((DatagramPacket)msg).content();
                if (!buffer.isDirect()) {
                    ByteBuf direct = ctx.alloc().directBuffer(buffer.readableBytes());
                    try {
                        direct.writeBytes(buffer, buffer.readerIndex(), buffer.readableBytes());
                        this.handleQuicPacket((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), direct);
                        break block7;
                    }
                    finally {
                        direct.release();
                    }
                }
                this.handleQuicPacket((InetSocketAddress)packet.sender(), (InetSocketAddress)packet.recipient(), buffer);
            }
            finally {
                packet.release();
            }
        }
    }

    private void handleQuicPacket(InetSocketAddress sender, InetSocketAddress recipient, ByteBuf buffer) {
        try {
            this.headerParser.parse(sender, recipient, buffer, this.parserCallback);
        }
        catch (Exception e) {
            LOGGER.debug("Error while processing QUIC packet", (Throwable)e);
        }
    }

    protected abstract QuicheQuicChannel quicPacketRead(ChannelHandlerContext var1, InetSocketAddress var2, InetSocketAddress var3, QuicPacketType var4, int var5, ByteBuf var6, ByteBuf var7, ByteBuf var8) throws Exception;

    public final void channelReadComplete(ChannelHandlerContext ctx) {
        QuicheQuicChannel channel;
        while ((channel = this.needsFireChannelReadComplete.poll()) != null) {
            channel.recvComplete();
            if (!channel.freeIfClosed()) continue;
            this.connections.remove(channel.key());
        }
    }

    public final void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (ctx.channel().isWritable()) {
            Iterator<Map.Entry<ByteBuffer, QuicheQuicChannel>> entries = this.connections.entrySet().iterator();
            while (entries.hasNext()) {
                QuicheQuicChannel channel = entries.next().getValue();
                channel.writable();
                QuicheQuicCodec.removeIfClosed(entries, channel);
            }
        } else {
            ctx.flush();
        }
        ctx.fireChannelWritabilityChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        int size = this.estimatorHandle.size(msg);
        if (size > 0) {
            this.pendingBytes += size;
            ++this.pendingPackets;
        }
        try {
            ctx.write(msg, promise);
        }
        finally {
            if (this.flushStrategy.shouldFlushNow(this.pendingPackets, this.pendingBytes)) {
                this.flushNow(ctx);
            }
        }
    }

    public final void flush(ChannelHandlerContext ctx) {
        if (this.pendingBytes > 0) {
            this.flushNow(ctx);
        }
    }

    private void flushNow(ChannelHandlerContext ctx) {
        this.pendingBytes = 0;
        this.pendingPackets = 0;
        ctx.flush();
    }

    private static void removeIfClosed(Iterator<?> iterator, QuicheQuicChannel current) {
        if (current.freeIfClosed()) {
            iterator.remove();
        }
    }
}

