/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SpanTermQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final String field;
    private final String value;
    public static final JsonpDeserializer<SpanTermQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanTermQuery::setupSpanTermQueryDeserializer);

    private SpanTermQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static SpanTermQuery of(Function<Builder, ObjectBuilder<SpanTermQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanTerm;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanTerm;
    }

    public final String field() {
        return this.field;
    }

    public final String value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        generator.writeKey("value");
        generator.write(this.value);
        generator.writeEnd();
    }

    protected static void setupSpanTermQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanTermQuery> {
        private String field;
        private String value;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanTermQuery build() {
            this._checkSingleUse();
            return new SpanTermQuery(this);
        }
    }
}

