/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import it.unimi.dsi.fastutil.longs.LongConsumer;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.IOException;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.ImapResponseEncoder;
import org.apache.james.imap.message.response.SearchResponse;
import org.apache.james.mailbox.ModSeq;

public class SearchResponseEncoder
implements ImapResponseEncoder<SearchResponse> {
    @Override
    public Class<SearchResponse> acceptableMessages() {
        return SearchResponse.class;
    }

    @Override
    public void encode(SearchResponse response, ImapResponseComposer composer) throws IOException {
        LongList ids = response.getIds();
        ModSeq highestModSeq = response.getHighestModSeq();
        composer.untagged();
        composer.commandName(ImapConstants.SEARCH_COMMAND);
        if (ids != null) {
            LongConsumer longConsumer = l -> {
                try {
                    composer.message(l);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            };
            ids.forEach(longConsumer);
        }
        if (highestModSeq != null) {
            composer.openParen();
            composer.message("MODSEQ");
            composer.message(highestModSeq.asLong());
            composer.closeParen();
        }
        composer.end();
    }
}

