/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.events.delivery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.james.events.Event;
import org.apache.james.events.EventBus;
import org.apache.james.events.EventListener;
import org.apache.james.events.delivery.EventDelivery;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.MDCStructuredLogger;
import org.apache.james.util.ReactorUtils;
import org.apache.james.util.StructuredLogger;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class InVmEventDelivery
implements EventDelivery {
    private static final Logger LOGGER = LoggerFactory.getLogger(InVmEventDelivery.class);
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    public InVmEventDelivery(MetricFactory metricFactory) {
        this.metricFactory = metricFactory;
    }

    @Override
    public Mono<Void> deliver(EventListener.ReactiveEventListener listener, Event event, EventDelivery.DeliveryOption option) {
        return this.deliver(listener, (List<Event>)ImmutableList.of((Object)event), option);
    }

    @Override
    public Mono<Void> deliver(EventListener.ReactiveEventListener listener, List<Event> events, EventDelivery.DeliveryOption option) {
        if (InVmEventDelivery.isHandling(listener, events)) {
            Mono<Void> executionResult = this.deliverByOption(listener, events, option);
            return this.waitForResultIfNeeded(listener.getExecutionMode(), executionResult);
        }
        return Mono.empty();
    }

    private Mono<Void> waitForResultIfNeeded(EventListener.ExecutionMode executionMode, Mono<Void> executionResult) {
        if (executionMode.equals((Object)EventListener.ExecutionMode.SYNCHRONOUS)) {
            return executionResult;
        }
        return Flux.merge((Publisher[])new Publisher[]{executionResult, Mono.empty()}).publishNext().onErrorResume(throwable -> Mono.empty());
    }

    private Mono<Void> deliverByOption(EventListener.ReactiveEventListener listener, List<Event> events, EventDelivery.DeliveryOption deliveryOption) {
        Mono deliveryToListener = this.doDeliverToListener(listener, events).doOnError(throwable -> this.structuredLogger(events, (EventListener)listener).log(logger -> logger.error("Error while processing listener", throwable))).then();
        return deliveryOption.getRetrier().doRetry((Mono<Void>)deliveryToListener, events).then().onErrorResume(e -> Flux.fromIterable((Iterable)events).concatMap(event -> deliveryOption.getPermanentFailureHandler().handle((Event)event)).then());
    }

    private Mono<Void> doDeliverToListener(EventListener.ReactiveEventListener listener, List<Event> events) {
        if (events.stream().noneMatch(arg_0 -> ((EventListener.ReactiveEventListener)listener).isHandling(arg_0))) {
            return Mono.empty();
        }
        return Mono.defer(() -> Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric(EventBus.Metrics.timerName((EventListener)listener), listener.reactiveEvent(events)))).contextWrite((ContextView)ReactorUtils.context((String)"deliver", (MDCBuilder)this.buildMDC((EventListener)listener, events)));
    }

    private static boolean isHandling(EventListener.ReactiveEventListener listener, List<Event> events) {
        return events.stream().anyMatch(arg_0 -> ((EventListener.ReactiveEventListener)listener).isHandling(arg_0));
    }

    private MDCBuilder buildMDC(EventListener listener, List<Event> events) {
        if (events.size() == 1) {
            return MDCBuilder.create().addToContext("eventId", events.getFirst().getEventId().toString()).addToContext("eventClass", events.getFirst().getClass().getCanonicalName()).addToContext("user", events.getFirst().getUsername().asString()).addToContext("listenerClass", listener.getClass().getCanonicalName());
        }
        return MDCBuilder.create().addToContext("eventId", events.stream().map(e -> e.getEventId().getId().toString()).collect(Collectors.joining(","))).addToContext("eventClass", events.stream().map(e -> e.getClass().getCanonicalName()).collect(Collectors.joining(","))).addToContext("user", events.stream().map(e -> e.getUsername().asString()).collect(Collectors.joining(","))).addToContext("listenerClass", listener.getClass().getCanonicalName());
    }

    private StructuredLogger structuredLogger(List<Event> events, EventListener listener) {
        if (events.size() == 1) {
            return MDCStructuredLogger.forLogger((Logger)LOGGER).field("eventId", events.getFirst().getEventId().toString()).field("eventClass", events.getFirst().getClass().getCanonicalName()).field("user", events.getFirst().getUsername().asString()).field("listenerClass", listener.getClass().getCanonicalName());
        }
        return MDCStructuredLogger.forLogger((Logger)LOGGER).field("eventId", events.stream().map(e -> e.getEventId().getId().toString()).collect(Collectors.joining(","))).field("eventClass", events.stream().map(e -> e.getClass().getCanonicalName()).collect(Collectors.joining(","))).field("user", events.stream().map(e -> e.getUsername().asString()).collect(Collectors.joining(","))).field("listenerClass", listener.getClass().getCanonicalName());
    }
}

