/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailetcontainer.impl;

import com.google.common.collect.ImmutableList;
import jakarta.mail.MessagingException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.james.core.MailAddress;
import org.apache.james.mailetcontainer.impl.MailetProcessorImpl;
import org.apache.james.mailetcontainer.impl.MatcherMailetPair;
import org.apache.james.mailetcontainer.impl.ProcessorUtil;
import org.apache.james.mailetcontainer.lib.AbstractStateMailetProcessor;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.MDCBuilder;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MatcherSplitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatcherSplitter.class);
    public static final AttributeName MATCHER_MATCHED_ATTRIBUTE = AttributeName.of((String)"matched");
    private final MetricFactory metricFactory;
    private final MailetProcessorImpl container;
    private final Matcher matcher;
    private final String onMatchException;

    public MatcherSplitter(MetricFactory metricFactory, MailetProcessorImpl container, MatcherMailetPair pair) {
        this.metricFactory = metricFactory;
        this.container = container;
        this.matcher = pair.getMatcher();
        this.onMatchException = pair.onMatchException().map(s -> s.trim().toLowerCase(Locale.US)).orElse("error");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Mail> split(Mail mail) throws MessagingException {
        Collection<MailAddress> matchedRcpts = null;
        ArrayList<MailAddress> origRcpts = new ArrayList<MailAddress>(mail.getRecipients());
        long start = System.currentTimeMillis();
        Throwable ex = null;
        TimeMetric timeMetric = this.metricFactory.timer(this.matcher.getClass().getSimpleName());
        try {
            ArrayList<Mail> mails = new ArrayList<Mail>();
            boolean fullMatch = false;
            try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "MAILET").addToContext("action", "MATCHER").addToContext("ip", mail.getRemoteAddr()).addToContext("host", mail.getRemoteHost()).addToContext("matcher", this.matcher.getMatcherInfo()).addToContext("state", mail.getState()).addToContext("mail", mail.getName()).addToContext("recipients", ImmutableList.copyOf((Collection)mail.getRecipients()).toString()).addToContext("sender", mail.getMaybeSender().asString()).build();){
                matchedRcpts = this.matcher.match(mail);
                if (matchedRcpts == null) {
                    matchedRcpts = new ArrayList(0);
                } else if (matchedRcpts != mail.getRecipients()) {
                    ProcessorUtil.verifyMailAddresses(matchedRcpts);
                }
            }
            catch (Exception | NoClassDefFoundError me) {
                ex = me;
                if (this.onMatchException.equalsIgnoreCase("nomatch")) {
                    LOGGER.warn("Encountered error while executing matcher {}. Matching none.", (Object)this.matcher, (Object)ex);
                    matchedRcpts = new ArrayList(0);
                }
                if (this.onMatchException.equalsIgnoreCase("matchall")) {
                    LOGGER.warn("Encountered error while executing matcher {}. matching all.", (Object)this.matcher, (Object)ex);
                    matchedRcpts = mail.getRecipients();
                }
                if (this.onMatchException.equalsIgnoreCase("propagate")) {
                    throw new RuntimeException(me);
                }
                ProcessorUtil.handleException(me, mail, this.matcher.getMatcherConfig().getMatcherName(), this.onMatchException, LOGGER);
            }
            if (matchedRcpts != null && !matchedRcpts.isEmpty()) {
                ArrayList rcpts = new ArrayList(mail.getRecipients());
                for (MailAddress matchedRcpt : matchedRcpts) {
                    rcpts.remove(matchedRcpt);
                }
                if (rcpts.isEmpty()) {
                    fullMatch = true;
                } else {
                    mail.setRecipients(rcpts);
                    MailImpl newMail = MailImpl.duplicate((Mail)mail);
                    newMail.setRecipients(matchedRcpts);
                    newMail.setState(mail.getState());
                    newMail.setAttribute(new Attribute(MATCHER_MATCHED_ATTRIBUTE, AttributeValue.of((Boolean)true)));
                    mails.add((Mail)newMail);
                }
            }
            if (fullMatch) {
                mail.setAttribute(new Attribute(MATCHER_MATCHED_ATTRIBUTE, AttributeValue.of((Boolean)true)));
            }
            mails.add(mail);
            ArrayList<Mail> arrayList = mails;
            return arrayList;
        }
        finally {
            timeMetric.stopAndPublish();
            long complete = System.currentTimeMillis() - start;
            List<AbstractStateMailetProcessor.MailetProcessorListener> listeners = this.container.getListeners();
            for (AbstractStateMailetProcessor.MailetProcessorListener listener : listeners) {
                if (matchedRcpts == null || matchedRcpts.isEmpty()) {
                    listener.afterMatcher(this.matcher, mail.getName(), origRcpts, null, complete, ex);
                    continue;
                }
                listener.afterMatcher(this.matcher, mail.getName(), origRcpts, matchedRcpts, complete, ex);
            }
        }
    }
}

