/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel.jpql;

import java.util.TreeSet;
import org.apache.openjpa.kernel.jpql.Token;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class ParseException
extends UserException {
    private static final Localizer _loc = Localizer.forPackage(ParseException.class);

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super(ParseException.initMessage(currentTokenVal, expectedTokenSequencesVal, tokenImageVal));
    }

    public ParseException() {
    }

    public ParseException(String message) {
        super(message);
    }

    public ParseException(String message, Throwable t) {
        super(message, t);
    }

    private static Localizer.Message initMessage(Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        TreeSet<String> expected = new TreeSet<String>();
        int maxSize = 0;
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (maxSize < expectedTokenSequences[i].length) {
                maxSize = expectedTokenSequences[i].length;
            }
            for (int j = 0; j < expectedTokenSequences[i].length; ++j) {
                expected.add(tokenImage[expectedTokenSequences[i][j]]);
            }
        }
        Token tok = currentToken.next;
        StringBuffer curtokBuf = new StringBuffer();
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                curtokBuf.append(" ");
            }
            if (tok.kind == 0) {
                curtokBuf.append(tokenImage[0]);
                break;
            }
            curtokBuf.append(ParseException.escape(tok.image));
            tok = tok.next;
        }
        String curtok = curtokBuf.toString();
        return _loc.get("bad-parse", new Object[]{curtok, currentToken.next.beginColumn, expected});
    }

    private static String escape(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

