/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.main;

import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.ImapDecoder;
import org.apache.james.imap.decode.ImapDecoderFactory;
import org.apache.james.imap.decode.main.DefaultImapDecoder;
import org.apache.james.imap.decode.parser.ImapParserFactory;
import org.apache.james.imap.message.response.UnpooledStatusResponseFactory;

public class DefaultImapDecoderFactory
implements ImapDecoderFactory {
    private final StatusResponseFactory statusResponseFactory;
    private final ImapCommandParserFactory imapCommandParserFactory;

    public DefaultImapDecoderFactory() {
        this(new UnpooledStatusResponseFactory());
    }

    public DefaultImapDecoderFactory(StatusResponseFactory statusResponseFactory) {
        this.statusResponseFactory = statusResponseFactory;
        this.imapCommandParserFactory = new ImapParserFactory(statusResponseFactory);
    }

    public DefaultImapDecoderFactory(ImapCommandParserFactory imapCommandParserFactory, StatusResponseFactory statusResponseFactory) {
        this.statusResponseFactory = statusResponseFactory;
        this.imapCommandParserFactory = imapCommandParserFactory;
    }

    @Override
    public ImapDecoder buildImapDecoder() {
        return new DefaultImapDecoder(this.statusResponseFactory, this.imapCommandParserFactory);
    }
}

