/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Objects;
import javax.xml.datatype.Duration;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.cdt.CompositeDatatypeList;
import org.apache.jena.cdt.CompositeDatatypeMap;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprNotComparableException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.ValueSpace;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.util.NodeCmp;

class NVCompare {
    NVCompare() {
    }

    public static boolean sameValueAs(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null || nv2 == null) {
            throw new ARQInternalErrorException("Attempt to sameValueAs on a null");
        }
        ValueSpace compType = NodeValue.classifyValueOp(nv1, nv2);
        if (nv1.equals(nv2) && nv1.getNode() != null && nv2.getNode() != null && nv1.getNode().equals(nv2.asNode())) {
            return NVCompare.sameExceptNaN(nv1, nv2);
        }
        switch (compType) {
            case VSPACE_NUM: {
                return XSDFuncOp.compareNumeric(nv1, nv2) == 0;
            }
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: {
                int x = XSDFuncOp.compareDateTime(nv1, nv2);
                if (x == 2) {
                    throw new ExprNotComparableException("Indeterminate dateTime comparison");
                }
                return x == 0;
            }
            case VSPACE_DURATION: {
                int x = XSDFuncOp.compareDuration(nv1, nv2);
                if (x == 2) {
                    throw new ExprNotComparableException("Indeterminate duration comparison");
                }
                return x == 0;
            }
            case VSPACE_STRING: {
                return XSDFuncOp.compareString(nv1, nv2) == 0;
            }
            case VSPACE_BOOLEAN: {
                return XSDFuncOp.compareBoolean(nv1, nv2) == 0;
            }
            case VSPACE_TRIPLE_TERM: {
                Triple t1 = nv1.getNode().getTriple();
                Triple t2 = nv2.getNode().getTriple();
                return NVCompare.nSameValueAs(t1.getSubject(), t2.getSubject()) && NVCompare.nSameValueAs(t1.getPredicate(), t2.getPredicate()) && NVCompare.nSameValueAs(t1.getObject(), t2.getObject());
            }
            case VSPACE_LANG: {
                return NodeFunctions.sameTerm(nv1.asNode(), nv2.asNode());
            }
            case VSPACE_URI: 
            case VSPACE_BLANKNODE: 
            case VSPACE_UNDEF: 
            case VSPACE_VARIABLE: {
                return NodeFunctions.sameTerm(nv1.getNode(), nv2.getNode());
            }
            case VSPACE_UNKNOWN: {
                boolean hasLangDir2;
                boolean hasLang2;
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                if (!SystemARQ.ValueExtensions) {
                    NVCompare.raise(new ExprEvalException("Unknown equality test: " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
                }
                if (!node1.isLiteral() || !node2.isLiteral()) {
                    return false;
                }
                if (NodeFunctions.sameTerm(node1, node2)) {
                    return true;
                }
                boolean hasLang1 = NodeFunctions.hasLang(node1);
                if (hasLang1 != (hasLang2 = NodeFunctions.hasLang(node2))) {
                    return false;
                }
                boolean hasLangDir1 = NodeFunctions.hasLangDir(node1);
                if (hasLangDir1 != (hasLangDir2 = NodeFunctions.hasLangDir(node2))) {
                    return false;
                }
                NVCompare.raise(new ExprEvalException("Unknown equality test: " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
                throw new ARQInternalErrorException("raise returned (sameValueAs)");
            }
            case VSPACE_SORTKEY: {
                return nv1.getSortKey().compareTo(nv2.getSortKey()) == 0;
            }
            case VSPACE_DIFFERENT: {
                if (!SystemARQ.ValueExtensions && nv1.isLiteral() && nv2.isLiteral()) {
                    NVCompare.raise(new ExprEvalException("Incompatible: " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
                }
                return false;
            }
            case VSPACE_CDT_LIST: {
                LiteralLabel lit1 = nv1.asNode().getLiteral();
                LiteralLabel lit2 = nv2.asNode().getLiteral();
                return CompositeDatatypeList.datatype().isEqual(lit1, lit2);
            }
            case VSPACE_CDT_MAP: {
                LiteralLabel lit1 = nv1.asNode().getLiteral();
                LiteralLabel lit2 = nv2.asNode().getLiteral();
                return CompositeDatatypeMap.datatype().isEqual(lit1, lit2);
            }
        }
        throw new ARQInternalErrorException("sameValueAs failure " + String.valueOf(nv1) + " and " + String.valueOf(nv2));
    }

    private static boolean sameExceptNaN(NodeValue nv1, NodeValue nv2) {
        if (nv1.isDouble() && Double.isNaN(nv1.getDouble())) {
            return false;
        }
        return !nv1.isFloat() || !Float.isNaN(nv1.getFloat());
    }

    private static boolean nSameValueAs(Node n1, Node n2) {
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        return NVCompare.sameValueAs(nv1, nv2);
    }

    private static boolean notSameAs(Node n1, Node n2) {
        return NVCompare.notSameValueAs(NodeValue.makeNode(n1), NodeValue.makeNode(n2));
    }

    static boolean notSameValueAs(NodeValue nv1, NodeValue nv2) {
        return !NVCompare.sameValueAs(nv1, nv2);
    }

    public static int compareByValue(NodeValue nv1, NodeValue nv2) {
        return NVCompare.compareByValue$(nv1, nv2, false);
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        return NVCompare.compareWithOrdering(nv1, nv2);
    }

    static int compareByValue$(NodeValue nv1, NodeValue nv2, boolean sortOrderingCompare) {
        if (nv1 == null && nv2 == null) {
            return 0;
        }
        if (nv1 == null) {
            return -1;
        }
        if (nv2 == null) {
            return 1;
        }
        ValueSpace compType = NVCompare.classifyValueOp(nv1, nv2);
        if (nv1.hasNode() && nv2.hasNode() && compType != ValueSpace.VSPACE_CDT_LIST && compType != ValueSpace.VSPACE_CDT_MAP && nv1.getNode().equals(nv2.getNode())) {
            return 0;
        }
        switch (compType) {
            case VSPACE_UNDEF: {
                if (sortOrderingCompare) {
                    return NodeCmp.compareRDFTerms(nv1.asNode(), nv2.asNode());
                }
                NVCompare.raise(new ExprNotComparableException("Can't compare (incompatible value spaces) " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
            case VSPACE_DATETIME: 
            case VSPACE_DATE: 
            case VSPACE_TIME: {
                if (sortOrderingCompare) {
                    return XSDFuncOp.compareDateTimeFO(nv1, nv2);
                }
                if (nv1.getDatatypeURI().equals(nv2.getDatatypeURI())) {
                    return XSDFuncOp.compareDateTime(nv1, nv2);
                }
                NVCompare.raise(new ExprNotComparableException("Can't compare (incompatible temporal value spaces) " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
            }
            case VSPACE_DURATION: {
                int x = XSDFuncOp.compareDuration(nv1, nv2);
                if (x == 0) {
                    Duration d1 = nv1.getDuration();
                    Duration d2 = nv2.getDuration();
                    if (XSDFuncOp.isDayTime(d1) && XSDFuncOp.isYearMonth(d2) || XSDFuncOp.isDayTime(d2) && XSDFuncOp.isYearMonth(d1)) {
                        x = 2;
                    }
                }
                return x;
            }
            case VSPACE_NUM: {
                return XSDFuncOp.compareNumeric(nv1, nv2);
            }
            case VSPACE_SORTKEY: {
                return nv1.getSortKey().compareTo(nv2.getSortKey());
            }
            case VSPACE_BOOLEAN: {
                return XSDFuncOp.compareBoolean(nv1, nv2);
            }
            case VSPACE_LANG: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                int x = StrUtils.strCompareIgnoreCase(node1.getLiteralLanguage(), node2.getLiteralLanguage());
                if (x != 0) {
                    if (!sortOrderingCompare) {
                        NVCompare.raise(new ExprNotComparableException("Can't compare (different languages) " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
                    }
                    return x;
                }
                x = NVCompare.strcompare(node1.getLiteralLexicalForm(), node2.getLiteralLexicalForm());
                if (x != 0) {
                    return x;
                }
                x = StrUtils.strCompare(node1.getLiteralLanguage(), node2.getLiteralLanguage());
                if (x == 0 && !NodeFunctions.sameTerm(node1, node2)) {
                    throw new ARQInternalErrorException("Looks like the same (lang tags) but not node equals");
                }
                return x;
            }
            case VSPACE_STRING: {
                int x = XSDFuncOp.compareString(nv1, nv2);
                return x;
            }
            case VSPACE_TRIPLE_TERM: {
                Triple t1 = nv1.asNode().getTriple();
                Triple t2 = nv2.asNode().getTriple();
                int x = NVCompare.nCompare(t1.getSubject(), t2.getSubject(), sortOrderingCompare);
                if (x != 0) {
                    return x;
                }
                x = NVCompare.nCompare(t1.getPredicate(), t2.getPredicate(), sortOrderingCompare);
                if (x != 0) {
                    return x;
                }
                return NVCompare.nCompare(t1.getObject(), t2.getObject(), sortOrderingCompare);
            }
            case VSPACE_BLANKNODE: {
                String label1 = nv1.asNode().getBlankNodeLabel();
                String label2 = nv2.asNode().getBlankNodeLabel();
                int x = NVCompare.compareRepresentations(label1, label2, sortOrderingCompare);
                if (x != 2) {
                    return x;
                }
                NVCompare.raise(new ExprNotComparableException("Can't compare blank nodes as values " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
            }
            case VSPACE_URI: {
                String uri1 = nv1.asNode().getURI();
                String uri2 = nv2.asNode().getURI();
                int x = NVCompare.compareRepresentations(uri1, uri2, sortOrderingCompare);
                if (x != 2) {
                    return x;
                }
                NVCompare.raise(new ExprNotComparableException("Can't compare URIs as values " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
            }
            case VSPACE_VARIABLE: {
                String name1 = nv1.asNode().getName();
                String name2 = nv2.asNode().getName();
                int x = NVCompare.compareRepresentations(name1, name2, sortOrderingCompare);
                if (x != 2) {
                    return x;
                }
                NVCompare.raise(new ExprNotComparableException("Can't compare valiables as values " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
            }
            case VSPACE_CDT_LIST: {
                LiteralLabel lit1 = nv1.asNode().getLiteral();
                LiteralLabel lit2 = nv2.asNode().getLiteral();
                try {
                    return CompositeDatatypeList.compare(lit1, lit2, sortOrderingCompare);
                }
                catch (ExprNotComparableException e2) {
                    NVCompare.raise(e2);
                }
            }
            case VSPACE_CDT_MAP: {
                LiteralLabel lit1 = nv1.asNode().getLiteral();
                LiteralLabel lit2 = nv2.asNode().getLiteral();
                try {
                    return CompositeDatatypeMap.compare(lit1, lit2, sortOrderingCompare);
                }
                catch (ExprNotComparableException e3) {
                    NVCompare.raise(e3);
                }
            }
            case VSPACE_UNKNOWN: {
                Node node1 = nv1.asNode();
                Node node2 = nv2.asNode();
                if (NodeFunctions.sameTerm(node1, node2)) {
                    return 0;
                }
                if (sortOrderingCompare) {
                    return NodeCmp.compareRDFTerms(node1, node2);
                }
                NVCompare.raise(new ExprNotComparableException("Can't compare " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
                throw new ARQInternalErrorException("NodeValue.raise returned");
            }
            case VSPACE_DIFFERENT: {
                NVCompare.raise(new ExprNotComparableException("Can't compare " + String.valueOf(nv1) + " and " + String.valueOf(nv2)));
            }
        }
        throw new ARQInternalErrorException("Compare failure " + String.valueOf(nv1) + " and " + String.valueOf(nv2));
    }

    private static int compareRepresentations(String string1, String string2, boolean sortOrderingCompare) {
        if (sortOrderingCompare) {
            return NVCompare.strcompare(string1, string2);
        }
        if (string1.equals(string2)) {
            return 0;
        }
        return -9;
    }

    private static ValueSpace classifyValueOp(NodeValue nv1, NodeValue nv2) {
        ValueSpace vs2;
        ValueSpace vs1 = ValueSpace.valueSpace(nv1);
        if (vs1 == (vs2 = ValueSpace.valueSpace(nv2))) {
            return vs1;
        }
        return ValueSpace.VSPACE_UNDEF;
    }

    public static void raise(ExprException ex) {
        throw ex;
    }

    public static int compareWithOrdering(NodeValue nv1, NodeValue nv2) {
        Objects.requireNonNull(nv1);
        Objects.requireNonNull(nv2);
        if (nv1.hasNode() && nv2.hasNode() && nv1.getNode().equals(nv2.getNode())) {
            return 0;
        }
        ValueSpace vs1 = ValueSpace.valueSpace(nv1);
        ValueSpace vs2 = ValueSpace.valueSpace(nv2);
        if (vs1 == ValueSpace.VSPACE_UNKNOWN || vs2 == ValueSpace.VSPACE_UNKNOWN) {
            if (vs1 != ValueSpace.VSPACE_UNKNOWN) {
                return -1;
            }
            if (vs2 != ValueSpace.VSPACE_UNKNOWN) {
                return 1;
            }
            return NVCompare.NodeCmp$compareRDFTerms(nv1, nv2);
        }
        if (vs1 == ValueSpace.VSPACE_CDT_LIST && vs2 == ValueSpace.VSPACE_CDT_LIST) {
            LiteralLabel l1 = nv1.asNode().getLiteral();
            LiteralLabel l2 = nv2.asNode().getLiteral();
            return CompositeDatatypeList.compare(l1, l2, true);
        }
        if (vs1 == ValueSpace.VSPACE_CDT_MAP && vs2 == ValueSpace.VSPACE_CDT_MAP) {
            LiteralLabel l1 = nv1.asNode().getLiteral();
            LiteralLabel l2 = nv2.asNode().getLiteral();
            return CompositeDatatypeMap.compare(l1, l2, true);
        }
        int vsOrder = ValueSpace.comparisonOrder(vs1, vs2);
        if (vsOrder < 0) {
            return -1;
        }
        if (vsOrder > 0) {
            return 1;
        }
        try {
            int x1 = NVCompare.compareByValue(nv1, nv2);
            if (x1 == -1 || x1 == 1) {
                return x1;
            }
        }
        catch (ExprNotComparableException exprNotComparableException) {
            // empty catch block
        }
        return NVCompare.NodeCmp$compareRDFTerms(nv1, nv2);
    }

    private static int NodeCmp$compareRDFTerms(NodeValue nv1, NodeValue nv2) {
        return NodeCmp.compareRDFTerms(nv1.asNode(), nv2.asNode());
    }

    private static int nCompare(Node n1, Node n2, boolean sortOrderingCompare) {
        if (n1.equals(n2)) {
            return 0;
        }
        NodeValue nv1 = NodeValue.makeNode(n1);
        NodeValue nv2 = NodeValue.makeNode(n2);
        if (sortOrderingCompare) {
            return NVCompare.compareWithOrdering(nv1, nv2);
        }
        return NVCompare.compareByValue(nv1, nv2);
    }

    private static int strcompare(String string1, String string2) {
        return NVCompare.result(string1.compareTo(string2));
    }

    private static int result(int x) {
        return x == 0 ? 0 : (x > 0 ? 1 : -1);
    }
}

