/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import org.apache.jmeter.assertions.XPathAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.assertions.gui.XMLConfPanel;
import org.apache.jmeter.assertions.gui.XPathPanel;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testelement.AbstractScopedTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

@TestElementMetadata(labelResource="xpath_assertion_title")
public class XPathAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private XPathPanel xpath;
    private XMLConfPanel xml;

    public XPathAssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "xpath_assertion_title";
    }

    public TestElement createTestElement() {
        XPathAssertion el = new XPathAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public String getXPathAttributesTitle() {
        return JMeterUtils.getResString((String)"xpath_assertion_test");
    }

    public void configure(TestElement el) {
        super.configure(el);
        XPathAssertion assertion = (XPathAssertion)el;
        this.showScopeSettings((AbstractScopedTestElement)assertion, true);
        this.xpath.setXPath(assertion.getXPathString());
        this.xpath.setNegated(assertion.isNegated());
        this.xml.configure(assertion);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.makeBorder());
        Box topBox = Box.createVerticalBox();
        topBox.add(this.makeTitlePanel());
        topBox.add(this.createScopePanel(true));
        this.xml = new XMLConfPanel();
        this.xml.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"xpath_assertion_option")));
        topBox.add(this.xml);
        this.add(topBox, "North");
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        sizePanel.setBorder(BorderFactory.createTitledBorder(this.getXPathAttributesTitle()));
        this.xpath = new XPathPanel();
        sizePanel.add(this.xpath);
        this.add(sizePanel, "Center");
    }

    public void modifyTestElement(TestElement el) {
        super.configureTestElement(el);
        if (el instanceof XPathAssertion) {
            XPathAssertion assertion = (XPathAssertion)el;
            this.saveScopeSettings((AbstractScopedTestElement)assertion);
            assertion.setNegated(this.xpath.isNegated());
            assertion.setXPathString(this.xpath.getXPath());
            this.xml.modifyTestElement(assertion);
        }
    }

    public void clearGui() {
        super.clearGui();
        this.xpath.setXPath("/");
        this.xpath.setNegated(false);
        this.xml.setDefaultValues();
    }
}

