/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.MapResultData;
import org.apache.jmeter.report.processor.ValueResultData;

public abstract class AbstractSummaryConsumer<TData>
extends AbstractSampleConsumer {
    public static final String RESULT_VALUE_DATA = "data";
    public static final String RESULT_VALUE_IS_CONTROLLER = "isController";
    public static final String RESULT_VALUE_ITEMS = "items";
    public static final String RESULT_VALUE_OVERALL = "overall";
    public static final String RESULT_VALUE_SUPPORTS_CONTROLLERS_DISCRIMINATION = "supportsControllersDiscrimination";
    public static final String RESULT_VALUE_TITLES = "titles";
    private final Map<String, SummaryInfo> infos = new HashMap<String, SummaryInfo>();
    private final SummaryInfo overallInfo = new SummaryInfo(false);
    private final boolean supportsControllersDiscrimination;
    private boolean hasOverallResult;

    public final boolean hasOverallResult() {
        return this.hasOverallResult;
    }

    public final void setHasOverallResult(boolean hasOverallResult) {
        this.hasOverallResult = hasOverallResult;
    }

    public final boolean suppportsControllersDiscrimination() {
        return this.supportsControllersDiscrimination;
    }

    protected final SummaryInfo getOverallInfo() {
        return this.overallInfo;
    }

    protected final Map<String, SummaryInfo> getSummaryInfos() {
        return this.infos;
    }

    protected AbstractSummaryConsumer(boolean supportsControllersDiscrimination) {
        this.supportsControllersDiscrimination = supportsControllersDiscrimination;
    }

    protected abstract String getKeyFromSample(Sample var1);

    protected abstract ListResultData createDataResult(String var1, TData var2);

    protected abstract ListResultData createResultTitles();

    protected abstract void updateData(SummaryInfo var1, Sample var2);

    private MapResultData createResultFromKey(String key) {
        SummaryInfo info = key == null ? this.overallInfo : this.infos.get(key);
        MapResultData result = null;
        Object data = info.getData();
        if (data != null) {
            result = new MapResultData();
            result.setResult(RESULT_VALUE_IS_CONTROLLER, new ValueResultData(info.isController()));
            result.setResult(RESULT_VALUE_DATA, this.createDataResult(key, data));
        }
        return result;
    }

    @Override
    public void startConsuming() {
        int channelCount = this.getConsumedChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            super.setProducedMetadata(this.getConsumedMetadata(i), i);
        }
        super.startProducing();
    }

    @Override
    public void consume(Sample sample, int channel) {
        String key = this.getKeyFromSample(sample);
        SummaryInfo info = this.infos.get(key);
        if (info == null) {
            info = new SummaryInfo(this.supportsControllersDiscrimination && sample.isController());
            this.infos.put(key, info);
        }
        this.updateData(info, sample);
        super.produce(sample, channel);
    }

    @Override
    public void stopConsuming() {
        MapResultData overallResult;
        MapResultData result = new MapResultData();
        result.setResult(RESULT_VALUE_SUPPORTS_CONTROLLERS_DISCRIMINATION, new ValueResultData(this.supportsControllersDiscrimination));
        result.setResult(RESULT_VALUE_TITLES, this.createResultTitles());
        if (this.hasOverallResult && (overallResult = this.createResultFromKey(null)) != null) {
            result.setResult(RESULT_VALUE_OVERALL, overallResult);
        }
        ListResultData itemsResult = new ListResultData();
        for (String key : this.infos.keySet()) {
            MapResultData keyResult = this.createResultFromKey(key);
            if (keyResult == null) continue;
            itemsResult.addResult(keyResult);
        }
        result.setResult(RESULT_VALUE_ITEMS, itemsResult);
        this.setDataToContext(this.getName(), result);
        super.stopProducing();
        this.infos.clear();
        this.overallInfo.setData(null);
    }

    protected class SummaryInfo {
        final boolean isController;
        TData data;

        public final boolean isController() {
            return this.isController;
        }

        public final TData getData() {
            return this.data;
        }

        public final void setData(TData data) {
            this.data = data;
        }

        public SummaryInfo(boolean isController) {
            this.isController = isController;
        }
    }
}

