/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.completer;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.CommandWithAction;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.CommandSessionHolder;
import org.apache.karaf.shell.console.CompletableFunction;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.NameScoping;
import org.apache.karaf.shell.console.completer.FileCompleter;
import org.apache.karaf.shell.console.completer.NullCompleter;
import org.apache.karaf.shell.console.completer.Parser;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OldArgumentCompleter
implements Completer {
    private static final Logger LOGGER = LoggerFactory.getLogger(OldArgumentCompleter.class);
    public static final String ARGUMENTS_LIST = "ARGUMENTS_LIST";
    final Completer commandCompleter;
    final Completer optionsCompleter;
    final List<Completer> argsCompleters;
    final Map<String, Completer> optionalCompleters;
    final CommandWithAction function;
    final Map<Option, Field> fields = new HashMap<Option, Field>();
    final Map<String, Option> options = new HashMap<String, Option>();
    final Map<Integer, Field> arguments = new HashMap<Integer, Field>();
    boolean strict = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OldArgumentCompleter(CommandSession session, CommandWithAction function, String command) {
        this.function = function;
        this.commandCompleter = new StringsCompleter(this.getNames(session, command));
        for (Class<? extends Action> type = function.getActionClass(); type != null; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                Argument argument;
                Option option = field.getAnnotation(Option.class);
                if (option != null) {
                    this.fields.put(option, field);
                    this.options.put(option.name(), option);
                    String[] aliases = option.aliases();
                    if (aliases != null) {
                        for (String alias : aliases) {
                            this.options.put(alias, option);
                        }
                    }
                }
                if ((argument = field.getAnnotation(Argument.class)) == null) continue;
                Integer key = argument.index();
                if (this.arguments.containsKey(key)) {
                    LOGGER.warn("Duplicate @Argument annotations on class " + type.getName() + " for index: " + key + " see: " + field);
                    continue;
                }
                this.arguments.put(key, field);
            }
        }
        this.optionsCompleter = new StringsCompleter(this.options.keySet());
        this.argsCompleters = new ArrayList<Completer>();
        if (function instanceof CompletableFunction) {
            Map<String, Completer> opt;
            try {
                opt = ((CompletableFunction)((Object)function)).getOptionalCompleters();
            }
            catch (Throwable t) {
                opt = new HashMap<String, Completer>();
            }
            this.optionalCompleters = opt;
            List<Completer> fcl = ((CompletableFunction)((Object)function)).getCompleters();
            if (fcl != null) {
                for (Completer c : fcl) {
                    this.argsCompleters.add(c == null ? NullCompleter.INSTANCE : c);
                }
            } else {
                this.argsCompleters.add(NullCompleter.INSTANCE);
            }
        } else {
            this.optionalCompleters = new HashMap<String, Completer>();
            HashMap<Integer, Method> methods = new HashMap<Integer, Method>();
            for (Class<? extends Action> type = function.getActionClass(); type != null; type = type.getSuperclass()) {
                for (Method method : type.getDeclaredMethods()) {
                    CompleterValues completerMethod = method.getAnnotation(CompleterValues.class);
                    if (completerMethod == null) continue;
                    int index = completerMethod.index();
                    Integer key = index;
                    if (index >= this.arguments.size() || index < 0) {
                        LOGGER.warn("Index out of range on @CompleterValues on class " + type.getName() + " for index: " + key + " see: " + method);
                    }
                    if (methods.containsKey(key)) {
                        LOGGER.warn("Duplicate @CompleterMethod annotations on class " + type.getName() + " for index: " + key + " see: " + method);
                        continue;
                    }
                    methods.put(key, method);
                }
            }
            int size = this.arguments.size();
            for (int i = 0; i < size; ++i) {
                Completer argCompleter = NullCompleter.INSTANCE;
                Method method = (Method)methods.get(i);
                if (method != null) {
                    Action action = function.createNewAction();
                    try {
                        Object value = method.invoke((Object)action, new Object[0]);
                        if (value instanceof String[]) {
                            argCompleter = new StringsCompleter((String[])value);
                        }
                        if (value instanceof Collection) {
                            argCompleter = new StringsCompleter((Collection)value);
                        }
                        LOGGER.warn("Could not use value " + value + " as set of completions!");
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.warn("Could not invoke @CompleterMethod on " + function + ". " + e, (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        Throwable target = e.getTargetException();
                        if (target == null) {
                            target = e;
                        }
                        LOGGER.warn("Could not invoke @CompleterMethod on " + function + ". " + target, target);
                    }
                    finally {
                        try {
                            function.releaseAction(action);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to release action: " + action + ". " + e, (Throwable)e);
                        }
                    }
                } else {
                    Field field = this.arguments.get(i);
                    Class<Object> type = field.getType();
                    if (type.isAssignableFrom(File.class)) {
                        argCompleter = new FileCompleter(session);
                    } else if (type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE)) {
                        argCompleter = new StringsCompleter(new String[]{"false", "true"}, false);
                    } else if (type.isAssignableFrom(Enum.class)) {
                        HashSet<String> values = new HashSet<String>();
                        for (Object o : EnumSet.allOf(type)) {
                            values.add(o.toString());
                        }
                        argCompleter = new StringsCompleter(values, false);
                    }
                }
                this.argsCompleters.add(argCompleter);
            }
        }
    }

    private String[] getNames(CommandSession session, String scopedCommand) {
        String command = NameScoping.getCommandNameWithoutGlobalPrefix(session, scopedCommand);
        String[] s = command.split(":");
        if (s.length == 1) {
            return s;
        }
        return new String[]{command, s[1]};
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public boolean getStrict() {
        return this.strict;
    }

    @Override
    public int complete(String buffer, int cursor, List<String> candidates) {
        int ret;
        Option option;
        Field lastField;
        Option lastOption;
        int lastAgurmentIndex;
        ArgumentList list = this.delimit(buffer, cursor);
        int argpos = list.getArgumentPosition();
        int argIndex = list.getCursorArgumentIndex();
        CommandSession commandSession = CommandSessionHolder.getSession();
        if (commandSession != null) {
            commandSession.put(ARGUMENTS_LIST, list);
        }
        Completer comp = null;
        String[] args = list.getArguments();
        int index = 0;
        if (index < argIndex) {
            if (!this.verifyCompleter(this.commandCompleter, args[index])) {
                return -1;
            }
            ++index;
        } else {
            comp = this.commandCompleter;
        }
        if (comp == null) {
            while (index < argIndex && args[index].startsWith("-")) {
                if (!this.verifyCompleter(this.optionsCompleter, args[index])) {
                    return -1;
                }
                Option option2 = this.options.get(args[index]);
                if (option2 == null) {
                    return -1;
                }
                Field field = this.fields.get(option2);
                if (field != null && field.getType() != Boolean.TYPE && field.getType() != Boolean.class && ++index == argIndex) {
                    comp = NullCompleter.INSTANCE;
                }
                ++index;
            }
            if (comp == null && index >= argIndex && index < args.length && args[index].startsWith("-")) {
                comp = this.optionsCompleter;
            }
        }
        if ((lastAgurmentIndex = argIndex - 1) >= 1 && (lastOption = this.options.get(args[lastAgurmentIndex])) != null && (lastField = this.fields.get(lastOption)) != null && lastField.getType() != Boolean.TYPE && lastField.getType() != Boolean.class && (option = lastField.getAnnotation(Option.class)) != null) {
            String[] aliases;
            Completer optionValueCompleter = null;
            String name = option.name();
            if (this.optionalCompleters != null && name != null && (optionValueCompleter = this.optionalCompleters.get(name)) == null && (aliases = option.aliases()).length > 0) {
                for (int i = 0; i < aliases.length && optionValueCompleter == null; ++i) {
                    optionValueCompleter = this.optionalCompleters.get(option.aliases()[i]);
                }
            }
            if (optionValueCompleter != null) {
                comp = optionValueCompleter;
            }
        }
        if (comp == null) {
            int indexArg = 0;
            while (index < argIndex) {
                Completer sub = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
                if (!this.verifyCompleter(sub, args[index])) {
                    return -1;
                }
                ++index;
                ++indexArg;
            }
            comp = this.argsCompleters.get(indexArg >= this.argsCompleters.size() ? this.argsCompleters.size() - 1 : indexArg);
        }
        if ((ret = comp.complete(list.getCursorArgument(), argpos, candidates)) == -1) {
            return -1;
        }
        int pos = ret + (list.getBufferPosition() - argpos);
        if (buffer != null && cursor != buffer.length() && this.isDelimiter(buffer, cursor)) {
            for (int i = 0; i < candidates.size(); ++i) {
                String val = candidates.get(i);
                while (val.length() > 0 && this.isDelimiter(val, val.length() - 1)) {
                    val = val.substring(0, val.length() - 1);
                }
                candidates.set(i, val);
            }
        }
        return pos;
    }

    protected boolean verifyCompleter(Completer completer, String argument) {
        ArrayList<String> candidates = new ArrayList<String>();
        return completer.complete(argument, argument.length(), candidates) != -1 && !candidates.isEmpty();
    }

    public ArgumentList delimit(String buffer, int cursor) {
        Parser parser = new Parser(buffer, cursor);
        try {
            List<List<List<String>>> program = parser.program();
            List<String> pipe = program.get(parser.c0).get(parser.c1);
            return new ArgumentList(pipe.toArray(new String[pipe.size()]), parser.c2, parser.c3, cursor);
        }
        catch (Throwable t) {
            return new ArgumentList(new String[]{buffer}, 0, cursor, cursor);
        }
    }

    public boolean isDelimiter(String buffer, int pos) {
        return !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isEscaped(String buffer, int pos) {
        return pos > 0 && buffer.charAt(pos) == '\\' && !this.isEscaped(buffer, pos - 1);
    }

    public boolean isDelimiterChar(String buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    public static class ArgumentList {
        private String[] arguments;
        private int cursorArgumentIndex;
        private int argumentPosition;
        private int bufferPosition;

        public ArgumentList(String[] arguments, int cursorArgumentIndex, int argumentPosition, int bufferPosition) {
            this.arguments = arguments;
            this.cursorArgumentIndex = cursorArgumentIndex;
            this.argumentPosition = argumentPosition;
            this.bufferPosition = bufferPosition;
        }

        public void setCursorArgumentIndex(int cursorArgumentIndex) {
            this.cursorArgumentIndex = cursorArgumentIndex;
        }

        public int getCursorArgumentIndex() {
            return this.cursorArgumentIndex;
        }

        public String getCursorArgument() {
            if (this.cursorArgumentIndex < 0 || this.cursorArgumentIndex >= this.arguments.length) {
                return null;
            }
            return this.arguments[this.cursorArgumentIndex];
        }

        public void setArgumentPosition(int argumentPosition) {
            this.argumentPosition = argumentPosition;
        }

        public int getArgumentPosition() {
            return this.argumentPosition;
        }

        public void setArguments(String[] arguments) {
            this.arguments = arguments;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setBufferPosition(int bufferPosition) {
            this.bufferPosition = bufferPosition;
        }

        public int getBufferPosition() {
            return this.bufferPosition;
        }
    }
}

