/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeatureFinder;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.console.AbstractAction;

@Command(scope="feature", name="repo-refresh", description="Refresh a features repository")
public class RepoRefreshCommand
extends AbstractAction {
    @Argument(index=0, name="Feature name or uri", description="Shortcut name of the feature repository or the full URI", required=false, multiValued=false)
    private String nameOrUrl;
    @Argument(index=1, name="Feature version", description="The version of the feature if using the feature name. Should be empty if using the uri", required=false, multiValued=false)
    private String version;
    private FeatureFinder featureFinder;
    private FeaturesService featuresService;

    public void setFeatureFinder(FeatureFinder featureFinder) {
        this.featureFinder = featureFinder;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    protected Object doExecute() throws Exception {
        if (this.nameOrUrl != null) {
            String effectiveVersion = this.version == null ? "LATEST" : this.version;
            URI uri = this.featureFinder.getUriFor(this.nameOrUrl, effectiveVersion);
            if (uri == null) {
                ArrayList<URI> uris = new ArrayList<URI>();
                Pattern pattern = Pattern.compile(this.nameOrUrl);
                for (Repository r : this.featuresService.listRepositories()) {
                    URI u = r.getURI();
                    Matcher matcher = pattern.matcher(u.toString());
                    if (!matcher.matches()) continue;
                    uris.add(u);
                }
                for (URI u : uris) {
                    System.out.println("Refreshing feature url " + u);
                    this.featuresService.refreshRepository(u);
                }
            } else {
                System.out.println("Refreshing feature url " + uri);
                this.featuresService.refreshRepository(uri);
            }
        } else {
            this.refreshAll();
        }
        return null;
    }

    private void refreshAll() {
        Repository[] repos;
        for (Repository repo : repos = this.featuresService.listRepositories()) {
            try {
                System.out.println("Refreshing feature url " + repo.getURI());
                this.featuresService.refreshRepository(repo.getURI());
            }
            catch (Exception e) {
                System.err.println("Error refreshing " + repo.getURI().toString() + ": " + e.getMessage());
            }
        }
    }
}

