/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.log.command;

import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.AbstractAction;
import org.osgi.service.log.LogService;

@Command(scope="log", name="log", description="Log a message.")
public class LogEntry
extends AbstractAction {
    @Argument(index=0, name="message", description="The message to log", required=true, multiValued=false)
    private String message;
    @Option(name="--level", aliases={"-l"}, description="The level the message will be logged at", required=false, multiValued=false)
    private String level = "INFO";
    private LogService logService;
    private final Map<String, Integer> mappings = new HashMap<String, Integer>();

    public LogEntry(LogService logService) {
        this.logService = logService;
        this.mappings.put("ERROR", 1);
        this.mappings.put("WARNING", 2);
        this.mappings.put("INFO", 3);
        this.mappings.put("DEBUG", 4);
    }

    protected Object doExecute() throws Exception {
        this.logService.log(this.toLevel(this.level.toUpperCase()), this.message);
        return null;
    }

    private int toLevel(String logLevel) {
        Integer level = this.mappings.get(logLevel);
        if (level == null) {
            level = 3;
        }
        return level;
    }
}

