/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.service.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.service.command.Function;
import org.apache.karaf.service.command.ObjectClassMatcher;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.util.ShellUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@Command(scope="service", name="list", description="Lists OSGi services.")
public class ListServices
extends OsgiCommandSupport {
    @Argument(index=0, name="objectClass", description="Name of service objectClass to filter for", required=false, multiValued=false)
    String objectClass;
    @Option(name="-a", aliases={}, description="Shows all services. (By default Karaf commands are hidden)", required=false, multiValued=false)
    boolean showAll;
    @Option(name="-n", aliases={}, description="Shows only service class names", required=false, multiValued=false)
    boolean onlyNames;

    protected Object doExecute() throws Exception {
        Bundle[] bundles;
        if (this.onlyNames) {
            this.listNames();
            return null;
        }
        ArrayList<ServiceReference> serviceRefs = new ArrayList<ServiceReference>();
        for (Bundle bundle : bundles = this.getBundleContext().getBundles()) {
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services == null) continue;
            for (ServiceReference ref : services) {
                String[] objectClasses = (String[])ref.getProperty("objectClass");
                if (this.objectClass != null && !ObjectClassMatcher.matchesAtLeastOneName(objectClasses, this.objectClass)) continue;
                serviceRefs.add(ref);
            }
        }
        Collections.sort(serviceRefs, new ServiceClassComparator());
        for (ServiceReference serviceRef : serviceRefs) {
            if (!this.showAll && this.isCommand((String[])serviceRef.getProperty("objectClass"))) continue;
            this.printServiceRef(serviceRef);
        }
        return null;
    }

    private void listNames() {
        Map<String, Integer> serviceNames = ListServices.getServiceNamesMap(this.getBundleContext());
        ArrayList<String> serviceNamesList = new ArrayList<String>(serviceNames.keySet());
        Collections.sort(serviceNamesList);
        for (String name : serviceNamesList) {
            System.out.println(name + " (" + serviceNames.get(name) + ")");
        }
    }

    public static Map<String, Integer> getServiceNamesMap(BundleContext bundleContext) {
        Bundle[] bundles;
        HashMap<String, Integer> serviceNames = new HashMap<String, Integer>();
        for (Bundle bundle : bundles = bundleContext.getBundles()) {
            ServiceReference[] services = bundle.getRegisteredServices();
            if (services == null) continue;
            for (ServiceReference serviceReference : services) {
                String[] names;
                for (String name : names = (String[])serviceReference.getProperty("objectClass")) {
                    int curCount = serviceNames.containsKey(name) ? (Integer)serviceNames.get(name) : 0;
                    serviceNames.put(name, curCount + 1);
                }
            }
        }
        return serviceNames;
    }

    private void printServiceRef(ServiceReference<?> serviceRef) {
        String[] objectClass = (String[])serviceRef.getProperty("objectClass");
        String serviceClasses = ShellUtil.getValueString((Object)objectClass);
        System.out.println(serviceClasses);
        System.out.println(ShellUtil.getUnderlineString((String)serviceClasses));
        this.printProperties(serviceRef);
        String bundleName = ShellUtil.getBundleName((Bundle)serviceRef.getBundle());
        System.out.println("Provided by : ");
        System.out.println(" " + bundleName);
        if (serviceRef.getUsingBundles() != null) {
            System.out.println("Used by: ");
            for (Bundle bundle : serviceRef.getUsingBundles()) {
                System.out.println(" " + ShellUtil.getBundleName((Bundle)bundle));
            }
        }
        System.out.println();
    }

    private boolean isCommand(String[] objectClasses) {
        for (String objectClass : objectClasses) {
            if (!objectClass.equals(Function.class.getName())) continue;
            return true;
        }
        return false;
    }

    private void printProperties(ServiceReference<?> serviceRef) {
        for (String key : serviceRef.getPropertyKeys()) {
            if ("objectClass".equals(key)) continue;
            System.out.println(" " + key + " = " + ShellUtil.getValueString((Object)serviceRef.getProperty(key)));
        }
    }

    public final class ServiceClassComparator
    implements Comparator<ServiceReference<?>> {
        @Override
        public int compare(ServiceReference<?> o1, ServiceReference<?> o2) {
            String[] classes1 = (String[])o1.getProperty("objectClass");
            String[] classes2 = (String[])o2.getProperty("objectClass");
            return classes1[0].compareTo(classes2[0]);
        }
    }
}

