/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class BundleSelectorImpl {
    private final BundleContext bundleContext;

    public BundleSelectorImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public List<Bundle> selectBundles(List<String> ids, boolean defaultAllBundles) {
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        if (ids != null && !ids.isEmpty()) {
            for (String id : ids) {
                if (id == null) continue;
                this.addMatchingBundles(id, bundles);
            }
        } else if (defaultAllBundles) {
            Collections.addAll(bundles, this.bundleContext.getBundles());
        }
        return bundles;
    }

    public void addMatchingBundles(String id, List<Bundle> bundles) {
        Pattern pattern = Pattern.compile("^\\d+$");
        Matcher matcher = pattern.matcher(id);
        if (matcher.matches()) {
            Bundle bundle = this.getBundleById(id);
            this.addBundle(bundle, id, bundles);
            return;
        }
        pattern = Pattern.compile("^(\\d+)-(\\d+)$");
        matcher = pattern.matcher(id);
        if (matcher.matches()) {
            long endId;
            int index = id.indexOf(45);
            long startId = Long.parseLong(id.substring(0, index));
            if (startId < (endId = Long.parseLong(id.substring(index + 1)))) {
                for (long i = startId; i <= endId; ++i) {
                    Bundle bundle = this.bundleContext.getBundle(i);
                    this.addBundle(bundle, String.valueOf(i), bundles);
                }
            }
            return;
        }
        int index = id.indexOf(47);
        List<Bundle> bundlesByName = null;
        bundlesByName = index != -1 ? this.getBundleByNameAndVersion(id.substring(0, index), id.substring(index + 1)) : this.getBundleByName(id);
        for (Bundle bundleByName : bundlesByName) {
            this.addBundle(bundleByName, id, bundles);
        }
    }

    private void addBundle(Bundle bundle, String id, List<Bundle> bundles) {
        if (bundle == null) {
            System.err.println("Bundle " + id + " is invalid");
        } else {
            bundles.add(bundle);
        }
    }

    private Bundle getBundleById(String id) {
        Bundle bundle = null;
        try {
            long idNumber = Long.parseLong(id);
            bundle = this.bundleContext.getBundle(idNumber);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bundle;
    }

    private List<Bundle> getBundleByName(String name) {
        return this.getBundleByNameAndVersion(name, null);
    }

    private List<Bundle> getBundleByNameAndVersion(String name, String version) {
        Bundle[] bundles = this.bundleContext.getBundles();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        Pattern namePattern = Pattern.compile(name);
        for (int i = 0; i < bundles.length; ++i) {
            boolean nameMatch;
            String bundleSymbolicName = bundles[i].getSymbolicName();
            if (bundleSymbolicName == null) continue;
            Matcher symbolicNameMatcher = namePattern.matcher(bundleSymbolicName);
            Matcher nameMatcher = null;
            String bundleName = (String)bundles[i].getHeaders().get("Bundle-Name");
            if (bundleName != null) {
                nameMatcher = namePattern.matcher(bundleName);
            }
            if (version != null) {
                Pattern versionPattern;
                Matcher versionMatcher;
                boolean nameMatch2;
                String bundleVersion = (String)bundles[i].getHeaders().get("Bundle-Version");
                if (bundleVersion == null) continue;
                boolean bl = nameMatch2 = nameMatcher != null && nameMatcher.matches() || symbolicNameMatcher.matches();
                if (!nameMatch2 || !(versionMatcher = (versionPattern = Pattern.compile(version)).matcher(bundleVersion)).matches()) continue;
                result.add(bundles[i]);
                continue;
            }
            boolean bl = nameMatch = nameMatcher != null && nameMatcher.matches() || symbolicNameMatcher.matches();
            if (!nameMatch) continue;
            result.add(bundles[i]);
        }
        return result;
    }

    public List<Bundle> getBundlesByURL(String url) {
        ArrayList<Bundle> bundleList;
        block3: {
            bundleList = new ArrayList<Bundle>();
            try {
                Long id = Long.parseLong(url);
                Bundle bundle = this.bundleContext.getBundle(id.longValue());
                if (bundle == null) break block3;
                bundleList.add(bundle);
            }
            catch (NumberFormatException e) {
                for (int i = 0; i < this.bundleContext.getBundles().length; ++i) {
                    Bundle bundle = this.bundleContext.getBundles()[i];
                    if (!this.isMavenSnapshotUrl(bundle.getLocation()) || !this.wildCardMatch(bundle.getLocation(), url)) continue;
                    bundleList.add(bundle);
                }
            }
        }
        return bundleList;
    }

    private boolean isMavenSnapshotUrl(String url) {
        return url.startsWith("mvn:") && url.contains("SNAPSHOT");
    }

    private boolean wildCardMatch(String text, String pattern) {
        String[] cards;
        for (String card : cards = pattern.split("\\*")) {
            int idx = text.indexOf(card);
            if (idx == -1) {
                return false;
            }
            text = text.substring(idx + card.length());
        }
        return true;
    }
}

