/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.jms.impl;

import java.io.PrintWriter;
import javax.jms.ConnectionFactory;
import javax.jms.Session;
import javax.jms.XAConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.TransactionSupport;
import javax.security.auth.Subject;
import org.ops4j.pax.transx.connection.ExceptionSorter;
import org.ops4j.pax.transx.connection.utils.AbstractManagedConnectionFactory;
import org.ops4j.pax.transx.jms.impl.ConnectionRequestInfoImpl;
import org.ops4j.pax.transx.jms.impl.ManagedConnectionImpl;
import org.ops4j.pax.transx.jms.impl.SessionImpl;
import org.ops4j.pax.transx.jms.impl.TransxConnectionFactory;

public class ManagedConnectionFactoryImpl
extends AbstractManagedConnectionFactory<ManagedConnectionFactoryImpl, ManagedConnectionImpl, Session, SessionImpl> {
    private final XAConnectionFactory xaConnectionFactory;
    private final ConnectionFactory connectionFactory;
    private String clientID;

    public ManagedConnectionFactoryImpl(ConnectionFactory connectionFactory, XAConnectionFactory xaConnectionFactory, ExceptionSorter exceptionSorter) {
        assert (exceptionSorter != null);
        this.connectionFactory = connectionFactory;
        this.xaConnectionFactory = xaConnectionFactory;
        this.exceptionSorter = exceptionSorter;
    }

    public TransactionSupport.TransactionSupportLevel getTransactionSupport() {
        return this.xaConnectionFactory != null ? TransactionSupport.TransactionSupportLevel.XATransaction : TransactionSupport.TransactionSupportLevel.LocalTransaction;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public XAConnectionFactory getXaConnectionFactory() {
        return this.xaConnectionFactory;
    }

    @Override
    public SessionImpl createConnectionHandle(ConnectionRequestInfo cri, ManagedConnectionImpl mc) {
        return new SessionImpl(this, cri, mc);
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public Object createConnectionFactory(ConnectionManager cm) throws ResourceException {
        return new TransxConnectionFactory(this, cm);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        return new ManagedConnectionImpl(this, subject, this.exceptionSorter, (ConnectionRequestInfoImpl)connectionRequestInfo);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public Integer getUseTryLock() {
        return null;
    }
}

