/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.spi.Language;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class BeanAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String beanName = this.getFromAnnotation(annotation, "ref");
        String method = this.getFromAnnotation(annotation, "method");
        StringHelper.notEmpty((String)beanName, (String)"ref", (Object)annotation);
        if (ObjectHelper.isEmpty((Object)method)) {
            method = null;
        }
        Language lan = camelContext.resolveLanguage("bean");
        if (method != null) {
            return lan.createExpression(beanName + "?method=" + method);
        }
        return lan.createExpression(beanName);
    }

    protected String getFromAnnotation(Annotation annotation, String attribute) {
        try {
            Method method = annotation.annotationType().getDeclaredMethod(attribute, new Class[0]);
            Object value = org.apache.camel.support.ObjectHelper.invokeMethod((Method)method, (Object)annotation, (Object[])new Object[0]);
            if (value == null) {
                throw new IllegalArgumentException("Cannot determine the " + attribute + " from the annotation: " + annotation);
            }
            return value.toString();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot determine the " + attribute + " of the annotation: " + annotation + " as it does not have a " + attribute + "() method");
        }
    }
}

