/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.redirect;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.HttpCommunicationException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.redirect.RedirectActionBuilder;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.config.OAuth10Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth10RedirectActionBuilder
implements RedirectActionBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OAuth10RedirectActionBuilder.class);
    protected OAuth10Configuration configuration;
    protected IndirectClient client;

    public OAuth10RedirectActionBuilder(OAuth10Configuration configuration, IndirectClient client) {
        CommonHelper.assertNotNull((String)"client", (Object)client);
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
        this.client = client;
    }

    public RedirectAction redirect(WebContext context) {
        try {
            OAuth1RequestToken requestToken;
            OAuth10aService service = (OAuth10aService)this.configuration.buildService(context, this.client, null);
            try {
                requestToken = service.getRequestToken();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new HttpCommunicationException("Error getting token: " + e.getMessage());
            }
            logger.debug("requestToken: {}", (Object)requestToken);
            context.getSessionStore().set(context, this.configuration.getRequestTokenSessionAttributeName(this.client.getName()), (Object)requestToken);
            String authorizationUrl = service.getAuthorizationUrl(requestToken);
            logger.debug("authorizationUrl: {}", (Object)authorizationUrl);
            return RedirectAction.redirect((String)authorizationUrl);
        }
        catch (OAuthException e) {
            throw new TechnicalException((Throwable)e);
        }
    }
}

