/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.config;

import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;

public interface GatewayConfig {
    public static final String GATEWAY_HOME_VAR = "GATEWAY_HOME";
    public static final String GATEWAY_CONF_HOME_VAR = "GATEWAY_CONF_HOME";
    public static final String GATEWAY_DATA_HOME_VAR = "GATEWAY_DATA_HOME";
    public static final String GATEWAY_CONFIG_ATTRIBUTE = "org.apache.knox.gateway.config";
    public static final String HADOOP_KERBEROS_SECURED = "gateway.hadoop.kerberos.secured";
    public static final String KRB5_CONFIG = "java.security.krb5.conf";
    public static final String KRB5_DEBUG = "sun.security.krb5.debug";
    public static final String KRB5_LOGIN_CONFIG = "java.security.auth.login.config";
    public static final String KRB5_USE_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    public static final String SIGNING_KEYSTORE_NAME = "gateway.signing.keystore.name";
    public static final String SIGNING_KEY_ALIAS = "gateway.signing.key.alias";
    public static final String REMOTE_CONFIG_REGISTRY_TYPE = "type";
    public static final String REMOTE_CONFIG_REGISTRY_ADDRESS = "address";
    public static final String REMOTE_CONFIG_REGISTRY_NAMESPACE = "namespace";
    public static final String REMOTE_CONFIG_REGISTRY_AUTH_TYPE = "authType";
    public static final String REMOTE_CONFIG_REGISTRY_PRINCIPAL = "principal";
    public static final String REMOTE_CONFIG_REGISTRY_CREDENTIAL_ALIAS = "credentialAlias";
    public static final String REMOTE_CONFIG_REGISTRY_KEYTAB = "keytab";
    public static final String REMOTE_CONFIG_REGISTRY_USE_KEYTAB = "useKeytab";
    public static final String REMOTE_CONFIG_REGISTRY_USE_TICKET_CACHE = "useTicketCache";

    public String getGatewayConfDir();

    public String getGatewayDataDir();

    public String getGatewayServicesDir();

    public String getGatewayApplicationsDir();

    public String getHadoopConfDir();

    public String getGatewayHost();

    public int getGatewayPort();

    public String getGatewayPath();

    public String getGatewayProvidersConfigDir();

    public String getGatewayDescriptorsDir();

    public String getGatewayTopologyDir();

    public String getGatewaySecurityDir();

    public String getGatewayDeploymentDir();

    public InetSocketAddress getGatewayAddress() throws UnknownHostException;

    public boolean isSSLEnabled();

    public List<String> getExcludedSSLProtocols();

    public List<String> getIncludedSSLCiphers();

    public List<String> getExcludedSSLCiphers();

    public boolean isHadoopKerberosSecured();

    public String getKerberosConfig();

    public boolean isKerberosDebugEnabled();

    public String getKerberosLoginConfig();

    public String getDefaultTopologyName();

    public String getDefaultAppRedirectPath();

    public String getFrontendUrl();

    public boolean isClientAuthNeeded();

    public boolean isClientAuthWanted();

    public String getTruststorePath();

    public boolean getTrustAllCerts();

    public String getKeystoreType();

    public String getTruststoreType();

    public boolean isXForwardedEnabled();

    public String getEphemeralDHKeySize();

    public int getHttpClientMaxConnections();

    public int getHttpClientConnectionTimeout();

    public int getHttpClientSocketTimeout();

    public int getThreadPoolMax();

    public int getHttpServerRequestBuffer();

    public int getHttpServerRequestHeaderBuffer();

    public int getHttpServerResponseBuffer();

    public int getHttpServerResponseHeaderBuffer();

    public int getGatewayDeploymentsBackupVersionLimit();

    public long getGatewayDeploymentsBackupAgeLimit();

    public long getGatewayIdleTimeout();

    public String getSigningKeystoreName();

    public String getSigningKeyAlias();

    public List<String> getGlobalRulesServices();

    public boolean isWebsocketEnabled();

    public int getWebsocketMaxTextMessageSize();

    public int getWebsocketMaxBinaryMessageSize();

    public int getWebsocketMaxTextMessageBufferSize();

    public int getWebsocketMaxBinaryMessageBufferSize();

    public int getWebsocketInputBufferSize();

    public int getWebsocketAsyncWriteTimeout();

    public int getWebsocketIdleTimeout();

    public boolean isMetricsEnabled();

    public boolean isJmxMetricsReportingEnabled();

    public boolean isGraphiteMetricsReportingEnabled();

    public String getGraphiteHost();

    public int getGraphitePort();

    public int getGraphiteReportingFrequency();

    public boolean isCookieScopingToPathEnabled();

    public String getHeaderNameForRemoteAddress();

    public String getAlgorithm();

    public String getPBEAlgorithm();

    public String getTransformation();

    public String getSaltSize();

    public String getIterationCount();

    public String getKeyLength();

    public Map<String, Integer> getGatewayPortMappings();

    public boolean isGatewayPortMappingEnabled();

    public boolean isGatewayServerHeaderEnabled();

    public String getDefaultDiscoveryAddress();

    public String getDefaultDiscoveryCluster();

    public int getClusterMonitorPollingInterval(String var1);

    public boolean isClusterMonitorEnabled(String var1);

    public List<String> getRemoteRegistryConfigurationNames();

    public String getRemoteRegistryConfiguration(String var1);

    public String getRemoteConfigurationMonitorClientName();

    public boolean allowUnauthenticatedRemoteRegistryReadAccess();

    public boolean isRemoteAliasServiceEnabled();

    public List<String> getReadOnlyOverrideTopologyNames();

    public String getKnoxAdminGroups();

    public String getKnoxAdminUsers();

    public String getFederationHeaderName();

    public List<String> getAutoDeployTopologyNames();

    public String getDispatchWhitelist();

    public List<String> getDispatchWhitelistServices();

    public boolean isTopologyValidationEnabled();
}

